/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.action;

import com.tencent.kona.sun.security.util.Debug;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

public class GetPropertyAction
implements PrivilegedAction<String> {
    private final String theProp;
    private final String defaultVal;

    public GetPropertyAction(String theProp) {
        this.theProp = theProp;
        this.defaultVal = null;
    }

    public GetPropertyAction(String theProp, String defaultVal) {
        this.theProp = theProp;
        this.defaultVal = defaultVal;
    }

    @Override
    public String run() {
        String value = System.getProperty(this.theProp);
        return value == null ? this.defaultVal : value;
    }

    public static String privilegedGetProperty(String theProp) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(theProp);
        }
        return AccessController.doPrivileged(new GetPropertyAction(theProp));
    }

    public static String privilegedGetProperty(String theProp, String defaultVal) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(theProp, defaultVal);
        }
        return AccessController.doPrivileged(new GetPropertyAction(theProp, defaultVal));
    }

    public static Properties privilegedGetProperties() {
        if (System.getSecurityManager() == null) {
            return System.getProperties();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return System.getProperties();
            }
        });
    }

    public static int privilegedGetTimeoutProp(String prop, int def, Debug dbg) {
        String rawPropVal;
        if (def < 0) {
            def = 0;
        }
        if ((rawPropVal = GetPropertyAction.privilegedGetProperty(prop, "").trim()).length() == 0) {
            return def;
        }
        boolean isMillis = false;
        String propVal = rawPropVal;
        if (rawPropVal.toLowerCase().endsWith("ms")) {
            propVal = rawPropVal.substring(0, rawPropVal.length() - 2);
            isMillis = true;
        } else if (rawPropVal.toLowerCase().endsWith("s")) {
            propVal = rawPropVal.substring(0, rawPropVal.length() - 1);
        }
        if (propVal.matches("^\\d+$")) {
            try {
                int timeout = Integer.parseInt(propVal);
                return isMillis ? timeout : timeout * 1000;
            }
            catch (NumberFormatException nfe) {
                if (dbg != null) {
                    dbg.println("Warning: Unexpected " + nfe + " for timeout value " + rawPropVal + ". Using default value of " + def + " msec.");
                }
                return def;
            }
        }
        if (dbg != null) {
            dbg.println("Warning: Incorrect syntax for timeout value " + rawPropVal + ". Using default value of " + def + " msec.");
        }
        return def;
    }
}

