/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.util.math.intpoly;

import com.tencent.kona.sun.security.util.math.intpoly.IntegerPolynomial;
import java.math.BigInteger;

public class IntegerPolynomialModBinP
extends IntegerPolynomial {
    private final long[] reduceLimbs;
    private final int bitOffset;
    private final int limbMask;
    private final int rightBitOffset;
    private final int power;

    public IntegerPolynomialModBinP(int bitsPerLimb, int numLimbs, int power, BigInteger subtrahend) {
        super(bitsPerLimb, numLimbs, 1, BigInteger.valueOf(2L).pow(power).subtract(subtrahend));
        boolean negate = false;
        if (subtrahend.compareTo(BigInteger.ZERO) < 0) {
            negate = true;
            subtrahend = subtrahend.negate();
        }
        int reduceLimbsLength = subtrahend.bitLength() / bitsPerLimb + 1;
        this.reduceLimbs = new long[reduceLimbsLength];
        IntegerPolynomial.ImmutableElement reduceElem = this.getElement(subtrahend);
        if (negate) {
            reduceElem = reduceElem.additiveInverse();
        }
        System.arraycopy(reduceElem.limbs, 0, this.reduceLimbs, 0, this.reduceLimbs.length);
        System.out.println("reduce limbs:");
        for (int i = 0; i < this.reduceLimbs.length; ++i) {
            System.out.println(i + ":" + this.reduceLimbs[i]);
        }
        this.power = power;
        this.bitOffset = numLimbs * bitsPerLimb - power;
        this.limbMask = -1 >>> 64 - bitsPerLimb;
        this.rightBitOffset = bitsPerLimb - this.bitOffset;
    }

    @Override
    protected void finalCarryReduceLast(long[] limbs) {
        int extraBits = this.bitsPerLimb * this.numLimbs - this.power;
        int highBits = this.bitsPerLimb - extraBits;
        long c = limbs[this.numLimbs - 1] >> highBits;
        int n = this.numLimbs - 1;
        limbs[n] = limbs[n] - (c << highBits);
        for (int j = 0; j < this.reduceLimbs.length; ++j) {
            int reduceBits = this.power + extraBits - j * this.bitsPerLimb;
            this.modReduceInBits(limbs, this.numLimbs, reduceBits, c * this.reduceLimbs[j]);
        }
    }

    @Override
    public IntegerPolynomial.ImmutableElement getElement(byte[] v, int offset, int length, byte highByte) {
        long[] result = new long[this.numLimbs];
        int numHighBits = 32 - Integer.numberOfLeadingZeros(highByte);
        int numBits = 8 * length + numHighBits;
        int requiredLimbs = (numBits + this.bitsPerLimb - 1) / this.bitsPerLimb;
        if (requiredLimbs > this.numLimbs) {
            long[] temp = new long[requiredLimbs];
            this.encode(v, offset, length, highByte, temp);
            System.arraycopy(temp, 0, result, 0, result.length);
        } else {
            this.encode(v, offset, length, highByte, result);
        }
        return new IntegerPolynomial.ImmutableElement(this, result, 0);
    }

    private void multOnly(long[] a, long[] b, long[] c) {
        for (int i = 0; i < this.numLimbs; ++i) {
            for (int j = 0; j < this.numLimbs; ++j) {
                int n = i + j;
                c[n] = c[n] + a[i] * b[j];
            }
        }
    }

    @Override
    protected void mult(long[] a, long[] b, long[] r) {
        long[] c = new long[2 * this.numLimbs];
        this.multOnly(a, b, c);
        this.carryReduce(c, r);
    }

    private void modReduceInBits(long[] limbs, int index, int bits, long x) {
        if (bits % this.bitsPerLimb == 0) {
            int pos = bits / this.bitsPerLimb;
            int n = index - pos;
            limbs[n] = limbs[n] + x;
        } else {
            int secondPos = bits / this.bitsPerLimb;
            int bitOffset = (secondPos + 1) * this.bitsPerLimb - bits;
            int rightBitOffset = this.bitsPerLimb - bitOffset;
            int n = index - (secondPos + 1);
            limbs[n] = limbs[n] + (x << bitOffset & (long)this.limbMask);
            int n2 = index - secondPos;
            limbs[n2] = limbs[n2] + (x >> rightBitOffset);
        }
    }

    @Override
    protected void reduceIn(long[] c, long v, int i) {
        for (int j = 0; j < this.reduceLimbs.length; ++j) {
            this.modReduceInBits(c, i, this.power - this.bitsPerLimb * j, this.reduceLimbs[j] * v);
        }
    }

    private void carryReduce(long[] c, long[] r) {
        this.carry(c);
        for (int i = c.length - 1; i >= this.numLimbs; --i) {
            this.reduceIn(c, c[i], i);
            c[i] = 0L;
        }
        this.carry(c, 0, this.numLimbs);
        this.reduceIn(c, c[this.numLimbs], this.numLimbs);
        c[this.numLimbs] = 0L;
        this.carry(c, 0, this.numLimbs - 1);
        System.arraycopy(c, 0, r, 0, r.length);
    }

    @Override
    protected void reduce(long[] a) {
        long[] c = new long[a.length + 2];
        System.arraycopy(a, 0, c, 0, a.length);
        this.carryReduce(c, a);
    }

    @Override
    protected void square(long[] a, long[] r) {
        long[] c = new long[2 * this.numLimbs];
        for (int i = 0; i < this.numLimbs; ++i) {
            int n = 2 * i;
            c[n] = c[n] + a[i] * a[i];
            for (int j = i + 1; j < this.numLimbs; ++j) {
                int n2 = i + j;
                c[n2] = c[n2] + 2L * a[i] * a[j];
            }
        }
        this.carryReduce(c, r);
    }

    public static final class Curve448OrderField
    extends IntegerPolynomialModBinP {
        public Curve448OrderField() {
            super(28, 16, 446, new BigInteger("13818066809895115352007386748515426880336692474882178609894547503885"));
        }
    }

    public static final class Curve25519OrderField
    extends IntegerPolynomialModBinP {
        public Curve25519OrderField() {
            super(26, 10, 252, new BigInteger("-27742317777372353535851937790883648493"));
        }
    }
}

