/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.pkix;

import com.tencent.kona.crypto.CryptoInsts;
import com.tencent.kona.crypto.spec.RFC5915EncodedKeySpec;
import com.tencent.kona.crypto.spec.SM2ParameterSpec;
import com.tencent.kona.pkix.PKIXInsts;
import com.tencent.kona.sun.security.util.DerInputStream;
import com.tencent.kona.sun.security.util.KnownOIDs;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Set;

public class PKIXUtils {
    private static final String PRIVATE_KEY_BEGIN = "-----BEGIN PRIVATE KEY-----";
    private static final String PRIVATE_KEY_END = "-----END PRIVATE KEY-----";
    private static final String EC_PARAMS_BEGIN = "-----BEGIN EC PARAMETERS-----";
    private static final String EC_PARAMS_END = "-----END EC PARAMETERS-----";
    private static final String RFC5915_KEY_BEGIN = "-----BEGIN EC PRIVATE KEY-----";
    private static final String RFC5915_KEY_END = "-----END EC PRIVATE KEY-----";
    private static final String PUBLIC_KEY_BEGIN = "-----BEGIN PUBLIC KEY-----";
    private static final String PUBLIC_KEY_END = "-----END PUBLIC KEY-----";

    public static boolean isSM3withSM2(String algName) {
        return "SM3withSM2".equalsIgnoreCase(algName) || "sm2sig_sm3".equalsIgnoreCase(algName);
    }

    public static String getNamedCurveId(String ecParams) throws IOException {
        String keyPem = ecParams.replace(EC_PARAMS_BEGIN, "").replace(EC_PARAMS_END, "");
        DerInputStream derIn = new DerInputStream(Base64.getMimeDecoder().decode(keyPem));
        return derIn.getOID().toString();
    }

    public static PrivateKey getPrivateKey(String keyAlgo, String pkcs8Key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String keyPem = pkcs8Key.replace(PRIVATE_KEY_BEGIN, "").replace(PRIVATE_KEY_END, "");
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(Base64.getMimeDecoder().decode(keyPem));
        KeyFactory keyFactory = CryptoInsts.getKeyFactory((String)keyAlgo);
        return keyFactory.generatePrivate(privateKeySpec);
    }

    public static PrivateKey getRFC5915PrivateKey(String rfc5915Key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String keyPem = rfc5915Key.replace(RFC5915_KEY_BEGIN, "").replace(RFC5915_KEY_END, "");
        RFC5915EncodedKeySpec privateKeySpec = new RFC5915EncodedKeySpec(Base64.getMimeDecoder().decode(keyPem));
        KeyFactory keyFactory = CryptoInsts.getKeyFactory((String)"EC");
        return keyFactory.generatePrivate((KeySpec)privateKeySpec);
    }

    public static PublicKey getPublicKey(String keyAlgo, String x509Key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String keyPem = x509Key.replace(PUBLIC_KEY_BEGIN, "").replace(PUBLIC_KEY_END, "");
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(Base64.getMimeDecoder().decode(keyPem));
        KeyFactory keyFactory = CryptoInsts.getKeyFactory((String)keyAlgo);
        return keyFactory.generatePublic(publicKeySpec);
    }

    public static PublicKey getPublicKey(Certificate cert) throws InvalidKeyException {
        boolean[] keyUsageInfo;
        X509Certificate c;
        Set<String> criticalExtSet;
        if (cert instanceof X509Certificate && (criticalExtSet = (c = (X509Certificate)cert).getCriticalExtensionOIDs()) != null && !criticalExtSet.isEmpty() && criticalExtSet.contains("2.5.29.15") && (keyUsageInfo = c.getKeyUsage()) != null && !keyUsageInfo[0]) {
            throw new InvalidKeyException("Wrong key usage");
        }
        return cert.getPublicKey();
    }

    public static PublicKey getPublicKey(String certPEM) throws InvalidKeyException, CertificateException {
        return PKIXUtils.getPublicKey(PKIXUtils.getCertificate(certPEM));
    }

    public static X509Certificate getCertificate(String certPEM) throws CertificateException {
        return (X509Certificate)PKIXInsts.getCertificateFactory("X.509").generateCertificate(new ByteArrayInputStream(certPEM.getBytes(StandardCharsets.UTF_8)));
    }

    public static boolean isSMCert(X509Certificate cert) {
        if (!(cert.getPublicKey() instanceof ECPublicKey)) {
            return false;
        }
        ECParameterSpec ecParams = ((ECPublicKey)cert.getPublicKey()).getParams();
        return SM2ParameterSpec.ORDER.equals(ecParams.getOrder()) && KnownOIDs.SM3withSM2.value().equals(cert.getSigAlgOID());
    }

    public static boolean isCA(X509Certificate certificate) {
        return certificate.getBasicConstraints() != -1;
    }

    public static boolean isSignCert(X509Certificate certificate) {
        if (certificate == null) {
            return false;
        }
        boolean[] keyUsage = certificate.getKeyUsage();
        return keyUsage == null || keyUsage[0];
    }

    public static boolean isEncCert(X509Certificate certificate) {
        if (certificate == null) {
            return false;
        }
        boolean[] keyUsage = certificate.getKeyUsage();
        return keyUsage == null || keyUsage[2] || keyUsage[3] || keyUsage[4];
    }
}

