/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.pkcs;

import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.x509.AlgorithmId;
import java.io.IOException;
import java.util.Arrays;

public class EncryptedPrivateKeyInfo {
    private final AlgorithmId algid;
    private final byte[] encryptedData;
    private byte[] encoded;

    public EncryptedPrivateKeyInfo(byte[] encoded) throws IOException {
        if (encoded == null) {
            throw new IllegalArgumentException("encoding must not be null");
        }
        DerValue val = new DerValue(encoded);
        DerValue[] seq = new DerValue[]{val.data.getDerValue(), val.data.getDerValue()};
        if (val.data.available() != 0) {
            throw new IOException("overrun, bytes = " + val.data.available());
        }
        this.algid = AlgorithmId.parse((DerValue)seq[0]);
        if (seq[0].data.available() != 0) {
            throw new IOException("encryptionAlgorithm field overrun");
        }
        this.encryptedData = seq[1].getOctetString();
        if (seq[1].data.available() != 0) {
            throw new IOException("encryptedData field overrun");
        }
        this.encoded = (byte[])encoded.clone();
    }

    public EncryptedPrivateKeyInfo(AlgorithmId algid, byte[] encryptedData) {
        this.algid = algid;
        this.encryptedData = (byte[])encryptedData.clone();
    }

    public AlgorithmId getAlgorithm() {
        return this.algid;
    }

    public byte[] getEncryptedData() {
        return (byte[])this.encryptedData.clone();
    }

    public byte[] getEncoded() {
        if (this.encoded != null) {
            return (byte[])this.encoded.clone();
        }
        DerOutputStream out = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        this.algid.encode(tmp);
        tmp.putOctetString(this.encryptedData);
        out.write((byte)48, tmp);
        this.encoded = out.toByteArray();
        return (byte[])this.encoded.clone();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EncryptedPrivateKeyInfo)) {
            return false;
        }
        return Arrays.equals(this.getEncoded(), ((EncryptedPrivateKeyInfo)obj).getEncoded());
    }

    public int hashCode() {
        return Arrays.hashCode(this.encryptedData);
    }
}

