/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.pkcs;

import com.tencent.kona.sun.security.pkcs.SignerInfo;
import com.tencent.kona.sun.security.pkcs.SigningCertificateInfo;
import com.tencent.kona.sun.security.util.Debug;
import com.tencent.kona.sun.security.util.DerEncoder;
import com.tencent.kona.sun.security.util.DerInputStream;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.util.HexDumpEncoder;
import com.tencent.kona.sun.security.util.KnownOIDs;
import com.tencent.kona.sun.security.util.ObjectIdentifier;
import com.tencent.kona.sun.security.util.Oid;
import com.tencent.kona.sun.security.x509.CertificateExtensions;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PKCS9Attribute
implements DerEncoder {
    private static final Debug debug = Debug.getInstance((String)"jar");
    public static final ObjectIdentifier EMAIL_ADDRESS_OID = ObjectIdentifier.of((KnownOIDs)KnownOIDs.EmailAddress);
    public static final ObjectIdentifier UNSTRUCTURED_NAME_OID = ObjectIdentifier.of((KnownOIDs)KnownOIDs.UnstructuredName);
    public static final ObjectIdentifier CONTENT_TYPE_OID = ObjectIdentifier.of((KnownOIDs)KnownOIDs.ContentType);
    public static final ObjectIdentifier MESSAGE_DIGEST_OID = ObjectIdentifier.of((KnownOIDs)KnownOIDs.MessageDigest);
    public static final ObjectIdentifier SIGNING_TIME_OID = ObjectIdentifier.of((KnownOIDs)KnownOIDs.SigningTime);
    public static final ObjectIdentifier COUNTERSIGNATURE_OID = ObjectIdentifier.of((KnownOIDs)KnownOIDs.CounterSignature);
    public static final ObjectIdentifier CHALLENGE_PASSWORD_OID = ObjectIdentifier.of((KnownOIDs)KnownOIDs.ChallengePassword);
    public static final ObjectIdentifier UNSTRUCTURED_ADDRESS_OID = ObjectIdentifier.of((KnownOIDs)KnownOIDs.UnstructuredAddress);
    public static final ObjectIdentifier EXTENDED_CERTIFICATE_ATTRIBUTES_OID = ObjectIdentifier.of((KnownOIDs)KnownOIDs.ExtendedCertificateAttributes);
    public static final ObjectIdentifier ISSUER_SERIALNUMBER_OID = ObjectIdentifier.of((KnownOIDs)KnownOIDs.IssuerAndSerialNumber);
    public static final ObjectIdentifier EXTENSION_REQUEST_OID = ObjectIdentifier.of((KnownOIDs)KnownOIDs.ExtensionRequest);
    public static final ObjectIdentifier SIGNING_CERTIFICATE_OID = ObjectIdentifier.of((KnownOIDs)KnownOIDs.SigningCertificate);
    public static final ObjectIdentifier SIGNATURE_TIMESTAMP_TOKEN_OID = ObjectIdentifier.of((KnownOIDs)KnownOIDs.SignatureTimestampToken);
    public static final ObjectIdentifier CMS_ALGORITHM_PROTECTION_OID = ObjectIdentifier.of((KnownOIDs)KnownOIDs.CMSAlgorithmProtection);
    private static final Map<ObjectIdentifier, AttributeInfo<?>> infoMap = new HashMap();
    private final ObjectIdentifier oid;
    private final AttributeInfo<?> info;
    private final Object value;

    private static <T> void add(ObjectIdentifier oid, boolean singleValued, Class<T> valueClass, Decoder<T> decoder, Encoder<T> encoder, byte ... valueTags) {
        AttributeInfo<T> info = new AttributeInfo<T>(singleValued, valueClass, decoder, encoder, valueTags);
        if (infoMap.put(oid, info) != null) {
            throw new RuntimeException("Duplicate oid: " + oid);
        }
    }

    public PKCS9Attribute(ObjectIdentifier oid, Object value) throws IllegalArgumentException {
        Class<?> clazz;
        this.oid = oid;
        this.info = infoMap.get(oid);
        Class<?> clazz2 = this.info == null ? byte[].class : (clazz = ((AttributeInfo)this.info).singleValued ? ((AttributeInfo)this.info).valueClass : Array.newInstance(((AttributeInfo)this.info).valueClass, 0).getClass());
        if (!clazz.isInstance(value)) {
            throw new IllegalArgumentException("Wrong value class  for attribute " + oid + " constructing PKCS9Attribute; was " + value.getClass().toString() + ", should be " + clazz.toString());
        }
        this.value = value;
    }

    public PKCS9Attribute(DerValue derVal) throws IOException {
        DerInputStream derIn = new DerInputStream(derVal.toByteArray());
        DerValue[] val = derIn.getSequence(2);
        if (derIn.available() != 0) {
            throw new IOException("Excess data parsing PKCS9Attribute");
        }
        if (val.length != 2) {
            throw new IOException("PKCS9Attribute doesn't have two components");
        }
        this.oid = val[0].getOID();
        byte[] content = val[1].toByteArray();
        DerValue[] elems = new DerInputStream(content).getSet(1);
        this.info = infoMap.get(this.oid);
        if (this.info == null) {
            if (debug != null) {
                debug.println("Unsupported signer attribute: " + this.oid);
            }
            this.value = content;
            return;
        }
        if (((AttributeInfo)this.info).singleValued && elems.length > 1) {
            this.throwSingleValuedException();
        }
        for (DerValue elem : elems) {
            byte tag = elem.tag;
            if (PKCS9Attribute.indexOf(tag, ((AttributeInfo)this.info).valueTags, 0) != -1) continue;
            this.throwTagException(tag);
        }
        if (((AttributeInfo)this.info).singleValued) {
            this.value = this.info.decode(elems[0]);
        } else {
            this.value = Array.newInstance(((AttributeInfo)this.info).valueClass, elems.length);
            for (int i = 0; i < elems.length; ++i) {
                Array.set(this.value, i, this.info.decode(elems[i]));
            }
        }
    }

    public void encode(DerOutputStream out) {
        DerOutputStream temp = new DerOutputStream();
        temp.putOID(this.oid);
        if (this.info == null) {
            temp.writeBytes((byte[])this.value);
            out.write((byte)48, temp.toByteArray());
            return;
        }
        if (((AttributeInfo)this.info).singleValued) {
            temp.write((byte)49, this.info.encode(this.value));
        } else {
            Object[] values = (Object[])this.value;
            DerOutputStream[] temps = new DerOutputStream[values.length];
            for (int i = 0; i < values.length; ++i) {
                temps[i] = this.info.encode(values[i]);
            }
            temp.putOrderedSetOf((byte)49, (DerEncoder[])temps);
        }
        out.write((byte)48, temp.toByteArray());
    }

    public boolean isKnown() {
        return this.info != null;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isSingleValued() {
        return this.info == null || ((AttributeInfo)this.info).singleValued;
    }

    public ObjectIdentifier getOID() {
        return this.oid;
    }

    public static Set<ObjectIdentifier> getOIDs() {
        return infoMap.keySet();
    }

    public String getName() {
        String n = this.oid.toString();
        KnownOIDs os = KnownOIDs.findMatch((String)n);
        return os == null ? n : os.stdName();
    }

    public static ObjectIdentifier getOID(String name) {
        KnownOIDs o = KnownOIDs.findMatch((String)name);
        if (o != null) {
            return Oid.of((KnownOIDs)o);
        }
        return null;
    }

    public static String getName(ObjectIdentifier oid) {
        return KnownOIDs.findMatch((String)oid.toString()).stdName();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("[");
        if (this.info == null) {
            sb.append(this.oid.toString());
        } else {
            sb.append(PKCS9Attribute.getName(this.oid));
        }
        sb.append(": ");
        if (this.info == null || ((AttributeInfo)this.info).singleValued) {
            if (this.value instanceof byte[]) {
                HexDumpEncoder hexDump = new HexDumpEncoder();
                sb.append(hexDump.encodeBuffer((byte[])this.value));
            } else {
                sb.append(this.value.toString());
            }
            sb.append("]");
        } else {
            Object[] values;
            boolean first = true;
            for (Object curVal : values = (Object[])this.value) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(curVal.toString());
            }
        }
        return sb.toString();
    }

    static int indexOf(byte b, byte[] bs, int start) {
        for (int i = start; i < bs.length; ++i) {
            if (b != bs[i]) continue;
            return i;
        }
        return -1;
    }

    private void throwSingleValuedException() throws IOException {
        throw new IOException("Single-value attribute " + this.oid + " (" + this.getName() + ") has multiple values.");
    }

    private void throwTagException(byte tag) throws IOException {
        byte[] expectedTags = ((AttributeInfo)this.info).valueTags;
        StringBuilder msg = new StringBuilder(100);
        msg.append("Value of attribute ");
        msg.append(this.oid.toString());
        msg.append(" (");
        msg.append(this.getName());
        msg.append(") has wrong tag: ");
        msg.append(tag);
        msg.append(".  Expected tags: ");
        msg.append(expectedTags[0]);
        for (int i = 1; i < expectedTags.length; ++i) {
            msg.append(", ");
            msg.append(expectedTags[i]);
        }
        msg.append(".");
        throw new IOException(msg.toString());
    }

    static {
        PKCS9Attribute.add(EMAIL_ADDRESS_OID, false, String.class, DerValue::getAsString, DerOutputStream::putIA5String, 22);
        PKCS9Attribute.add(UNSTRUCTURED_NAME_OID, false, String.class, DerValue::getAsString, DerOutputStream::putIA5String, 22, 19, 20, 30, 28, 12);
        PKCS9Attribute.add(CONTENT_TYPE_OID, true, ObjectIdentifier.class, DerValue::getOID, DerOutputStream::putOID, 6);
        PKCS9Attribute.add(MESSAGE_DIGEST_OID, true, byte[].class, DerValue::getOctetString, DerOutputStream::putOctetString, 4);
        PKCS9Attribute.add(SIGNING_TIME_OID, true, Date.class, DerValue::getTime, DerOutputStream::putTime, 23, 24);
        PKCS9Attribute.add(COUNTERSIGNATURE_OID, false, SignerInfo.class, e -> new SignerInfo(e.toDerInputStream()), DerOutputStream::write, 48);
        PKCS9Attribute.add(CHALLENGE_PASSWORD_OID, true, String.class, DerValue::getAsString, DerOutputStream::putPrintableString, 19, 20, 30, 28, 12);
        PKCS9Attribute.add(UNSTRUCTURED_ADDRESS_OID, false, String.class, DerValue::getAsString, DerOutputStream::putPrintableString, 19, 20, 30, 28, 12);
        PKCS9Attribute.add(EXTENSION_REQUEST_OID, true, CertificateExtensions.class, a -> new CertificateExtensions(new DerInputStream(a.toByteArray())), (t, v) -> v.encode(t, true), 48);
        PKCS9Attribute.add(SIGNING_CERTIFICATE_OID, true, SigningCertificateInfo.class, a -> new SigningCertificateInfo(a.toByteArray()), (t, v) -> t.writeBytes(v.toByteArray()), 48);
        PKCS9Attribute.add(SIGNATURE_TIMESTAMP_TOKEN_OID, true, byte[].class, DerValue::toByteArray, (t, v) -> t.writeBytes(v), 48);
        PKCS9Attribute.add(CMS_ALGORITHM_PROTECTION_OID, true, byte[].class, DerValue::toByteArray, (t, v) -> t.writeBytes(v), 48);
    }

    @FunctionalInterface
    public static interface Encoder<R> {
        public void encode(DerOutputStream var1, R var2);
    }

    @FunctionalInterface
    public static interface Decoder<R> {
        public R decode(DerValue var1) throws IOException;
    }

    private static class AttributeInfo<T> {
        private final boolean singleValued;
        private final Class<?> valueClass;
        private final Decoder<T> decoder;
        private final Encoder<T> encoder;
        private final byte[] valueTags;

        AttributeInfo(boolean singleValued, Class<?> valueClass, Decoder<T> decoder, Encoder<T> encoder, byte ... valueTags) {
            this.singleValued = singleValued;
            this.valueClass = valueClass;
            this.decoder = decoder;
            this.encoder = encoder;
            this.valueTags = valueTags;
        }

        DerOutputStream encode(Object o) {
            DerOutputStream d = new DerOutputStream();
            this.encoder.encode(d, o);
            return d;
        }

        T decode(DerValue d) throws IOException {
            return this.decoder.decode(d);
        }
    }
}

