/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.pkcs;

import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.util.HexDumpEncoder;
import com.tencent.kona.sun.security.x509.GeneralNames;
import com.tencent.kona.sun.security.x509.SerialNumber;
import java.io.IOException;

class SigningCertificateInfo {
    private byte[] ber;
    private ESSCertId[] certId = null;

    SigningCertificateInfo(byte[] ber) throws IOException {
        this.parse(ber);
        this.ber = ber;
    }

    byte[] toByteArray() {
        return this.ber;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        for (int i = 0; i < this.certId.length; ++i) {
            sb.append(this.certId[i].toString());
        }
        sb.append("\n]");
        return sb.toString();
    }

    private void parse(byte[] bytes) throws IOException {
        DerValue derValue = new DerValue(bytes);
        if (derValue.tag != 48) {
            throw new IOException("Bad encoding for signingCertificate");
        }
        DerValue[] certs = derValue.data.getSequence(1);
        this.certId = new ESSCertId[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            this.certId[i] = new ESSCertId(certs[i]);
        }
        if (derValue.data.available() > 0) {
            DerValue[] policies = derValue.data.getSequence(1);
            for (int i = 0; i < policies.length; ++i) {
            }
        }
    }

    static class ESSCertId {
        private static volatile HexDumpEncoder hexDumper;
        private final byte[] certHash;
        private final GeneralNames issuer;
        private final SerialNumber serialNumber;

        ESSCertId(DerValue certId) throws IOException {
            this.certHash = certId.data.getDerValue().toByteArray();
            if (certId.data.available() > 0) {
                DerValue issuerSerial = certId.data.getDerValue();
                this.issuer = new GeneralNames(issuerSerial.data.getDerValue());
                this.serialNumber = new SerialNumber(issuerSerial.data.getDerValue());
            } else {
                this.issuer = null;
                this.serialNumber = null;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[\n\tCertificate hash (SHA-1):\n");
            if (hexDumper == null) {
                hexDumper = new HexDumpEncoder();
            }
            sb.append(hexDumper.encode(this.certHash));
            if (this.issuer != null && this.serialNumber != null) {
                sb.append("\n\tIssuer: " + this.issuer + "\n");
                sb.append("\t" + this.serialNumber);
            }
            sb.append("\n]");
            return sb.toString();
        }
    }
}

