/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.pkcs10;

import com.tencent.kona.crypto.CryptoInsts;
import com.tencent.kona.sun.security.pkcs10.PKCS10Attributes;
import com.tencent.kona.sun.security.util.DerInputStream;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.util.SignatureUtil;
import com.tencent.kona.sun.security.x509.AlgorithmId;
import com.tencent.kona.sun.security.x509.X500Name;
import com.tencent.kona.sun.security.x509.X509Key;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Base64;

public class PKCS10 {
    private X500Name subject;
    private final PublicKey subjectPublicKeyInfo;
    private String sigAlg;
    private final PKCS10Attributes attributeSet;
    private byte[] encoded;

    public PKCS10(PublicKey publicKey) {
        this.subjectPublicKeyInfo = publicKey;
        this.attributeSet = new PKCS10Attributes();
    }

    public PKCS10(PublicKey publicKey, PKCS10Attributes attributes) {
        this.subjectPublicKeyInfo = publicKey;
        this.attributeSet = attributes;
    }

    public PKCS10(byte[] data) throws IOException, SignatureException, NoSuchAlgorithmException {
        this.encoded = data;
        DerInputStream in = new DerInputStream(data);
        DerValue[] seq = in.getSequence(3);
        if (seq.length != 3) {
            throw new IllegalArgumentException("not a PKCS #10 request");
        }
        data = seq[0].toByteArray();
        AlgorithmId id = AlgorithmId.parse((DerValue)seq[1]);
        byte[] sigData = seq[2].getBitString();
        BigInteger serial = seq[0].data.getBigInteger();
        if (!serial.equals(BigInteger.ZERO)) {
            throw new IllegalArgumentException("not PKCS #10 v1");
        }
        this.subject = new X500Name(seq[0].data);
        this.subjectPublicKeyInfo = X509Key.parse((DerValue)seq[0].data.getDerValue());
        this.attributeSet = seq[0].data.available() != 0 ? new PKCS10Attributes(seq[0].data) : new PKCS10Attributes();
        if (seq[0].data.available() != 0) {
            throw new IllegalArgumentException("illegal PKCS #10 data");
        }
        try {
            this.sigAlg = id.getName();
            Signature sig = CryptoInsts.getSignature((String)this.sigAlg);
            SignatureUtil.initVerifyWithParam(sig, this.subjectPublicKeyInfo, SignatureUtil.getParamSpec(this.sigAlg, id.getParameters()));
            sig.update(data);
            if (!sig.verify(sigData)) {
                throw new SignatureException("Invalid PKCS #10 signature");
            }
        }
        catch (InvalidKeyException e) {
            throw new SignatureException("Invalid key", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SignatureException("Invalid signature parameters", e);
        }
        catch (ProviderException e) {
            throw new SignatureException("Error parsing signature parameters", e.getCause());
        }
    }

    public void encodeAndSign(X500Name subject, PrivateKey key, String algorithm) throws SignatureException, NoSuchAlgorithmException, InvalidKeyException {
        if (this.encoded != null) {
            throw new SignatureException("request is already signed");
        }
        Signature signature = SignatureUtil.fromKey(algorithm, key, (Provider)null);
        this.subject = subject;
        DerOutputStream scratch = new DerOutputStream();
        scratch.putInteger(BigInteger.ZERO);
        subject.encode(scratch);
        byte[] encodedInfo = this.subjectPublicKeyInfo.getEncoded();
        scratch.write(encodedInfo, 0, encodedInfo.length);
        this.attributeSet.encode(scratch);
        DerOutputStream out = new DerOutputStream();
        out.write((byte)48, scratch);
        byte[] certificateRequestInfo = out.toByteArray();
        scratch = out;
        signature.update(certificateRequestInfo, 0, certificateRequestInfo.length);
        byte[] sig = signature.sign();
        this.sigAlg = signature.getAlgorithm();
        AlgorithmId algId = SignatureUtil.fromSignature(signature, key);
        algId.encode(scratch);
        scratch.putBitString(sig);
        out = new DerOutputStream();
        out.write((byte)48, scratch);
        this.encoded = out.toByteArray();
    }

    public X500Name getSubjectName() {
        return this.subject;
    }

    public PublicKey getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public String getSigAlg() {
        return this.sigAlg;
    }

    public PKCS10Attributes getAttributes() {
        return this.attributeSet;
    }

    public byte[] getEncoded() {
        if (this.encoded != null) {
            return (byte[])this.encoded.clone();
        }
        return null;
    }

    public void print(PrintStream out) throws IOException, SignatureException {
        if (this.encoded == null) {
            throw new SignatureException("Cert request was not signed");
        }
        byte[] CRLF = new byte[]{13, 10};
        out.print("-----BEGIN NEW CERTIFICATE REQUEST-----");
        out.print("\r\n");
        out.print(Base64.getMimeEncoder(64, CRLF).encodeToString(this.encoded));
        out.print("\r\n");
        out.print("-----END NEW CERTIFICATE REQUEST-----");
        out.print("\r\n");
    }

    public String toString() {
        return "[PKCS #10 certificate request:\n" + this.subjectPublicKeyInfo.toString() + " subject: <" + this.subject + ">\n attributes: " + this.attributeSet.toString() + "\n]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PKCS10)) {
            return false;
        }
        if (this.encoded == null) {
            return false;
        }
        byte[] otherEncoded = ((PKCS10)obj).getEncoded();
        if (otherEncoded == null) {
            return false;
        }
        return Arrays.equals(this.encoded, otherEncoded);
    }

    public int hashCode() {
        return Arrays.hashCode(this.encoded);
    }
}

