/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.provider.certpath;

import com.tencent.kona.sun.security.action.GetBooleanAction;
import com.tencent.kona.sun.security.provider.certpath.PKIX;
import com.tencent.kona.sun.security.provider.certpath.PolicyChecker;
import com.tencent.kona.sun.security.provider.certpath.State;
import com.tencent.kona.sun.security.util.Debug;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class Builder {
    private static final Debug debug = Debug.getInstance((String)"certpath");
    private Set<String> matchingPolicies;
    final PKIX.BuilderParams buildParams;
    final X509CertSelector targetCertConstraints;
    static final boolean USE_AIA = (Boolean)AccessController.doPrivileged(new GetBooleanAction("com.tencent.kona.pkix.enableAIAcaIssuers"));

    Builder(PKIX.BuilderParams buildParams) {
        this.buildParams = buildParams;
        this.targetCertConstraints = (X509CertSelector)buildParams.targetCertConstraints();
    }

    abstract Collection<X509Certificate> getMatchingCerts(State var1, List<CertStore> var2) throws CertStoreException, CertificateException, IOException;

    abstract void verifyCert(X509Certificate var1, State var2, List<X509Certificate> var3) throws GeneralSecurityException;

    abstract boolean isPathCompleted(X509Certificate var1);

    abstract void addCertToPath(X509Certificate var1, LinkedList<X509Certificate> var2);

    abstract void removeFinalCertFromPath(LinkedList<X509Certificate> var1);

    Set<String> getMatchingPolicies() {
        if (this.matchingPolicies != null) {
            Set<String> initialPolicies = this.buildParams.initialPolicies();
            if (!initialPolicies.isEmpty() && !initialPolicies.contains(PolicyChecker.ANY_POLICY) && this.buildParams.policyMappingInhibited()) {
                this.matchingPolicies = new HashSet<String>(initialPolicies);
                this.matchingPolicies.add(PolicyChecker.ANY_POLICY);
            } else {
                this.matchingPolicies = Collections.emptySet();
            }
        }
        return this.matchingPolicies;
    }

    boolean addMatchingCerts(X509CertSelector selector, Collection<CertStore> certStores, Collection<X509Certificate> resultCerts, boolean checkAll) {
        X509Certificate targetCert = selector.getCertificate();
        if (targetCert != null) {
            if (selector.match(targetCert)) {
                if (debug != null) {
                    debug.println("Builder.addMatchingCerts: adding target cert\n SN: " + Debug.toString((BigInteger)targetCert.getSerialNumber()) + "\n  Subject: " + targetCert.getSubjectX500Principal() + "\n  Issuer: " + targetCert.getIssuerX500Principal());
                }
                return resultCerts.add(targetCert);
            }
            return false;
        }
        boolean add = false;
        for (CertStore store : certStores) {
            try {
                Collection<? extends Certificate> certs = store.getCertificates(selector);
                for (Certificate certificate : certs) {
                    if (!resultCerts.add((X509Certificate)certificate)) continue;
                    add = true;
                }
                if (checkAll || !add) continue;
                return true;
            }
            catch (CertStoreException cse) {
                if (debug == null) continue;
                debug.println("Builder.addMatchingCerts, non-fatal exception retrieving certs: " + cse);
                cse.printStackTrace();
            }
        }
        return add;
    }
}

