/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.provider.certpath;

import com.tencent.kona.pkix.PKIXInsts;
import com.tencent.kona.sun.security.action.GetPropertyAction;
import com.tencent.kona.sun.security.cert.URICertStoreParameters;
import com.tencent.kona.sun.security.provider.certpath.PKIX;
import com.tencent.kona.sun.security.util.Cache;
import com.tencent.kona.sun.security.util.Debug;
import com.tencent.kona.sun.security.x509.AccessDescription;
import com.tencent.kona.sun.security.x509.GeneralNameInterface;
import com.tencent.kona.sun.security.x509.URIName;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.CRLException;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;

class URICertStore
extends CertStoreSpi {
    private static final Debug debug = Debug.getInstance((String)"certpath");
    private static final int CHECK_INTERVAL = 30000;
    private static final int CACHE_SIZE = 185;
    private final CertificateFactory factory;
    private Collection<X509Certificate> certs = Collections.emptySet();
    private X509CRL crl;
    private long lastChecked;
    private long lastModified;
    private final URI uri;
    private boolean ldap = false;
    private CertStore ldapCertStore;
    private static final int DEFAULT_CRL_CONNECT_TIMEOUT = 15000;
    private static final int DEFAULT_CACERT_CONNECT_TIMEOUT = 15000;
    private static final int DEFAULT_CACERT_READ_TIMEOUT = 15000;
    private static final int DEFAULT_CRL_READ_TIMEOUT = 15000;
    private static final int CRL_CONNECT_TIMEOUT = URICertStore.initializeTimeout("com.tencent.kona.pkix.crl.timeout", 15000);
    private static final int CRL_READ_TIMEOUT = URICertStore.initializeTimeout("com.tencent.kona.pkix.crl.readtimeout", 15000);
    private static final int CACERT_CONNECT_TIMEOUT = URICertStore.initializeTimeout("com.sun.security.cert.timeout", 15000);
    private static final int CACERT_READ_TIMEOUT = URICertStore.initializeTimeout("com.sun.security.cert.readtimeout", 15000);
    private static final Cache<URICertStoreParameters, CertStore> certStoreCache = Cache.newSoftMemoryCache(185);

    private static int initializeTimeout(String prop, int def) {
        int timeoutVal = GetPropertyAction.privilegedGetTimeoutProp((String)prop, (int)def, (Debug)debug);
        if (debug != null) {
            debug.println(prop + " set to " + timeoutVal + " milliseconds");
        }
        return timeoutVal;
    }

    URICertStore(CertStoreParameters params) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        super(params);
        if (!(params instanceof URICertStoreParameters)) {
            throw new InvalidAlgorithmParameterException("params must be instanceof URICertStoreParameters");
        }
        this.uri = ((URICertStoreParameters)params).getURI();
        if (this.uri.getScheme().toLowerCase(Locale.ENGLISH).equals("ldap")) {
            this.ldap = true;
            this.ldapCertStore = PKIXInsts.getCertStore("LDAP", params);
        }
        try {
            this.factory = PKIXInsts.getCertificateFactory("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException();
        }
    }

    static synchronized CertStore getInstance(URICertStoreParameters params) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        CertStore ucs;
        if (debug != null) {
            debug.println("CertStore URI:" + params.getURI());
        }
        if ((ucs = certStoreCache.get(params)) == null) {
            ucs = new UCS(new URICertStore(params), null, "URI", params);
            certStoreCache.put(params, ucs);
        } else if (debug != null) {
            debug.println("URICertStore.getInstance: cache hit");
        }
        return ucs;
    }

    static CertStore getInstance(AccessDescription ad) {
        if (!ad.getAccessMethod().equals((Object)AccessDescription.Ad_CAISSUERS_Id)) {
            return null;
        }
        GeneralNameInterface gn = ad.getAccessLocation().getName();
        if (!(gn instanceof URIName)) {
            return null;
        }
        URI uri = ((URIName)gn).getURI();
        try {
            return URICertStore.getInstance(new URICertStoreParameters(uri));
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.println("exception creating CertStore: " + ex);
                ex.printStackTrace();
            }
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Collection<X509Certificate> engineGetCertificates(CertSelector selector) throws CertStoreException {
        if (this.ldap) {
            return this.ldapCertStore.getCertificates(selector);
        }
        long time = System.currentTimeMillis();
        if (time - this.lastChecked < 30000L) {
            if (debug == null) return URICertStore.getMatchingCerts(this.certs, selector);
            debug.println("Returning certificates from cache");
            return URICertStore.getMatchingCerts(this.certs, selector);
        }
        this.lastChecked = time;
        try {
            URLConnection connection = this.uri.toURL().openConnection();
            if (this.lastModified != 0L) {
                connection.setIfModifiedSince(this.lastModified);
            }
            long oldLastModified = this.lastModified;
            connection.setConnectTimeout(CACERT_CONNECT_TIMEOUT);
            connection.setReadTimeout(CACERT_READ_TIMEOUT);
            try (InputStream in = connection.getInputStream();){
                this.lastModified = connection.getLastModified();
                if (oldLastModified != 0L) {
                    HttpURLConnection hconn;
                    if (oldLastModified == this.lastModified) {
                        if (debug != null) {
                            debug.println("Not modified, using cached copy");
                        }
                        Collection<X509Certificate> collection = URICertStore.getMatchingCerts(this.certs, selector);
                        return collection;
                    }
                    if (connection instanceof HttpURLConnection && (hconn = (HttpURLConnection)connection).getResponseCode() == 304) {
                        if (debug != null) {
                            debug.println("Not modified, using cached copy");
                        }
                        Collection<X509Certificate> collection = URICertStore.getMatchingCerts(this.certs, selector);
                        return collection;
                    }
                }
                if (debug != null) {
                    debug.println("Downloading new certificates...");
                }
                this.certs = this.factory.generateCertificates(in);
                return URICertStore.getMatchingCerts(this.certs, selector);
            }
        }
        catch (IOException | CertificateException e) {
            if (debug != null) {
                debug.println("Exception fetching certificates:");
                e.printStackTrace();
            }
            this.lastModified = 0L;
            this.certs = Collections.emptySet();
            return this.certs;
        }
    }

    private static Collection<X509Certificate> getMatchingCerts(Collection<X509Certificate> certs, CertSelector selector) {
        if (selector == null) {
            return certs;
        }
        ArrayList<X509Certificate> matchedCerts = new ArrayList<X509Certificate>(certs.size());
        for (X509Certificate cert : certs) {
            if (!selector.match(cert)) continue;
            matchedCerts.add(cert);
        }
        return matchedCerts;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Collection<X509CRL> engineGetCRLs(CRLSelector selector) throws CertStoreException {
        if (this.ldap) {
            try {
                return this.ldapCertStore.getCRLs(selector);
            }
            catch (CertStoreException cse) {
                throw new PKIX.CertStoreTypeException("LDAP", cse);
            }
        }
        long time = System.currentTimeMillis();
        if (time - this.lastChecked < 30000L) {
            if (debug == null) return URICertStore.getMatchingCRLs(this.crl, selector);
            debug.println("Returning CRL from cache");
            return URICertStore.getMatchingCRLs(this.crl, selector);
        }
        this.lastChecked = time;
        try {
            URLConnection connection = this.uri.toURL().openConnection();
            if (this.lastModified != 0L) {
                connection.setIfModifiedSince(this.lastModified);
            }
            long oldLastModified = this.lastModified;
            connection.setConnectTimeout(CRL_CONNECT_TIMEOUT);
            connection.setReadTimeout(CRL_READ_TIMEOUT);
            try (InputStream in = connection.getInputStream();){
                this.lastModified = connection.getLastModified();
                if (oldLastModified != 0L) {
                    HttpURLConnection hconn;
                    if (oldLastModified == this.lastModified) {
                        if (debug != null) {
                            debug.println("Not modified, using cached copy");
                        }
                        Collection<X509CRL> collection = URICertStore.getMatchingCRLs(this.crl, selector);
                        return collection;
                    }
                    if (connection instanceof HttpURLConnection && (hconn = (HttpURLConnection)connection).getResponseCode() == 304) {
                        if (debug != null) {
                            debug.println("Not modified, using cached copy");
                        }
                        Collection<X509CRL> collection = URICertStore.getMatchingCRLs(this.crl, selector);
                        return collection;
                    }
                }
                if (debug != null) {
                    debug.println("Downloading new CRL...");
                }
                this.crl = (X509CRL)this.factory.generateCRL(in);
                return URICertStore.getMatchingCRLs(this.crl, selector);
            }
        }
        catch (IOException | CRLException e) {
            if (debug != null) {
                debug.println("Exception fetching CRL:");
                e.printStackTrace();
            }
            this.lastModified = 0L;
            this.crl = null;
            throw new PKIX.CertStoreTypeException("URI", new CertStoreException(e));
        }
    }

    private static Collection<X509CRL> getMatchingCRLs(X509CRL crl, CRLSelector selector) {
        if (selector == null || crl != null && selector.match(crl)) {
            return Collections.singletonList(crl);
        }
        return Collections.emptyList();
    }

    private static class UCS
    extends CertStore {
        protected UCS(CertStoreSpi spi, Provider p, String type, CertStoreParameters params) {
            super(spi, p, type, params);
        }
    }
}

