/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.tools;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

public class PathList {
    public static String appendPath(String pathTo, String pathFrom) {
        if (pathTo == null || pathTo.isEmpty()) {
            return pathFrom;
        }
        if (pathFrom == null || pathFrom.isEmpty()) {
            return pathTo;
        }
        return pathTo + File.pathSeparator + pathFrom;
    }

    public static URL[] pathToURLs(String path) {
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        URL[] urls = new URL[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            URL url = PathList.fileToURL(new File(st.nextToken()));
            urls[count++] = url;
        }
        if (urls.length != count) {
            URL[] tmp = new URL[count];
            System.arraycopy(urls, 0, tmp, 0, count);
            urls = tmp;
        }
        return urls;
    }

    private static URL fileToURL(File file) {
        String name;
        try {
            name = file.getCanonicalPath();
        }
        catch (IOException e) {
            name = file.getAbsolutePath();
        }
        name = name.replace(File.separatorChar, '/');
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if (!file.isFile()) {
            name = name + "/";
        }
        try {
            URL result = new URL("file", "", name);
            return result;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("file");
        }
    }
}

