/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.x509;

import com.tencent.kona.sun.security.util.DerEncoder;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.x509.DNSName;
import com.tencent.kona.sun.security.x509.EDIPartyName;
import com.tencent.kona.sun.security.x509.GeneralNameInterface;
import com.tencent.kona.sun.security.x509.IPAddressName;
import com.tencent.kona.sun.security.x509.OIDName;
import com.tencent.kona.sun.security.x509.OtherName;
import com.tencent.kona.sun.security.x509.RFC822Name;
import com.tencent.kona.sun.security.x509.URIName;
import com.tencent.kona.sun.security.x509.X400Address;
import com.tencent.kona.sun.security.x509.X500Name;
import java.io.IOException;

public class GeneralName
implements DerEncoder {
    private final GeneralNameInterface name;

    public GeneralName(GeneralNameInterface name) {
        if (name == null) {
            throw new NullPointerException("GeneralName must not be null");
        }
        this.name = name;
    }

    public GeneralName(DerValue encName) throws IOException {
        this(encName, false);
    }

    public GeneralName(DerValue encName, boolean nameConstraint) throws IOException {
        short tag = (byte)(encName.tag & 0x1F);
        switch (tag) {
            case 0: {
                if (encName.isContextSpecific() && encName.isConstructed()) {
                    encName.resetTag((byte)48);
                    this.name = new OtherName(encName);
                    break;
                }
                throw new IOException("Invalid encoding of Other-Name");
            }
            case 1: {
                if (encName.isContextSpecific() && !encName.isConstructed()) {
                    encName.resetTag((byte)22);
                    this.name = new RFC822Name(encName);
                    break;
                }
                throw new IOException("Invalid encoding of RFC822 name");
            }
            case 2: {
                if (encName.isContextSpecific() && !encName.isConstructed()) {
                    encName.resetTag((byte)22);
                    this.name = new DNSName(encName);
                    break;
                }
                throw new IOException("Invalid encoding of DNSName");
            }
            case 3: {
                if (encName.isContextSpecific() && encName.isConstructed()) {
                    encName.resetTag((byte)22);
                    this.name = new X400Address(encName);
                    break;
                }
                throw new IOException("Invalid encoding of X400Address name");
            }
            case 6: {
                if (encName.isContextSpecific() && !encName.isConstructed()) {
                    encName.resetTag((byte)22);
                    this.name = nameConstraint ? URIName.nameConstraint(encName) : new URIName(encName);
                    break;
                }
                throw new IOException("Invalid encoding of URI");
            }
            case 7: {
                if (encName.isContextSpecific() && !encName.isConstructed()) {
                    encName.resetTag((byte)4);
                    this.name = new IPAddressName(encName);
                    break;
                }
                throw new IOException("Invalid encoding of IP address");
            }
            case 8: {
                if (encName.isContextSpecific() && !encName.isConstructed()) {
                    encName.resetTag((byte)6);
                    this.name = new OIDName(encName);
                    break;
                }
                throw new IOException("Invalid encoding of OID name");
            }
            case 4: {
                if (encName.isContextSpecific() && encName.isConstructed()) {
                    this.name = new X500Name(encName.getData());
                    break;
                }
                throw new IOException("Invalid encoding of Directory name");
            }
            case 5: {
                if (encName.isContextSpecific() && encName.isConstructed()) {
                    encName.resetTag((byte)48);
                    this.name = new EDIPartyName(encName);
                    break;
                }
                throw new IOException("Invalid encoding of EDI name");
            }
            default: {
                throw new IOException("Unrecognized GeneralName tag, (" + tag + ")");
            }
        }
    }

    public int getType() {
        return this.name.getType();
    }

    public GeneralNameInterface getName() {
        return this.name;
    }

    public String toString() {
        return this.name.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GeneralName)) {
            return false;
        }
        try {
            return this.name.constrains(((GeneralName)obj).name) == 0;
        }
        catch (UnsupportedOperationException ioe) {
            return false;
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void encode(DerOutputStream out) {
        DerOutputStream tmp = new DerOutputStream();
        this.name.encode(tmp);
        int nameType = this.name.getType();
        if (nameType == 0 || nameType == 3 || nameType == 5) {
            out.writeImplicit(DerValue.createTag((byte)-128, (boolean)true, (byte)((byte)nameType)), tmp);
        } else if (nameType == 4) {
            out.write(DerValue.createTag((byte)-128, (boolean)true, (byte)((byte)nameType)), tmp);
        } else {
            out.writeImplicit(DerValue.createTag((byte)-128, (boolean)false, (byte)((byte)nameType)), tmp);
        }
    }
}

