/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.x509;

import com.tencent.kona.sun.security.util.DerInputStream;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.util.ObjectIdentifier;
import com.tencent.kona.sun.security.x509.GeneralNameInterface;
import com.tencent.kona.sun.security.x509.OIDMap;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;

public class OtherName
implements GeneralNameInterface {
    private final ObjectIdentifier oid;
    private final String name;
    private final byte[] nameValue;
    private final GeneralNameInterface gni;
    private static final byte TAG_VALUE = 0;
    private int myhash = -1;

    public OtherName(ObjectIdentifier oid, byte[] value) throws IOException {
        if (oid == null || value == null) {
            throw new NullPointerException("parameters may not be null");
        }
        this.oid = oid;
        this.nameValue = value;
        this.gni = this.getGNI(oid, value);
        this.name = this.gni != null ? this.gni.toString() : "Unrecognized ObjectIdentifier: " + oid.toString();
    }

    public OtherName(DerValue derValue) throws IOException {
        DerInputStream in = derValue.toDerInputStream();
        this.oid = in.getOID();
        DerValue derValue1 = in.getDerValue();
        if (!derValue1.isContextSpecific((byte)0) || !derValue1.isConstructed()) {
            throw new IOException("value is not EXPLICTly tagged [0]");
        }
        this.nameValue = derValue1.data.toByteArray();
        this.gni = this.getGNI(this.oid, this.nameValue);
        this.name = this.gni != null ? this.gni.toString() : "Unrecognized ObjectIdentifier: " + this.oid.toString();
    }

    public ObjectIdentifier getOID() {
        return this.oid;
    }

    public byte[] getNameValue() {
        return (byte[])this.nameValue.clone();
    }

    private GeneralNameInterface getGNI(ObjectIdentifier oid, byte[] nameValue) throws IOException {
        try {
            Constructor<?> cons;
            Class<?> extClass = OIDMap.getClass(oid);
            if (extClass == null) {
                return null;
            }
            try {
                cons = extClass.getConstructor(Object.class);
            }
            catch (NoSuchMethodException e) {
                cons = extClass.getConstructor(byte[].class);
            }
            return (GeneralNameInterface)cons.newInstance(new Object[]{nameValue});
        }
        catch (Exception e) {
            throw new IOException("Instantiation error: " + e, e);
        }
    }

    @Override
    public int getType() {
        return 0;
    }

    public void encode(DerOutputStream out) {
        if (this.gni != null) {
            this.gni.encode(out);
        } else {
            DerOutputStream tmp = new DerOutputStream();
            tmp.putOID(this.oid);
            tmp.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), this.nameValue);
            out.write((byte)48, tmp);
        }
    }

    public boolean equals(Object other) {
        boolean result;
        GeneralNameInterface otherGNI;
        if (this == other) {
            return true;
        }
        if (!(other instanceof OtherName)) {
            return false;
        }
        OtherName otherOther = (OtherName)other;
        if (!otherOther.oid.equals((Object)this.oid)) {
            return false;
        }
        try {
            otherGNI = this.getGNI(otherOther.oid, otherOther.nameValue);
        }
        catch (IOException ioe) {
            return false;
        }
        if (otherGNI != null) {
            try {
                result = otherGNI.constrains(this) == 0;
            }
            catch (UnsupportedOperationException ioe) {
                result = false;
            }
        } else {
            result = Arrays.equals(this.nameValue, otherOther.nameValue);
        }
        return result;
    }

    public int hashCode() {
        if (this.myhash == -1) {
            this.myhash = 37 + this.oid.hashCode();
            for (int i = 0; i < this.nameValue.length; ++i) {
                this.myhash = 37 * this.myhash + this.nameValue[i];
            }
        }
        return this.myhash;
    }

    public String toString() {
        return "Other-Name: " + this.name;
    }

    @Override
    public int constrains(GeneralNameInterface inputName) {
        int constraintType;
        if (inputName == null) {
            constraintType = -1;
        } else if (inputName.getType() != 0) {
            constraintType = -1;
        } else {
            throw new UnsupportedOperationException("Narrowing, widening, and matching are not supported for OtherName.");
        }
        return constraintType;
    }

    @Override
    public int subtreeDepth() {
        throw new UnsupportedOperationException("subtreeDepth() not supported for generic OtherName");
    }
}

