/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.x509;

import com.tencent.kona.sun.security.util.DerInputStream;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.x509.Extension;
import com.tencent.kona.sun.security.x509.PKIXExtensions;
import java.io.IOException;

public class PolicyConstraintsExtension
extends Extension {
    public static final String NAME = "PolicyConstraints";
    private static final byte TAG_REQUIRE = 0;
    private static final byte TAG_INHIBIT = 1;
    private int require = -1;
    private int inhibit = -1;

    private void encodeThis() {
        DerOutputStream tmp;
        if (this.require == -1 && this.inhibit == -1) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream tagged = new DerOutputStream();
        DerOutputStream seq = new DerOutputStream();
        if (this.require != -1) {
            tmp = new DerOutputStream();
            tmp.putInteger(this.require);
            tagged.writeImplicit(DerValue.createTag((byte)-128, (boolean)false, (byte)0), tmp);
        }
        if (this.inhibit != -1) {
            tmp = new DerOutputStream();
            tmp.putInteger(this.inhibit);
            tagged.writeImplicit(DerValue.createTag((byte)-128, (boolean)false, (byte)1), tmp);
        }
        seq.write((byte)48, tagged);
        this.extensionValue = seq.toByteArray();
    }

    public PolicyConstraintsExtension(int require, int inhibit) {
        this(Boolean.TRUE, require, inhibit);
    }

    public PolicyConstraintsExtension(Boolean critical, int require, int inhibit) {
        if (require == -1 && inhibit == -1) {
            throw new IllegalArgumentException("require and inhibit cannot both be -1");
        }
        this.require = require;
        this.inhibit = inhibit;
        this.extensionId = PKIXExtensions.PolicyConstraints_Id;
        this.critical = critical;
        this.encodeThis();
    }

    public PolicyConstraintsExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.PolicyConstraints_Id;
        this.critical = critical;
        this.extensionValue = (byte[])value;
        DerValue val = new DerValue(this.extensionValue);
        if (val.tag != 48) {
            throw new IOException("Sequence tag missing for PolicyConstraint.");
        }
        DerInputStream in = val.data;
        while (in != null && in.available() != 0) {
            DerValue next = in.getDerValue();
            if (next.isContextSpecific((byte)0) && !next.isConstructed()) {
                if (this.require != -1) {
                    throw new IOException("Duplicate requireExplicitPolicy found in the PolicyConstraintsExtension");
                }
                next.resetTag((byte)2);
                this.require = next.getInteger();
                continue;
            }
            if (next.isContextSpecific((byte)1) && !next.isConstructed()) {
                if (this.inhibit != -1) {
                    throw new IOException("Duplicate inhibitPolicyMapping found in the PolicyConstraintsExtension");
                }
                next.resetTag((byte)2);
                this.inhibit = next.getInteger();
                continue;
            }
            throw new IOException("Invalid encoding of PolicyConstraint");
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append("PolicyConstraints: [").append("  Require: ");
        if (this.require == -1) {
            sb.append("unspecified;");
        } else {
            sb.append(this.require).append(';');
        }
        sb.append("\tInhibit: ");
        if (this.inhibit == -1) {
            sb.append("unspecified");
        } else {
            sb.append(this.inhibit);
        }
        sb.append(" ]\n");
        return sb.toString();
    }

    @Override
    public void encode(DerOutputStream out) {
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.PolicyConstraints_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(out);
    }

    public int getRequire() {
        return this.require;
    }

    public int getInhibit() {
        return this.inhibit;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

