/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.cert;

import java.net.URI;
import java.security.cert.CertStoreParameters;

public final class URICertStoreParameters
implements CertStoreParameters {
    private final URI uri;
    private int myhash = -1;

    public URICertStoreParameters(URI uri) {
        if (uri == null) {
            throw new NullPointerException();
        }
        this.uri = uri;
    }

    public URI getURI() {
        return this.uri;
    }

    @Override
    public URICertStoreParameters clone() {
        try {
            return new URICertStoreParameters(this.uri);
        }
        catch (NullPointerException e) {
            throw new InternalError(e.toString(), e);
        }
    }

    public int hashCode() {
        if (this.myhash == -1) {
            this.myhash = this.uri.hashCode() * 7;
        }
        return this.myhash;
    }

    public boolean equals(Object p) {
        if (p == this) {
            return true;
        }
        return p instanceof URICertStoreParameters && this.uri.equals(((URICertStoreParameters)p).getURI());
    }

    public String toString() {
        return "URICertStoreParameters: " + this.uri.toString();
    }
}

