/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.provider.certpath;

import com.tencent.kona.sun.security.provider.certpath.BuildStep;
import com.tencent.kona.sun.security.provider.certpath.Vertex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class AdjacencyList {
    private final ArrayList<BuildStep> mStepList = new ArrayList();
    private final List<List<Vertex>> mOrigList;

    public AdjacencyList(List<List<Vertex>> list) {
        this.mOrigList = list;
        this.buildList(list, 0, null);
    }

    public Iterator<BuildStep> iterator() {
        return Collections.unmodifiableList(this.mStepList).iterator();
    }

    private boolean buildList(List<List<Vertex>> theList, int index, BuildStep follow) {
        List<Vertex> l = theList.get(index);
        boolean allNegOne = true;
        boolean allXcps = true;
        for (Vertex v : l) {
            if (v.getIndex() != -1) {
                if (theList.get(v.getIndex()).size() != 0) {
                    allNegOne = false;
                }
            } else if (v.getThrowable() == null) {
                allXcps = false;
            }
            this.mStepList.add(new BuildStep(v, 1));
        }
        if (allNegOne) {
            if (allXcps) {
                if (follow == null) {
                    this.mStepList.add(new BuildStep(null, 4));
                } else {
                    this.mStepList.add(new BuildStep(follow.getVertex(), 2));
                }
                return false;
            }
            ArrayList<Vertex> possibles = new ArrayList<Vertex>();
            for (Vertex v : l) {
                if (v.getThrowable() != null) continue;
                possibles.add(v);
            }
            if (possibles.size() == 1) {
                this.mStepList.add(new BuildStep((Vertex)possibles.get(0), 5));
            } else {
                this.mStepList.add(new BuildStep((Vertex)possibles.get(0), 5));
            }
            return true;
        }
        boolean success = false;
        for (Vertex v : l) {
            if (v.getIndex() == -1 || theList.get(v.getIndex()).size() == 0) continue;
            BuildStep bs = new BuildStep(v, 3);
            this.mStepList.add(bs);
            success = this.buildList(theList, v.getIndex(), bs);
        }
        if (success) {
            return true;
        }
        if (follow == null) {
            this.mStepList.add(new BuildStep(null, 4));
        } else {
            this.mStepList.add(new BuildStep(follow.getVertex(), 2));
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[\n");
        int i = 0;
        for (List<Vertex> l : this.mOrigList) {
            sb.append("LinkedList[").append(i++).append("]:\n");
            for (Vertex step : l) {
                sb.append(step.toString()).append("\n");
            }
        }
        sb.append("]\n");
        return sb.toString();
    }
}

