/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.provider.certpath;

import com.tencent.kona.sun.security.action.GetBooleanAction;
import com.tencent.kona.sun.security.provider.certpath.PKIX;
import com.tencent.kona.sun.security.provider.certpath.PolicyChecker;
import com.tencent.kona.sun.security.provider.certpath.State;
import com.tencent.kona.sun.security.util.Debug;
import com.tencent.kona.sun.security.x509.GeneralNameInterface;
import com.tencent.kona.sun.security.x509.GeneralNames;
import com.tencent.kona.sun.security.x509.GeneralSubtrees;
import com.tencent.kona.sun.security.x509.NameConstraintsExtension;
import com.tencent.kona.sun.security.x509.SubjectAlternativeNameExtension;
import com.tencent.kona.sun.security.x509.X500Name;
import com.tencent.kona.sun.security.x509.X509CertImpl;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class Builder {
    private static final Debug debug = Debug.getInstance((String)"certpath");
    private Set<String> matchingPolicies;
    final PKIX.BuilderParams buildParams;
    final X509CertSelector targetCertConstraints;
    static final boolean USE_AIA = (Boolean)AccessController.doPrivileged(new GetBooleanAction("com.tencent.kona.pkix.enableAIAcaIssuers"));

    Builder(PKIX.BuilderParams buildParams) {
        this.buildParams = buildParams;
        this.targetCertConstraints = (X509CertSelector)buildParams.targetCertConstraints();
    }

    abstract Collection<X509Certificate> getMatchingCerts(State var1, List<CertStore> var2) throws CertStoreException, CertificateException, IOException;

    abstract void verifyCert(X509Certificate var1, State var2, List<X509Certificate> var3) throws GeneralSecurityException;

    abstract boolean isPathCompleted(X509Certificate var1);

    abstract void addCertToPath(X509Certificate var1, LinkedList<X509Certificate> var2);

    abstract void removeFinalCertFromPath(LinkedList<X509Certificate> var1);

    static int distance(GeneralNameInterface base, GeneralNameInterface test, int incomparable) {
        switch (base.constrains(test)) {
            case -1: {
                if (debug != null) {
                    debug.println("Builder.distance(): Names are different types");
                }
                return incomparable;
            }
            case 3: {
                if (debug != null) {
                    debug.println("Builder.distance(): Names are same type but in different subtrees");
                }
                return incomparable;
            }
            case 0: {
                return 0;
            }
            case 1: 
            case 2: {
                break;
            }
            default: {
                return incomparable;
            }
        }
        return test.subtreeDepth() - base.subtreeDepth();
    }

    static int hops(GeneralNameInterface base, GeneralNameInterface test, int incomparable) {
        int baseRtest = base.constrains(test);
        switch (baseRtest) {
            case -1: {
                if (debug != null) {
                    debug.println("Builder.hops(): Names are different types");
                }
                return incomparable;
            }
            case 3: {
                break;
            }
            case 0: {
                return 0;
            }
            case 1: 
            case 2: {
                return test.subtreeDepth() - base.subtreeDepth();
            }
            default: {
                return incomparable;
            }
        }
        if (base.getType() != 4) {
            if (debug != null) {
                debug.println("Builder.hops(): hopDistance not implemented for this name type");
            }
            return incomparable;
        }
        X500Name baseName = (X500Name)base;
        X500Name testName = (X500Name)test;
        X500Name commonName = baseName.commonAncestor(testName);
        if (commonName == null) {
            if (debug != null) {
                debug.println("Builder.hops(): Names are in different namespaces");
            }
            return incomparable;
        }
        int commonDistance = commonName.subtreeDepth();
        int baseDistance = baseName.subtreeDepth();
        int testDistance = testName.subtreeDepth();
        return baseDistance + testDistance - 2 * commonDistance;
    }

    static int targetDistance(NameConstraintsExtension constraints, X509Certificate cert, GeneralNameInterface target) throws IOException {
        NameConstraintsExtension ncExt;
        GeneralNames altNames;
        X509CertImpl certImpl;
        if (constraints != null && !constraints.verify(cert)) {
            throw new IOException("certificate does not satisfy existing name constraints");
        }
        try {
            certImpl = X509CertImpl.toImpl(cert);
        }
        catch (CertificateException e) {
            throw new IOException("Invalid certificate", e);
        }
        X500Name subject = X500Name.asX500Name(certImpl.getSubjectX500Principal());
        if (subject.equals(target)) {
            return 0;
        }
        SubjectAlternativeNameExtension altNameExt = certImpl.getSubjectAlternativeNameExtension();
        if (altNameExt != null && (altNames = altNameExt.getNames()) != null) {
            int n = altNames.size();
            for (int j = 0; j < n; ++j) {
                GeneralNameInterface altName = altNames.get(j).getName();
                if (!altName.equals(target)) continue;
                return 0;
            }
        }
        if ((ncExt = certImpl.getNameConstraintsExtension()) == null) {
            return -1;
        }
        if (constraints != null) {
            constraints.merge(ncExt);
        } else {
            constraints = (NameConstraintsExtension)ncExt.clone();
        }
        if (debug != null) {
            debug.println("Builder.targetDistance() merged constraints: " + constraints);
        }
        GeneralSubtrees permitted = constraints.getPermittedSubtrees();
        GeneralSubtrees excluded = constraints.getExcludedSubtrees();
        if (permitted != null) {
            permitted.reduce(excluded);
        }
        if (debug != null) {
            debug.println("Builder.targetDistance() reduced constraints: " + permitted);
        }
        if (!constraints.verify(target)) {
            throw new IOException("New certificate not allowed to sign certificate for target");
        }
        if (permitted == null) {
            return -1;
        }
        int n = permitted.size();
        for (int i = 0; i < n; ++i) {
            GeneralNameInterface perName = permitted.get(i).getName().getName();
            int distance = Builder.distance(perName, target, -1);
            if (distance < 0) continue;
            return distance + 1;
        }
        return -1;
    }

    Set<String> getMatchingPolicies() {
        if (this.matchingPolicies != null) {
            Set<String> initialPolicies = this.buildParams.initialPolicies();
            if (!initialPolicies.isEmpty() && !initialPolicies.contains(PolicyChecker.ANY_POLICY) && this.buildParams.policyMappingInhibited()) {
                this.matchingPolicies = new HashSet<String>(initialPolicies);
                this.matchingPolicies.add(PolicyChecker.ANY_POLICY);
            } else {
                this.matchingPolicies = Collections.emptySet();
            }
        }
        return this.matchingPolicies;
    }

    boolean addMatchingCerts(X509CertSelector selector, Collection<CertStore> certStores, Collection<X509Certificate> resultCerts, boolean checkAll) {
        X509Certificate targetCert = selector.getCertificate();
        if (targetCert != null) {
            if (selector.match(targetCert) && !X509CertImpl.isSelfSigned(targetCert, this.buildParams.sigProvider())) {
                if (debug != null) {
                    debug.println("Builder.addMatchingCerts: adding target cert\n  SN: " + Debug.toHexString((BigInteger)targetCert.getSerialNumber()) + "\n  Subject: " + targetCert.getSubjectX500Principal() + "\n  Issuer: " + targetCert.getIssuerX500Principal());
                }
                return resultCerts.add(targetCert);
            }
            return false;
        }
        boolean add = false;
        for (CertStore store : certStores) {
            try {
                Collection<? extends Certificate> certs = store.getCertificates(selector);
                for (Certificate certificate : certs) {
                    if (X509CertImpl.isSelfSigned((X509Certificate)certificate, this.buildParams.sigProvider()) || !resultCerts.add((X509Certificate)certificate)) continue;
                    add = true;
                }
                if (checkAll || !add) continue;
                return true;
            }
            catch (CertStoreException cse) {
                if (debug == null) continue;
                debug.println("Builder.addMatchingCerts, non-fatal exception retrieving certs: " + cse);
                cse.printStackTrace();
            }
        }
        return add;
    }
}

