/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.provider.certpath;

import com.tencent.kona.pkix.PKIXInsts;
import com.tencent.kona.sun.security.cert.URICertStoreParameters;
import com.tencent.kona.sun.security.provider.certpath.AdaptableX509CertSelector;
import com.tencent.kona.sun.security.provider.certpath.AlgorithmChecker;
import com.tencent.kona.sun.security.provider.certpath.PKIX;
import com.tencent.kona.sun.security.provider.certpath.URICertStore;
import com.tencent.kona.sun.security.util.Debug;
import com.tencent.kona.sun.security.x509.AuthorityKeyIdentifierExtension;
import com.tencent.kona.sun.security.x509.CRLDistributionPointsExtension;
import com.tencent.kona.sun.security.x509.DistributionPoint;
import com.tencent.kona.sun.security.x509.DistributionPointName;
import com.tencent.kona.sun.security.x509.GeneralName;
import com.tencent.kona.sun.security.x509.GeneralNameInterface;
import com.tencent.kona.sun.security.x509.GeneralNames;
import com.tencent.kona.sun.security.x509.IssuingDistributionPointExtension;
import com.tencent.kona.sun.security.x509.KeyIdentifier;
import com.tencent.kona.sun.security.x509.PKIXExtensions;
import com.tencent.kona.sun.security.x509.RDN;
import com.tencent.kona.sun.security.x509.ReasonFlags;
import com.tencent.kona.sun.security.x509.SerialNumber;
import com.tencent.kona.sun.security.x509.URIName;
import com.tencent.kona.sun.security.x509.X500Name;
import com.tencent.kona.sun.security.x509.X509CRLImpl;
import com.tencent.kona.sun.security.x509.X509CertImpl;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class DistributionPointFetcher {
    private static final Debug debug = Debug.getInstance((String)"certpath");
    private static final boolean[] ALL_REASONS = new boolean[]{true, true, true, true, true, true, true, true, true};

    private DistributionPointFetcher() {
    }

    public static Collection<X509CRL> getCRLs(X509CRLSelector selector, boolean signFlag, PublicKey prevKey, X509Certificate prevCert, String provider, List<CertStore> certStores, boolean[] reasonsMask, Set<TrustAnchor> trustAnchors, Date validity, String variant, TrustAnchor anchor) throws CertStoreException {
        X509Certificate cert = selector.getCertificateChecking();
        if (cert == null) {
            return Collections.emptySet();
        }
        try {
            CRLDistributionPointsExtension ext;
            X509CertImpl certImpl = X509CertImpl.toImpl(cert);
            if (debug != null) {
                debug.println("DistributionPointFetcher.getCRLs: Checking CRLDPs for " + certImpl.getSubjectX500Principal());
            }
            if ((ext = certImpl.getCRLDistributionPointsExtension()) == null) {
                if (debug != null) {
                    debug.println("No CRLDP ext");
                }
                return Collections.emptySet();
            }
            List<DistributionPoint> points = ext.getDistributionPoints();
            HashSet<X509CRL> results = new HashSet<X509CRL>();
            Iterator<DistributionPoint> t = points.iterator();
            while (t.hasNext() && !Arrays.equals(reasonsMask, ALL_REASONS)) {
                DistributionPoint point = t.next();
                Collection<X509CRL> crls = DistributionPointFetcher.getCRLs(selector, certImpl, point, reasonsMask, signFlag, prevKey, prevCert, provider, certStores, trustAnchors, validity, variant, anchor);
                results.addAll(crls);
            }
            if (debug != null) {
                debug.println("Returning " + results.size() + " CRLs");
            }
            return results;
        }
        catch (CertificateException e) {
            return Collections.emptySet();
        }
    }

    private static Collection<X509CRL> getCRLs(X509CRLSelector selector, X509CertImpl certImpl, DistributionPoint point, boolean[] reasonsMask, boolean signFlag, PublicKey prevKey, X509Certificate prevCert, String provider, List<CertStore> certStores, Set<TrustAnchor> trustAnchors, Date validity, String variant, TrustAnchor anchor) throws CertStoreException {
        GeneralNames fullName = point.getFullName();
        if (fullName == null) {
            RDN relativeName = point.getRelativeName();
            if (relativeName == null) {
                return Collections.emptySet();
            }
            try {
                GeneralNames crlIssuers = point.getCRLIssuer();
                if (crlIssuers == null) {
                    fullName = DistributionPointFetcher.getFullNames((X500Name)certImpl.getIssuerDN(), relativeName);
                } else {
                    if (crlIssuers.size() != 1) {
                        return Collections.emptySet();
                    }
                    fullName = DistributionPointFetcher.getFullNames((X500Name)crlIssuers.get(0).getName(), relativeName);
                }
            }
            catch (IOException ioe) {
                return Collections.emptySet();
            }
        }
        ArrayList<X509CRL> possibleCRLs = new ArrayList<X509CRL>();
        CertStoreException savedCSE = null;
        Iterator<GeneralName> t = fullName.iterator();
        while (t.hasNext()) {
            try {
                URIName uriName;
                X509CRL crl;
                GeneralName name = t.next();
                if (name.getType() == 4) {
                    X500Name x500Name = (X500Name)name.getName();
                    possibleCRLs.addAll(DistributionPointFetcher.getCRLs(x500Name, certImpl.getIssuerX500Principal(), certStores));
                    continue;
                }
                if (name.getType() != 6 || (crl = DistributionPointFetcher.getCRL(uriName = (URIName)name.getName())) == null) continue;
                possibleCRLs.add(crl);
            }
            catch (CertStoreException cse) {
                savedCSE = cse;
            }
        }
        if (possibleCRLs.isEmpty() && savedCSE != null) {
            throw savedCSE;
        }
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>(2);
        for (X509CRL crl : possibleCRLs) {
            try {
                selector.setIssuerNames(null);
                if (!selector.match(crl) || !DistributionPointFetcher.verifyCRL(certImpl, point, crl, reasonsMask, signFlag, prevKey, prevCert, provider, trustAnchors, certStores, validity, variant, anchor)) continue;
                crls.add(crl);
            }
            catch (IOException | CRLException e) {
                if (debug == null) continue;
                debug.println("Exception verifying CRL: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return crls;
    }

    private static X509CRL getCRL(URIName name) throws CertStoreException {
        CertStore ucs;
        URI uri = name.getURI();
        if (debug != null) {
            debug.println("Trying to fetch CRL from DP " + uri);
        }
        try {
            ucs = URICertStore.getInstance(new URICertStoreParameters(uri));
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.println("Can't create URICertStore: " + e.getMessage());
            }
            return null;
        }
        Collection<? extends CRL> crls = ucs.getCRLs(null);
        if (crls.isEmpty()) {
            return null;
        }
        return (X509CRL)crls.iterator().next();
    }

    private static Collection<X509CRL> getCRLs(X500Name name, X500Principal certIssuer, List<CertStore> certStores) throws CertStoreException {
        if (debug != null) {
            debug.println("Trying to fetch CRL from DP " + name);
        }
        X509CRLSelector xcs = new X509CRLSelector();
        xcs.addIssuer(name.asX500Principal());
        xcs.addIssuer(certIssuer);
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>();
        PKIX.CertStoreTypeException savedCSE = null;
        for (CertStore store : certStores) {
            try {
                for (CRL cRL : store.getCRLs(xcs)) {
                    crls.add((X509CRL)cRL);
                }
            }
            catch (CertStoreException cse) {
                if (debug != null) {
                    debug.println("Exception while retrieving CRLs: " + cse);
                    cse.printStackTrace();
                }
                savedCSE = new PKIX.CertStoreTypeException(store.getType(), cse);
            }
        }
        if (crls.isEmpty() && savedCSE != null) {
            throw savedCSE;
        }
        return crls;
    }

    static boolean verifyCRL(X509CertImpl certImpl, DistributionPoint point, X509CRL crl, boolean[] reasonsMask, boolean signFlag, PublicKey prevKey, X509Certificate prevCert, String provider, Set<TrustAnchor> trustAnchors, List<CertStore> certStores, Date validity, String variant, TrustAnchor anchor) throws CRLException, IOException {
        Object crlSign;
        if (debug != null) {
            debug.println("DistributionPointFetcher.verifyCRL: checking revocation status for\n  SN: " + Debug.toHexString((BigInteger)certImpl.getSerialNumber()) + "\n  Subject: " + certImpl.getSubjectX500Principal() + "\n  Issuer: " + certImpl.getIssuerX500Principal());
        }
        boolean indirectCRL = false;
        X509CRLImpl crlImpl = X509CRLImpl.toImpl(crl);
        IssuingDistributionPointExtension idpExt = crlImpl.getIssuingDistributionPointExtension();
        X500Name certIssuer = (X500Name)certImpl.getIssuerDN();
        X500Name crlIssuer = (X500Name)crlImpl.getIssuerDN();
        GeneralNames pointCrlIssuers = point.getCRLIssuer();
        X500Name pointCrlIssuer = null;
        if (pointCrlIssuers != null) {
            if (idpExt == null || !idpExt.isIndirectCRL()) {
                return false;
            }
            boolean match = false;
            Iterator<GeneralName> t = pointCrlIssuers.iterator();
            while (!match && t.hasNext()) {
                GeneralNameInterface name = t.next().getName();
                if (!crlIssuer.equals(name)) continue;
                pointCrlIssuer = (X500Name)name;
                match = true;
            }
            if (!match) {
                return false;
            }
            if (DistributionPointFetcher.issues(certImpl, crlImpl, provider)) {
                prevKey = certImpl.getPublicKey();
            } else {
                indirectCRL = true;
            }
        } else {
            if (!crlIssuer.equals(certIssuer)) {
                if (debug != null) {
                    debug.println("crl issuer does not equal cert issuer.\ncrl issuer: " + crlIssuer + "\ncert issuer: " + certIssuer);
                }
                return false;
            }
            KeyIdentifier certAKID = certImpl.getAuthKeyId();
            KeyIdentifier crlAKID = crlImpl.getAuthKeyId();
            if (certAKID == null || crlAKID == null) {
                if (DistributionPointFetcher.issues(certImpl, crlImpl, provider)) {
                    prevKey = certImpl.getPublicKey();
                }
            } else if (!certAKID.equals(crlAKID)) {
                if (DistributionPointFetcher.issues(certImpl, crlImpl, provider)) {
                    prevKey = certImpl.getPublicKey();
                } else {
                    indirectCRL = true;
                }
            }
        }
        if (!indirectCRL && !signFlag) {
            return false;
        }
        if (idpExt != null) {
            boolean b;
            DistributionPointName idpPoint = idpExt.getDistributionPoint();
            if (idpPoint != null) {
                GeneralNames idpNames = idpPoint.getFullName();
                if (idpNames == null) {
                    RDN relativeName = idpPoint.getRelativeName();
                    if (relativeName == null) {
                        if (debug != null) {
                            debug.println("IDP must be relative or full DN");
                        }
                        return false;
                    }
                    if (debug != null) {
                        debug.println("IDP relativeName:" + relativeName);
                    }
                    idpNames = DistributionPointFetcher.getFullNames(crlIssuer, relativeName);
                }
                if (point.getFullName() != null || point.getRelativeName() != null) {
                    GeneralNames pointNames = point.getFullName();
                    if (pointNames == null) {
                        RDN relativeName = point.getRelativeName();
                        if (relativeName == null) {
                            if (debug != null) {
                                debug.println("DP must be relative or full DN");
                            }
                            return false;
                        }
                        if (debug != null) {
                            debug.println("DP relativeName:" + relativeName);
                        }
                        if (indirectCRL) {
                            if (pointCrlIssuers.size() != 1) {
                                if (debug != null) {
                                    debug.println("must only be one CRL issuer when relative name present");
                                }
                                return false;
                            }
                            pointNames = DistributionPointFetcher.getFullNames(pointCrlIssuer, relativeName);
                        } else {
                            pointNames = DistributionPointFetcher.getFullNames(certIssuer, relativeName);
                        }
                    }
                    boolean match = false;
                    Iterator<GeneralName> i = idpNames.iterator();
                    while (!match && i.hasNext()) {
                        GeneralNameInterface idpName = i.next().getName();
                        if (debug != null) {
                            debug.println("idpName: " + idpName);
                        }
                        Iterator<GeneralName> p = pointNames.iterator();
                        while (!match && p.hasNext()) {
                            GeneralNameInterface pointName = p.next().getName();
                            if (debug != null) {
                                debug.println("pointName: " + pointName);
                            }
                            match = idpName.equals(pointName);
                        }
                    }
                    if (!match) {
                        if (debug != null) {
                            debug.println("IDP name does not match DP name");
                        }
                        return false;
                    }
                } else {
                    boolean match = false;
                    Iterator<GeneralName> t = pointCrlIssuers.iterator();
                    while (!match && t.hasNext()) {
                        GeneralNameInterface crlIssuerName = t.next().getName();
                        Iterator<GeneralName> i = idpNames.iterator();
                        while (!match && i.hasNext()) {
                            GeneralNameInterface idpName = i.next().getName();
                            match = crlIssuerName.equals(idpName);
                        }
                    }
                    if (!match) {
                        return false;
                    }
                }
            }
            if ((b = idpExt.hasOnlyUserCerts()) && certImpl.getBasicConstraints() != -1) {
                if (debug != null) {
                    debug.println("cert must be a EE cert");
                }
                return false;
            }
            b = idpExt.hasOnlyCACerts();
            if (b && certImpl.getBasicConstraints() == -1) {
                if (debug != null) {
                    debug.println("cert must be a CA cert");
                }
                return false;
            }
            b = idpExt.hasOnlyAttributeCerts();
            if (b) {
                if (debug != null) {
                    debug.println("cert must not be an AA cert");
                }
                return false;
            }
        }
        boolean[] interimReasonsMask = new boolean[9];
        ReasonFlags reasons = null;
        if (idpExt != null) {
            reasons = idpExt.getRevocationReasons();
        }
        boolean[] pointReasonFlags = point.getReasonFlags();
        if (reasons != null) {
            if (pointReasonFlags != null) {
                boolean[] idpReasonFlags = reasons.getFlags();
                for (int i = 0; i < interimReasonsMask.length; ++i) {
                    interimReasonsMask[i] = i < idpReasonFlags.length && idpReasonFlags[i] && i < pointReasonFlags.length && pointReasonFlags[i];
                }
            } else {
                interimReasonsMask = (boolean[])reasons.getFlags().clone();
            }
        } else if (pointReasonFlags != null) {
            interimReasonsMask = (boolean[])pointReasonFlags.clone();
        } else {
            Arrays.fill(interimReasonsMask, true);
        }
        boolean oneOrMore = false;
        for (int i = 0; i < interimReasonsMask.length; ++i) {
            if (!interimReasonsMask[i] || i < reasonsMask.length && reasonsMask[i]) continue;
            oneOrMore = true;
        }
        if (!oneOrMore) {
            return false;
        }
        if (indirectCRL) {
            PKIXBuilderParameters params;
            X509CertSelector certSel = new X509CertSelector();
            certSel.setSubject(crlIssuer.asX500Principal());
            crlSign = new boolean[]{false, false, false, false, false, false, true};
            certSel.setKeyUsage((boolean[])crlSign);
            AuthorityKeyIdentifierExtension akidext = crlImpl.getAuthKeyIdExtension();
            if (akidext != null) {
                SerialNumber asn;
                byte[] kid = akidext.getEncodedKeyIdentifier();
                if (kid != null) {
                    certSel.setSubjectKeyIdentifier(kid);
                }
                if ((asn = akidext.getSerialNumber()) != null) {
                    certSel.setSerialNumber(asn.getNumber());
                }
            }
            HashSet<TrustAnchor> newTrustAnchors = new HashSet<TrustAnchor>(trustAnchors);
            if (prevKey != null) {
                TrustAnchor temporary;
                if (prevCert != null) {
                    temporary = new TrustAnchor(prevCert, null);
                } else {
                    X500Principal principal = certImpl.getIssuerX500Principal();
                    temporary = new TrustAnchor(principal, prevKey, null);
                }
                newTrustAnchors.add(temporary);
            }
            try {
                params = new PKIXBuilderParameters(newTrustAnchors, (CertSelector)certSel);
            }
            catch (InvalidAlgorithmParameterException iape) {
                throw new CRLException(iape);
            }
            params.setCertStores(certStores);
            params.setSigProvider(provider);
            params.setDate(validity);
            try {
                CertPathBuilder builder = PKIXInsts.getCertPathBuilder("PKIX");
                PKIXCertPathBuilderResult result = (PKIXCertPathBuilderResult)builder.build(params);
                prevKey = result.getPublicKey();
            }
            catch (GeneralSecurityException e) {
                throw new CRLException(e);
            }
        }
        try {
            AlgorithmChecker.check(prevKey, crlImpl.getSigAlgId(), variant, anchor);
        }
        catch (CertPathValidatorException cpve) {
            if (debug != null) {
                debug.println("CRL signature algorithm check failed: " + cpve);
            }
            return false;
        }
        try {
            crl.verify(prevKey, provider);
        }
        catch (GeneralSecurityException e) {
            if (debug != null) {
                debug.println("CRL signature failed to verify");
            }
            return false;
        }
        Set<String> unresCritExts = crl.getCriticalExtensionOIDs();
        if (unresCritExts != null) {
            unresCritExts.remove(PKIXExtensions.IssuingDistributionPoint_Id.toString());
            if (!unresCritExts.isEmpty()) {
                if (debug != null) {
                    debug.println("Unrecognized critical extension(s) in CRL: " + unresCritExts);
                    crlSign = unresCritExts.iterator();
                    while (crlSign.hasNext()) {
                        String ext = (String)crlSign.next();
                        debug.println(ext);
                    }
                }
                return false;
            }
        }
        for (int i = 0; i < reasonsMask.length; ++i) {
            reasonsMask[i] = reasonsMask[i] || i < interimReasonsMask.length && interimReasonsMask[i];
        }
        return true;
    }

    private static GeneralNames getFullNames(X500Name issuer, RDN rdn) throws IOException {
        ArrayList<RDN> rdns = new ArrayList<RDN>(issuer.rdns());
        rdns.add(rdn);
        X500Name fullName = new X500Name(rdns.toArray(new RDN[0]));
        GeneralNames fullNames = new GeneralNames();
        fullNames.add(new GeneralName(fullName));
        return fullNames;
    }

    private static boolean issues(X509CertImpl cert, X509CRLImpl crl, String provider) throws IOException {
        AdaptableX509CertSelector issuerSelector = new AdaptableX509CertSelector();
        boolean[] usages = cert.getKeyUsage();
        if (usages != null) {
            usages[6] = true;
            issuerSelector.setKeyUsage(usages);
        }
        X500Principal crlIssuer = crl.getIssuerX500Principal();
        issuerSelector.setSubject(crlIssuer);
        AuthorityKeyIdentifierExtension crlAKID = crl.getAuthKeyIdExtension();
        issuerSelector.setSkiAndSerialNumber(crlAKID);
        boolean matched = issuerSelector.match(cert);
        if (matched && (crlAKID == null || cert.getAuthorityKeyIdentifierExtension() == null)) {
            try {
                crl.verify(cert.getPublicKey(), provider);
            }
            catch (GeneralSecurityException e) {
                matched = false;
            }
        }
        return matched;
    }
}

