/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.provider.certpath;

import com.tencent.kona.sun.security.provider.certpath.PKIX;
import com.tencent.kona.sun.security.provider.certpath.State;
import com.tencent.kona.sun.security.provider.certpath.UntrustedChecker;
import com.tencent.kona.sun.security.util.Debug;
import com.tencent.kona.sun.security.x509.GeneralName;
import com.tencent.kona.sun.security.x509.GeneralNameInterface;
import com.tencent.kona.sun.security.x509.GeneralNames;
import com.tencent.kona.sun.security.x509.SubjectAlternativeNameExtension;
import com.tencent.kona.sun.security.x509.X500Name;
import com.tencent.kona.sun.security.x509.X509CertImpl;
import java.io.IOException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import javax.security.auth.x500.X500Principal;

class ForwardState
implements State {
    private static final Debug debug = Debug.getInstance((String)"certpath");
    X500Principal issuerDN;
    X509CertImpl cert;
    HashSet<GeneralNameInterface> subjectNamesTraversed;
    int traversedCACerts;
    private boolean init = true;
    UntrustedChecker untrustedChecker;
    ArrayList<PKIXCertPathChecker> forwardCheckers;
    boolean keyParamsNeededFlag = false;

    ForwardState() {
    }

    @Override
    public boolean isInitial() {
        return this.init;
    }

    @Override
    public boolean keyParamsNeeded() {
        return this.keyParamsNeededFlag;
    }

    public String toString() {
        return "State [\n  issuerDN of last cert: " + this.issuerDN + "\n  traversedCACerts: " + this.traversedCACerts + "\n  init: " + this.init + "\n  keyParamsNeeded: " + this.keyParamsNeededFlag + "\n  subjectNamesTraversed: \n" + this.subjectNamesTraversed + "]\n";
    }

    public void initState(List<PKIXCertPathChecker> certPathCheckers) throws CertPathValidatorException {
        this.subjectNamesTraversed = new HashSet();
        this.traversedCACerts = 0;
        this.forwardCheckers = new ArrayList();
        for (PKIXCertPathChecker checker : certPathCheckers) {
            if (!checker.isForwardCheckingSupported()) continue;
            checker.init(true);
            this.forwardCheckers.add(checker);
        }
        this.init = true;
    }

    @Override
    public void updateState(X509Certificate cert) throws CertificateException, IOException, CertPathValidatorException {
        if (cert == null) {
            return;
        }
        X509CertImpl icert = X509CertImpl.toImpl(cert);
        if (PKIX.isDSAPublicKeyWithoutParams(icert.getPublicKey())) {
            this.keyParamsNeededFlag = true;
        }
        this.cert = icert;
        this.issuerDN = cert.getIssuerX500Principal();
        if (!X509CertImpl.isSelfIssued(cert) && !this.init && cert.getBasicConstraints() != -1) {
            ++this.traversedCACerts;
        }
        if (this.init || !X509CertImpl.isSelfIssued(cert)) {
            X500Principal subjName = cert.getSubjectX500Principal();
            this.subjectNamesTraversed.add(X500Name.asX500Name(subjName));
            SubjectAlternativeNameExtension subjAltNameExt = icert.getSubjectAlternativeNameExtension();
            if (subjAltNameExt != null) {
                GeneralNames gNames = subjAltNameExt.getNames();
                for (GeneralName gName : gNames.names()) {
                    this.subjectNamesTraversed.add(gName.getName());
                }
            }
        }
        this.init = false;
    }

    @Override
    public Object clone() {
        try {
            ForwardState clonedState = (ForwardState)super.clone();
            clonedState.forwardCheckers = (ArrayList)this.forwardCheckers.clone();
            ListIterator<PKIXCertPathChecker> li = clonedState.forwardCheckers.listIterator();
            while (li.hasNext()) {
                PKIXCertPathChecker checker = li.next();
                if (checker == null) continue;
                li.set((PKIXCertPathChecker)checker.clone());
            }
            clonedState.subjectNamesTraversed = (HashSet)this.subjectNamesTraversed.clone();
            return clonedState;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString(), e);
        }
    }
}

