/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.provider.certpath;

import com.tencent.kona.sun.security.util.Debug;
import com.tencent.kona.sun.security.x509.AuthorityKeyIdentifierExtension;
import com.tencent.kona.sun.security.x509.KeyIdentifier;
import com.tencent.kona.sun.security.x509.SubjectKeyIdentifierExtension;
import com.tencent.kona.sun.security.x509.X509CertImpl;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class Vertex {
    private static final Debug debug = Debug.getInstance((String)"certpath");
    private final X509Certificate cert;
    private int index;
    private Throwable throwable;

    Vertex(X509Certificate cert) {
        this.cert = cert;
        this.index = -1;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public int getIndex() {
        return this.index;
    }

    void setIndex(int ndx) {
        this.index = ndx;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public String toString() {
        return this.certToString() + this.throwableToString() + this.indexToString();
    }

    /*
     * WARNING - void declaration
     */
    public String certToString() {
        AuthorityKeyIdentifierExtension aKeyID;
        SubjectKeyIdentifierExtension sKeyID;
        boolean[] sUID;
        X509CertImpl x509Cert;
        StringBuilder sb = new StringBuilder();
        try {
            x509Cert = X509CertImpl.toImpl(this.cert);
        }
        catch (CertificateException ce) {
            if (debug != null) {
                debug.println("Vertex.certToString() unexpected exception");
                ce.printStackTrace();
            }
            return sb.toString();
        }
        sb.append("Issuer:     ").append(x509Cert.getIssuerX500Principal()).append("\n");
        sb.append("Subject:    ").append(x509Cert.getSubjectX500Principal()).append("\n");
        sb.append("SerialNum:  ").append(x509Cert.getSerialNumber().toString(16)).append("\n");
        sb.append("Expires:    ").append(x509Cert.getNotAfter().toString()).append("\n");
        boolean[] iUID = x509Cert.getIssuerUniqueID();
        if (iUID != null) {
            sb.append("IssuerUID:  ");
            for (boolean bl : iUID) {
                sb.append(bl ? 1 : 0);
            }
            sb.append("\n");
        }
        if ((sUID = x509Cert.getSubjectUniqueID()) != null) {
            void var7_14;
            sb.append("SubjectUID: ");
            boolean[] blArray = sUID;
            int n = blArray.length;
            boolean bl = false;
            while (var7_14 < n) {
                boolean b = blArray[var7_14];
                sb.append(b ? 1 : 0);
                ++var7_14;
            }
            sb.append("\n");
        }
        if ((sKeyID = x509Cert.getSubjectKeyIdentifierExtension()) != null) {
            KeyIdentifier keyID = sKeyID.getKeyIdentifier();
            sb.append("SubjKeyID:  ").append(keyID.toString());
        }
        if ((aKeyID = x509Cert.getAuthorityKeyIdentifierExtension()) != null) {
            KeyIdentifier keyIdentifier = aKeyID.getKeyIdentifier();
            sb.append("AuthKeyID:  ").append(keyIdentifier.toString());
        }
        return sb.toString();
    }

    public String throwableToString() {
        StringBuilder sb = new StringBuilder("Exception:  ");
        if (this.throwable != null) {
            sb.append(this.throwable.toString());
        } else {
            sb.append("null");
        }
        sb.append("\n");
        return sb.toString();
    }

    public String moreToString() {
        return "Last cert?  " + (this.index == -1 ? "Yes" : "No") + "\n";
    }

    public String indexToString() {
        return "Index:      " + this.index + "\n";
    }
}

