/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.util;

import com.tencent.kona.sun.security.util.AbstractAlgorithmConstraints;
import com.tencent.kona.sun.security.util.AlgorithmDecomposer;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.util.Set;

public class LegacyAlgorithmConstraints
extends AbstractAlgorithmConstraints {
    public static final String PROPERTY_TLS_LEGACY_ALGS = "jdk.tls.legacyAlgorithms";
    private final Set<String> legacyAlgorithms;

    public LegacyAlgorithmConstraints(String propertyName, AlgorithmDecomposer decomposer) {
        super(decomposer);
        this.legacyAlgorithms = LegacyAlgorithmConstraints.getAlgorithms(propertyName);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> primitives, String algorithm, AlgorithmParameters parameters) {
        if (primitives == null || primitives.isEmpty()) {
            throw new IllegalArgumentException("The primitives cannot be null or empty.");
        }
        return LegacyAlgorithmConstraints.checkAlgorithm(this.legacyAlgorithms, algorithm, this.decomposer);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> primitives, Key key) {
        if (primitives == null || primitives.isEmpty()) {
            throw new IllegalArgumentException("The primitives cannot be null or empty.");
        }
        return true;
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
        if (primitives == null || primitives.isEmpty()) {
            throw new IllegalArgumentException("The primitives cannot be null or empty.");
        }
        return LegacyAlgorithmConstraints.checkAlgorithm(this.legacyAlgorithms, algorithm, this.decomposer);
    }
}

