/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.util;

import com.tencent.kona.java.util.HexFormat;
import com.tencent.kona.sun.net.util.IPAddressUtil;
import com.tencent.kona.sun.security.action.GetBooleanAction;
import com.tencent.kona.sun.security.action.GetIntegerAction;
import com.tencent.kona.sun.security.action.GetPropertyAction;
import com.tencent.kona.sun.security.util.SSLLogger;
import java.math.BigInteger;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;

public class Utilities {
    public static final BigInteger BIG_TWO = BigInteger.valueOf(2L);
    private static final String indent = "  ";
    private static final Pattern lineBreakPatern = Pattern.compile("\\r\\n|\\n|\\r");
    private static final HexFormat HEX_FORMATTER = HexFormat.of().withUpperCase();

    public static List<SNIServerName> addToSNIServerNameList(List<SNIServerName> serverNames, String hostname) {
        SNIHostName sniHostName = Utilities.rawToSNIHostName(hostname);
        if (sniHostName == null) {
            return serverNames;
        }
        int size = serverNames.size();
        ArrayList<SNIServerName> sniList = size != 0 ? new ArrayList<SNIServerName>(serverNames) : new ArrayList(1);
        boolean reset = false;
        for (int i = 0; i < size; ++i) {
            SNIServerName serverName = (SNIServerName)sniList.get(i);
            if (serverName.getType() != 0) continue;
            sniList.set(i, sniHostName);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.fine("the previous server name in SNI (" + serverName + ") was replaced with (" + sniHostName + ")", new Object[0]);
            }
            reset = true;
            break;
        }
        if (!reset) {
            sniList.add(sniHostName);
        }
        return Collections.unmodifiableList(sniList);
    }

    private static SNIHostName rawToSNIHostName(String hostname) {
        block4: {
            if (hostname != null && hostname.endsWith(".")) {
                hostname = hostname.substring(0, hostname.length() - 1);
            }
            if (!(hostname == null || hostname.indexOf(46) <= 0 || hostname.endsWith(".") || IPAddressUtil.isIPv4LiteralAddress(hostname) || IPAddressUtil.isIPv6LiteralAddress(hostname))) {
                try {
                    return new SNIHostName(hostname);
                }
                catch (IllegalArgumentException iae) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) break block4;
                    SSLLogger.fine(hostname + "\" is not a legal HostName for  server name indication", new Object[0]);
                }
            }
        }
        return null;
    }

    public static boolean getBooleanProperty(String propName, boolean defaultValue) {
        String b = GetPropertyAction.privilegedGetProperty((String)propName);
        if (b == null) {
            return defaultValue;
        }
        if (b.equalsIgnoreCase("false")) {
            return false;
        }
        if (b.equalsIgnoreCase("true")) {
            return true;
        }
        throw new RuntimeException("Value of " + propName + " must either be 'true' or 'false'");
    }

    public static String indent(String source) {
        return Utilities.indent(source, indent);
    }

    public static String indent(String source, String prefix) {
        StringBuilder builder = new StringBuilder();
        if (source == null) {
            builder.append("\n").append(prefix).append("<blank message>");
        } else {
            String[] lines = lineBreakPatern.split(source);
            boolean isFirst = true;
            for (String line : lines) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    builder.append("\n");
                }
                builder.append(prefix).append(line);
            }
        }
        return builder.toString();
    }

    public static String byte16HexString(int id) {
        return "0x" + HEX_FORMATTER.toHexDigits((short)id);
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        return HEX_FORMATTER.formatHex(bytes);
    }

    public static String toHexString(long lv) {
        StringBuilder builder = new StringBuilder(128);
        boolean isFirst = true;
        do {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(' ');
            }
            HEX_FORMATTER.toHexDigits((Appendable)builder, (byte)lv);
        } while ((lv >>>= 8) != 0L);
        builder.reverse();
        return builder.toString();
    }

    public static byte[] toByteArray(BigInteger bi) {
        byte[] b = bi.toByteArray();
        if (b.length > 1 && b[0] == 0) {
            int n = b.length - 1;
            byte[] newarray = new byte[n];
            System.arraycopy(b, 1, newarray, 0, n);
            b = newarray;
        }
        return b;
    }

    public static void reverseBytes(byte[] arr) {
        int i = 0;
        for (int j = arr.length - 1; i < j; ++i, --j) {
            Utilities.swap(arr, i, j);
        }
    }

    private static void swap(byte[] arr, int i, int j) {
        byte tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    public static String privilegedGetProperty(String theProp, String defaultVal) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(theProp, defaultVal);
        }
        return (String)AccessController.doPrivileged(new GetPropertyAction(theProp, defaultVal));
    }

    public static boolean privilegedGetBooleanProperty(String theProp) {
        if (System.getSecurityManager() == null) {
            return Boolean.getBoolean(theProp);
        }
        return (Boolean)AccessController.doPrivileged(new GetBooleanAction(theProp));
    }

    public static Integer privilegedGetIntegerProperty(String theProp, int defaultValue) {
        if (System.getSecurityManager() == null) {
            return Integer.getInteger(theProp, defaultValue);
        }
        return (Integer)AccessController.doPrivileged(new GetIntegerAction(theProp));
    }

    public static Integer privilegedGetIntegerProperty(String theProp) {
        if (System.getSecurityManager() == null) {
            return Integer.getInteger(theProp);
        }
        return (Integer)AccessController.doPrivileged(new GetIntegerAction(theProp));
    }
}

