/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.pkcs;

import com.tencent.kona.crypto.CryptoInsts;
import com.tencent.kona.pkix.PKIXInsts;
import com.tencent.kona.sun.security.pkcs.ContentInfo;
import com.tencent.kona.sun.security.pkcs.PKCS9Attribute;
import com.tencent.kona.sun.security.pkcs.PKCS9Attributes;
import com.tencent.kona.sun.security.pkcs.ParsingException;
import com.tencent.kona.sun.security.pkcs.SignerInfo;
import com.tencent.kona.sun.security.timestamp.HttpTimestamper;
import com.tencent.kona.sun.security.timestamp.TSRequest;
import com.tencent.kona.sun.security.timestamp.TSResponse;
import com.tencent.kona.sun.security.timestamp.TimestampToken;
import com.tencent.kona.sun.security.timestamp.Timestamper;
import com.tencent.kona.sun.security.util.Debug;
import com.tencent.kona.sun.security.util.DerEncoder;
import com.tencent.kona.sun.security.util.DerInputStream;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.util.KnownOIDs;
import com.tencent.kona.sun.security.util.ObjectIdentifier;
import com.tencent.kona.sun.security.util.Oid;
import com.tencent.kona.sun.security.util.SignatureUtil;
import com.tencent.kona.sun.security.x509.AccessDescription;
import com.tencent.kona.sun.security.x509.AlgorithmId;
import com.tencent.kona.sun.security.x509.GeneralName;
import com.tencent.kona.sun.security.x509.URIName;
import com.tencent.kona.sun.security.x509.X500Name;
import com.tencent.kona.sun.security.x509.X509CRLImpl;
import com.tencent.kona.sun.security.x509.X509CertImpl;
import com.tencent.kona.sun.security.x509.X509CertInfo;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;

public class PKCS7 {
    private BigInteger version = null;
    private AlgorithmId[] digestAlgorithmIds = null;
    private ContentInfo contentInfo = null;
    private X509Certificate[] certificates = null;
    private X509CRL[] crls = null;
    private SignerInfo[] signerInfos = null;
    private boolean oldStyle = false;
    private Principal[] certIssuerNames;

    public PKCS7(InputStream in) throws IOException {
        DataInputStream dis = new DataInputStream(in);
        byte[] data = new byte[dis.available()];
        dis.readFully(data);
        this.parse(new DerInputStream(data));
    }

    public PKCS7(DerInputStream derin) throws ParsingException {
        this.parse(derin);
    }

    public PKCS7(byte[] bytes) throws ParsingException {
        try {
            DerInputStream derin = new DerInputStream(bytes);
            this.parse(derin);
        }
        catch (IOException ioe1) {
            ParsingException pe = new ParsingException("Unable to parse the encoded bytes");
            pe.initCause(ioe1);
            throw pe;
        }
    }

    private void parse(DerInputStream derin) throws ParsingException {
        try {
            derin.mark(derin.available());
            this.parse(derin, false);
        }
        catch (IOException ioe) {
            try {
                derin.reset();
                this.parse(derin, true);
                this.oldStyle = true;
            }
            catch (IOException ioe1) {
                ParsingException pe = new ParsingException(ioe1.getMessage());
                pe.initCause(ioe);
                pe.addSuppressed(ioe1);
                throw pe;
            }
        }
    }

    private void parse(DerInputStream derin, boolean oldStyle) throws IOException {
        ContentInfo block = new ContentInfo(derin, oldStyle);
        ObjectIdentifier contentType = block.contentType;
        DerValue content = block.getContent();
        if (contentType.equals((Object)ContentInfo.SIGNED_DATA_OID)) {
            this.parseSignedData(content);
        } else if (contentType.equals((Object)ContentInfo.OLD_SIGNED_DATA_OID)) {
            this.parseOldSignedData(content);
        } else if (contentType.equals((Object)ContentInfo.NETSCAPE_CERT_SEQUENCE_OID)) {
            this.parseNetscapeCertChain(content);
            this.contentInfo = block;
        } else {
            throw new ParsingException("content type " + contentType + " not supported.");
        }
    }

    public PKCS7(AlgorithmId[] digestAlgorithmIds, ContentInfo contentInfo, X509Certificate[] certificates, X509CRL[] crls, SignerInfo[] signerInfos) {
        this.version = BigInteger.ONE;
        this.digestAlgorithmIds = digestAlgorithmIds;
        this.contentInfo = contentInfo;
        this.certificates = certificates;
        this.crls = crls;
        this.signerInfos = signerInfos;
    }

    public PKCS7(AlgorithmId[] digestAlgorithmIds, ContentInfo contentInfo, X509Certificate[] certificates, SignerInfo[] signerInfos) {
        this(digestAlgorithmIds, contentInfo, certificates, null, signerInfos);
    }

    private void parseNetscapeCertChain(DerValue val) throws IOException {
        DerInputStream dis = new DerInputStream(val.toByteArray());
        DerValue[] contents = dis.getSequence(2);
        this.certificates = new X509Certificate[contents.length];
        CertificateFactory certfac = null;
        try {
            certfac = PKIXInsts.getCertificateFactory("X.509");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        for (int i = 0; i < contents.length; ++i) {
            try (ByteArrayInputStream bais = null;){
                if (certfac == null) {
                    this.certificates[i] = new X509CertImpl(contents[i]);
                    continue;
                }
                byte[] encoded = contents[i].toByteArray();
                bais = new ByteArrayInputStream(encoded);
                this.certificates[i] = (X509Certificate)certfac.generateCertificate(bais);
                bais.close();
                bais = null;
                continue;
            }
        }
    }

    private void parseSignedData(DerValue val) throws IOException {
        int i;
        DerInputStream dis = val.toDerInputStream();
        this.version = dis.getBigInteger();
        DerValue[] digestAlgorithmIdVals = dis.getSet(1);
        int len = digestAlgorithmIdVals.length;
        this.digestAlgorithmIds = new AlgorithmId[len];
        try {
            for (int i2 = 0; i2 < len; ++i2) {
                DerValue oid = digestAlgorithmIdVals[i2];
                this.digestAlgorithmIds[i2] = AlgorithmId.parse((DerValue)oid);
            }
        }
        catch (IOException e) {
            ParsingException pe = new ParsingException("Error parsing digest AlgorithmId IDs: " + e.getMessage());
            pe.initCause(e);
            throw pe;
        }
        this.contentInfo = new ContentInfo(dis);
        CertificateFactory certfac = null;
        try {
            certfac = PKIXInsts.getCertificateFactory("X.509");
        }
        catch (CertificateException pe) {
            // empty catch block
        }
        if ((byte)dis.peekByte() == -96) {
            DerValue[] certVals = dis.getSet(2, true);
            len = certVals.length;
            this.certificates = new X509Certificate[len];
            int count = 0;
            for (int i3 = 0; i3 < len; ++i3) {
                try (ByteArrayInputStream bais = null;){
                    byte tag = certVals[i3].getTag();
                    if (tag != 48) continue;
                    if (certfac == null) {
                        this.certificates[count] = new X509CertImpl(certVals[i3]);
                    } else {
                        byte[] encoded = certVals[i3].toByteArray();
                        bais = new ByteArrayInputStream(encoded);
                        this.certificates[count] = (X509Certificate)certfac.generateCertificate(bais);
                        bais.close();
                        bais = null;
                    }
                    ++count;
                    continue;
                }
            }
            if (count != len) {
                this.certificates = Arrays.copyOf(this.certificates, count);
            }
        }
        if ((byte)dis.peekByte() == -95) {
            DerValue[] crlVals = dis.getSet(1, true);
            len = crlVals.length;
            this.crls = new X509CRL[len];
            for (i = 0; i < len; ++i) {
                try (ByteArrayInputStream bais = null;){
                    if (certfac == null) {
                        this.crls[i] = new X509CRLImpl(crlVals[i]);
                        continue;
                    }
                    byte[] encoded = crlVals[i].toByteArray();
                    bais = new ByteArrayInputStream(encoded);
                    this.crls[i] = (X509CRL)certfac.generateCRL(bais);
                    bais.close();
                    bais = null;
                    continue;
                }
            }
        }
        DerValue[] signerInfoVals = dis.getSet(1);
        len = signerInfoVals.length;
        this.signerInfos = new SignerInfo[len];
        for (i = 0; i < len; ++i) {
            DerInputStream in = signerInfoVals[i].toDerInputStream();
            this.signerInfos[i] = new SignerInfo(in);
        }
    }

    private void parseOldSignedData(DerValue val) throws IOException {
        DerInputStream dis = val.toDerInputStream();
        this.version = dis.getBigInteger();
        DerValue[] digestAlgorithmIdVals = dis.getSet(1);
        int len = digestAlgorithmIdVals.length;
        this.digestAlgorithmIds = new AlgorithmId[len];
        try {
            for (int i = 0; i < len; ++i) {
                DerValue oid = digestAlgorithmIdVals[i];
                this.digestAlgorithmIds[i] = AlgorithmId.parse((DerValue)oid);
            }
        }
        catch (IOException e) {
            throw new ParsingException("Error parsing digest AlgorithmId IDs");
        }
        this.contentInfo = new ContentInfo(dis, true);
        CertificateFactory certfac = null;
        try {
            certfac = PKIXInsts.getCertificateFactory("X.509");
        }
        catch (CertificateException oid) {
            // empty catch block
        }
        DerValue[] certVals = dis.getSet(2);
        len = certVals.length;
        this.certificates = new X509Certificate[len];
        for (int i = 0; i < len; ++i) {
            try (ByteArrayInputStream bais = null;){
                if (certfac == null) {
                    this.certificates[i] = new X509CertImpl(certVals[i]);
                    continue;
                }
                byte[] encoded = certVals[i].toByteArray();
                bais = new ByteArrayInputStream(encoded);
                this.certificates[i] = (X509Certificate)certfac.generateCertificate(bais);
                bais.close();
                bais = null;
                continue;
            }
        }
        dis.getSet(0);
        DerValue[] signerInfoVals = dis.getSet(1);
        len = signerInfoVals.length;
        this.signerInfos = new SignerInfo[len];
        for (int i = 0; i < len; ++i) {
            DerInputStream in = signerInfoVals[i].toDerInputStream();
            this.signerInfos[i] = new SignerInfo(in, true);
        }
    }

    public void encodeSignedData(DerOutputStream out) throws IOException {
        DerOutputStream signedData = new DerOutputStream();
        signedData.putInteger(this.version);
        signedData.putOrderedSetOf((byte)49, (DerEncoder[])this.digestAlgorithmIds);
        this.contentInfo.encode(signedData);
        if (this.certificates != null && this.certificates.length != 0) {
            DerEncoder[] implCerts = new X509CertImpl[this.certificates.length];
            for (int i = 0; i < this.certificates.length; ++i) {
                if (this.certificates[i] instanceof X509CertImpl) {
                    implCerts[i] = (X509CertImpl)this.certificates[i];
                    continue;
                }
                try {
                    byte[] encoded = this.certificates[i].getEncoded();
                    implCerts[i] = new X509CertImpl(encoded);
                    continue;
                }
                catch (CertificateException ce) {
                    throw new IOException(ce);
                }
            }
            signedData.putOrderedSetOf((byte)-96, implCerts);
        }
        if (this.crls != null && this.crls.length != 0) {
            HashSet<X509CRLImpl> implCRLs = new HashSet<X509CRLImpl>(this.crls.length);
            for (X509CRL crl : this.crls) {
                if (crl instanceof X509CRLImpl) {
                    implCRLs.add((X509CRLImpl)crl);
                    continue;
                }
                try {
                    byte[] encoded = crl.getEncoded();
                    implCRLs.add(new X509CRLImpl(encoded));
                }
                catch (CRLException ce) {
                    throw new IOException(ce);
                }
            }
            signedData.putOrderedSetOf((byte)-95, (DerEncoder[])implCRLs.toArray(new X509CRLImpl[0]));
        }
        signedData.putOrderedSetOf((byte)49, (DerEncoder[])this.signerInfos);
        DerValue signedDataSeq = new DerValue(48, signedData.toByteArray());
        ContentInfo block = new ContentInfo(ContentInfo.SIGNED_DATA_OID, signedDataSeq);
        block.encode(out);
    }

    public SignerInfo verify(SignerInfo info, byte[] bytes) throws NoSuchAlgorithmException, SignatureException {
        return info.verify(this, bytes);
    }

    public SignerInfo[] verify(byte[] bytes) throws NoSuchAlgorithmException, SignatureException {
        ArrayList<SignerInfo> intResult = new ArrayList<SignerInfo>();
        for (int i = 0; i < this.signerInfos.length; ++i) {
            SignerInfo signerInfo = this.verify(this.signerInfos[i], bytes);
            if (signerInfo == null) continue;
            intResult.add(signerInfo);
        }
        if (!intResult.isEmpty()) {
            SignerInfo[] result = new SignerInfo[intResult.size()];
            return intResult.toArray(result);
        }
        return null;
    }

    public SignerInfo[] verify() throws NoSuchAlgorithmException, SignatureException {
        return this.verify(null);
    }

    public BigInteger getVersion() {
        return this.version;
    }

    public AlgorithmId[] getDigestAlgorithmIds() {
        return this.digestAlgorithmIds;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public X509Certificate[] getCertificates() {
        if (this.certificates != null) {
            return (X509Certificate[])this.certificates.clone();
        }
        return null;
    }

    public X509CRL[] getCRLs() {
        if (this.crls != null) {
            return (X509CRL[])this.crls.clone();
        }
        return null;
    }

    public SignerInfo[] getSignerInfos() {
        return this.signerInfos;
    }

    public X509Certificate getCertificate(BigInteger serial, X500Name issuerName) {
        if (this.certificates != null) {
            if (this.certIssuerNames == null) {
                this.populateCertIssuerNames();
            }
            for (int i = 0; i < this.certificates.length; ++i) {
                X509Certificate cert = this.certificates[i];
                BigInteger thisSerial = cert.getSerialNumber();
                if (!serial.equals(thisSerial) || !issuerName.equals(this.certIssuerNames[i])) continue;
                return cert;
            }
        }
        return null;
    }

    private void populateCertIssuerNames() {
        if (this.certificates == null) {
            return;
        }
        this.certIssuerNames = new Principal[this.certificates.length];
        for (int i = 0; i < this.certificates.length; ++i) {
            X509Certificate cert = this.certificates[i];
            Principal certIssuerName = cert.getIssuerDN();
            if (!(certIssuerName instanceof X500Name)) {
                try {
                    X509CertInfo tbsCert = new X509CertInfo(cert.getTBSCertificate());
                    certIssuerName = tbsCert.getIssuer();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.certIssuerNames[i] = certIssuerName;
        }
    }

    public String toString() {
        int i;
        String out = "";
        out = out + this.contentInfo + "\n";
        if (this.version != null) {
            out = out + "PKCS7 :: version: " + Debug.toHexString((BigInteger)this.version) + "\n";
        }
        if (this.digestAlgorithmIds != null) {
            out = out + "PKCS7 :: digest AlgorithmIds: \n";
            for (i = 0; i < this.digestAlgorithmIds.length; ++i) {
                out = out + "\t" + this.digestAlgorithmIds[i] + "\n";
            }
        }
        if (this.certificates != null) {
            out = out + "PKCS7 :: certificates: \n";
            for (i = 0; i < this.certificates.length; ++i) {
                out = out + "\t" + i + ".   " + this.certificates[i] + "\n";
            }
        }
        if (this.crls != null) {
            out = out + "PKCS7 :: crls: \n";
            for (i = 0; i < this.crls.length; ++i) {
                out = out + "\t" + i + ".   " + this.crls[i] + "\n";
            }
        }
        if (this.signerInfos != null) {
            out = out + "PKCS7 :: signer infos: \n";
            for (i = 0; i < this.signerInfos.length; ++i) {
                out = out + "\t" + i + ".  " + this.signerInfos[i] + "\n";
            }
        }
        return out;
    }

    public boolean isOldStyle() {
        return this.oldStyle;
    }

    public static byte[] generateNewSignedData(String sigalg, Provider sigProvider, PrivateKey privateKey, X509Certificate[] signerChain, byte[] content, boolean internalsf, boolean directsign, Function<byte[], PKCS9Attributes> ts) throws SignatureException, InvalidKeyException, IOException, NoSuchAlgorithmException {
        Signature signer = SignatureUtil.fromKey(sigalg, privateKey, sigProvider);
        AlgorithmId digAlgID = SignatureUtil.getDigestAlgInPkcs7SignerInfo(signer, sigalg, privateKey, directsign);
        AlgorithmId sigAlgID = SignatureUtil.fromSignature(signer, privateKey);
        PKCS9Attributes authAttrs = null;
        if (!directsign) {
            byte[] md = CryptoInsts.getMessageDigest((String)digAlgID.getName()).digest(content);
            DerOutputStream derAp = new DerOutputStream();
            DerOutputStream derAlgs = new DerOutputStream();
            digAlgID.encode(derAlgs);
            DerOutputStream derSigAlg = new DerOutputStream();
            sigAlgID.encode(derSigAlg);
            derAlgs.writeImplicit((byte)-95, derSigAlg);
            derAp.write((byte)48, derAlgs);
            authAttrs = new PKCS9Attributes(new PKCS9Attribute[]{new PKCS9Attribute(PKCS9Attribute.CONTENT_TYPE_OID, ContentInfo.DATA_OID), new PKCS9Attribute(PKCS9Attribute.SIGNING_TIME_OID, new Date()), new PKCS9Attribute(PKCS9Attribute.CMS_ALGORITHM_PROTECTION_OID, derAp.toByteArray()), new PKCS9Attribute(PKCS9Attribute.MESSAGE_DIGEST_OID, md)});
            signer.update(authAttrs.getDerEncoding());
        } else {
            signer.update(content);
        }
        byte[] signature = signer.sign();
        return PKCS7.constructToken(signature, signerChain, (byte[])(internalsf ? content : null), authAttrs, ts == null ? null : ts.apply(signature), digAlgID, sigAlgID);
    }

    private static byte[] constructToken(byte[] signature, X509Certificate[] signerChain, byte[] content, PKCS9Attributes authAttrs, PKCS9Attributes unauthAttrs, AlgorithmId digAlgID, AlgorithmId encAlgID) throws IOException {
        X500Name issuerName = X500Name.asX500Name(signerChain[0].getIssuerX500Principal());
        BigInteger serialNumber = signerChain[0].getSerialNumber();
        SignerInfo signerInfo = new SignerInfo(issuerName, serialNumber, digAlgID, authAttrs, encAlgID, signature, unauthAttrs);
        SignerInfo[] signerInfos = new SignerInfo[]{signerInfo};
        AlgorithmId[] algorithms = new AlgorithmId[]{signerInfo.getDigestAlgorithmId()};
        ContentInfo contentInfo = content == null ? new ContentInfo(ContentInfo.DATA_OID, null) : new ContentInfo(content);
        PKCS7 pkcs7 = new PKCS7(algorithms, contentInfo, signerChain, signerInfos);
        DerOutputStream p7out = new DerOutputStream();
        pkcs7.encodeSignedData(p7out);
        return p7out.toByteArray();
    }

    public static byte[] generateSignedData(byte[] signature, X509Certificate[] signerChain, byte[] content, String signatureAlgorithm, URI tsaURI, String tSAPolicyID, String tSADigestAlg) throws CertificateException, IOException, NoSuchAlgorithmException {
        PKCS9Attributes unauthAttrs = null;
        if (tsaURI != null) {
            HttpTimestamper tsa = new HttpTimestamper(tsaURI);
            byte[] tsToken = PKCS7.generateTimestampToken(tsa, tSAPolicyID, tSADigestAlg, signature);
            unauthAttrs = new PKCS9Attributes(new PKCS9Attribute[]{new PKCS9Attribute(PKCS9Attribute.SIGNATURE_TIMESTAMP_TOKEN_OID, tsToken)});
        }
        return PKCS7.constructToken(signature, signerChain, content, null, unauthAttrs, AlgorithmId.get((String)SignatureUtil.extractDigestAlgFromDwithE(signatureAlgorithm)), AlgorithmId.get((String)signatureAlgorithm));
    }

    public static URI getTimestampingURI(X509Certificate tsaCertificate) {
        if (tsaCertificate == null) {
            return null;
        }
        try {
            byte[] extensionValue = tsaCertificate.getExtensionValue(KnownOIDs.SubjectInfoAccess.value());
            if (extensionValue == null) {
                return null;
            }
            DerInputStream der = new DerInputStream(extensionValue);
            der = new DerInputStream(der.getOctetString());
            DerValue[] derValue = der.getSequence(5);
            for (int i = 0; i < derValue.length; ++i) {
                URIName uri;
                GeneralName location;
                AccessDescription description = new AccessDescription(derValue[i]);
                if (!description.getAccessMethod().equals((Object)Oid.of((KnownOIDs)KnownOIDs.AD_TimeStamping)) || (location = description.getAccessLocation()).getType() != 6 || !(uri = (URIName)location.getName()).getScheme().equalsIgnoreCase("http") && !uri.getScheme().equalsIgnoreCase("https")) continue;
                return uri.getURI();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static byte[] generateTimestampToken(Timestamper tsa, String tSAPolicyID, String tSADigestAlg, byte[] toBeTimestamped) throws IOException, CertificateException {
        TSRequest tsQuery;
        try {
            MessageDigest messageDigest = CryptoInsts.getMessageDigest((String)tSADigestAlg);
            tsQuery = new TSRequest(tSAPolicyID, toBeTimestamped, messageDigest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        BigInteger nonce = null;
        if (SecureRandomHolder.RANDOM != null) {
            nonce = new BigInteger(64, SecureRandomHolder.RANDOM);
            tsQuery.setNonce(nonce);
        }
        tsQuery.requestCertificate(true);
        TSResponse tsReply = tsa.generateTimestamp(tsQuery);
        int status = tsReply.getStatusCode();
        if (status != 0 && status != 1) {
            throw new IOException("Error generating timestamp: " + tsReply.getStatusCodeAsText() + " " + tsReply.getFailureCodeAsText());
        }
        if (tSAPolicyID != null && !tSAPolicyID.equals(tsReply.getTimestampToken().getPolicyID())) {
            throw new IOException("TSAPolicyID changed in timestamp token");
        }
        PKCS7 tsToken = tsReply.getToken();
        TimestampToken tst = tsReply.getTimestampToken();
        try {
            if (!tst.getHashAlgorithm().equals(AlgorithmId.get((String)tSADigestAlg))) {
                throw new IOException("Digest algorithm not " + tSADigestAlg + " in timestamp token");
            }
        }
        catch (NoSuchAlgorithmException nase) {
            throw new IllegalArgumentException();
        }
        if (!MessageDigest.isEqual(tst.getHashedMessage(), tsQuery.getHashedMessage())) {
            throw new IOException("Digest octets changed in timestamp token");
        }
        BigInteger replyNonce = tst.getNonce();
        if (replyNonce == null && nonce != null) {
            throw new IOException("Nonce missing in timestamp token");
        }
        if (replyNonce != null && !replyNonce.equals(nonce)) {
            throw new IOException("Nonce changed in timestamp token");
        }
        for (SignerInfo si : tsToken.getSignerInfos()) {
            X509Certificate cert = si.getCertificate(tsToken);
            if (cert == null) {
                throw new CertificateException("Certificate not included in timestamp token");
            }
            if (!cert.getCriticalExtensionOIDs().contains(KnownOIDs.extendedKeyUsage.value())) {
                throw new CertificateException("Certificate is not valid for timestamping");
            }
            List<String> keyPurposes = cert.getExtendedKeyUsage();
            if (keyPurposes != null && keyPurposes.contains(KnownOIDs.KP_TimeStamping.value())) continue;
            throw new CertificateException("Certificate is not valid for timestamping");
        }
        return tsReply.getEncodedToken();
    }

    private static class SecureRandomHolder {
        static final SecureRandom RANDOM;

        private SecureRandomHolder() {
        }

        static {
            SecureRandom tmp = null;
            try {
                tmp = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            RANDOM = tmp;
        }
    }
}

