/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.pkcs12;

import com.tencent.kona.sun.security.pkcs.ParsingException;
import com.tencent.kona.sun.security.util.DerInputStream;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.x509.AlgorithmId;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;

class MacData {
    private final String digestAlgorithmName;
    private AlgorithmParameters digestAlgorithmParams;
    private final byte[] digest;
    private final byte[] macSalt;
    private final int iterations;
    private byte[] encoded = null;

    MacData(DerInputStream derin) throws IOException {
        DerValue[] macData = derin.getSequence(2);
        if (macData.length < 2 || macData.length > 3) {
            throw new ParsingException("Invalid length for MacData");
        }
        DerInputStream digestIn = new DerInputStream(macData[0].toByteArray());
        DerValue[] digestInfo = digestIn.getSequence(2);
        if (digestInfo.length != 2) {
            throw new ParsingException("Invalid length for DigestInfo");
        }
        AlgorithmId digestAlgorithmId = AlgorithmId.parse((DerValue)digestInfo[0]);
        this.digestAlgorithmName = digestAlgorithmId.getName();
        this.digestAlgorithmParams = digestAlgorithmId.getParameters();
        this.digest = digestInfo[1].getOctetString();
        this.macSalt = macData[1].getOctetString();
        this.iterations = macData.length > 2 ? macData[2].getInteger() : 1;
    }

    MacData(String algName, byte[] digest, byte[] salt, int iterations) throws NoSuchAlgorithmException {
        if (algName == null) {
            throw new NullPointerException("the algName parameter must be non-null");
        }
        AlgorithmId algid = AlgorithmId.get((String)algName);
        this.digestAlgorithmName = algid.getName();
        this.digestAlgorithmParams = algid.getParameters();
        if (digest == null) {
            throw new NullPointerException("the digest parameter must be non-null");
        }
        if (digest.length == 0) {
            throw new IllegalArgumentException("the digest parameter must not be empty");
        }
        this.digest = (byte[])digest.clone();
        this.macSalt = salt;
        this.iterations = iterations;
        this.encoded = null;
    }

    String getDigestAlgName() {
        return this.digestAlgorithmName;
    }

    byte[] getSalt() {
        return this.macSalt;
    }

    int getIterations() {
        return this.iterations;
    }

    byte[] getDigest() {
        return this.digest;
    }

    public byte[] getEncoded() throws NoSuchAlgorithmException {
        if (this.encoded != null) {
            return (byte[])this.encoded.clone();
        }
        DerOutputStream out = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        DerOutputStream tmp2 = new DerOutputStream();
        AlgorithmId algid = AlgorithmId.get((String)this.digestAlgorithmName);
        algid.encode(tmp2);
        tmp2.putOctetString(this.digest);
        tmp.write((byte)48, tmp2);
        tmp.putOctetString(this.macSalt);
        tmp.putInteger(this.iterations);
        out.write((byte)48, tmp);
        this.encoded = out.toByteArray();
        return (byte[])this.encoded.clone();
    }
}

