/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.provider.certpath;

import com.tencent.kona.sun.security.action.GetIntegerAction;
import com.tencent.kona.sun.security.provider.certpath.CertId;
import com.tencent.kona.sun.security.provider.certpath.OCSPRequest;
import com.tencent.kona.sun.security.provider.certpath.OCSPResponse;
import com.tencent.kona.sun.security.util.Debug;
import com.tencent.kona.sun.security.util.IOUtils;
import com.tencent.kona.sun.security.x509.AccessDescription;
import com.tencent.kona.sun.security.x509.AuthorityInfoAccessExtension;
import com.tencent.kona.sun.security.x509.GeneralName;
import com.tencent.kona.sun.security.x509.PKIXExtensions;
import com.tencent.kona.sun.security.x509.URIName;
import com.tencent.kona.sun.security.x509.X509CertImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.cert.CRLReason;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.Extension;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Map;

public final class OCSP {
    private static final Debug debug = Debug.getInstance((String)"certpath");
    private static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    private static final int CONNECT_TIMEOUT = OCSP.initializeTimeout();

    private static int initializeTimeout() {
        Integer tmp = (Integer)AccessController.doPrivileged(new GetIntegerAction("com.sun.security.ocsp.timeout"));
        if (tmp == null || tmp < 0) {
            return 15000;
        }
        return tmp * 1000;
    }

    private OCSP() {
    }

    static OCSPResponse check(List<CertId> certIds, URI responderURI, OCSPResponse.IssuerInfo issuerInfo, X509Certificate responderCert, Date date, List<Extension> extensions, String variant) throws IOException, CertPathValidatorException {
        OCSPResponse ocspResponse;
        byte[] nonce = null;
        for (Extension ext : extensions) {
            if (!ext.getId().equals(PKIXExtensions.OCSPNonce_Id.toString())) continue;
            nonce = ext.getValue();
        }
        try {
            byte[] response = OCSP.getOCSPBytes(certIds, responderURI, extensions);
            ocspResponse = new OCSPResponse(response);
            ocspResponse.verify(certIds, issuerInfo, responderCert, date, nonce, variant);
        }
        catch (IOException ioe) {
            throw new CertPathValidatorException("Unable to determine revocation status due to network error", ioe, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
        }
        return ocspResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getOCSPBytes(List<CertId> certIds, URI responderURI, List<Extension> extensions) throws IOException {
        OCSPRequest request = new OCSPRequest(certIds, extensions);
        byte[] bytes = request.encodeBytes();
        String responder = responderURI.toString();
        if (debug != null) {
            debug.println("connecting to OCSP service at: " + responder);
        }
        HttpURLConnection con = null;
        try {
            StringBuilder encodedGetReq = new StringBuilder(responder);
            if (!responder.endsWith("/")) {
                encodedGetReq.append("/");
            }
            encodedGetReq.append(URLEncoder.encode(Base64.getEncoder().encodeToString(bytes), String.valueOf(StandardCharsets.UTF_8)));
            if (encodedGetReq.length() <= 255) {
                URL url = new URL(encodedGetReq.toString());
                con = (HttpURLConnection)url.openConnection();
                con.setDoOutput(true);
                con.setDoInput(true);
                con.setRequestMethod("GET");
            } else {
                URL url = responderURI.toURL();
                con = (HttpURLConnection)url.openConnection();
                con.setConnectTimeout(CONNECT_TIMEOUT);
                con.setReadTimeout(CONNECT_TIMEOUT);
                con.setDoOutput(true);
                con.setDoInput(true);
                con.setRequestMethod("POST");
                con.setRequestProperty("Content-type", "application/ocsp-request");
                con.setRequestProperty("Content-length", String.valueOf(bytes.length));
                OutputStream out = con.getOutputStream();
                out.write(bytes);
                out.flush();
            }
            int respCode = con.getResponseCode();
            if (respCode != 200) {
                String msg = "Received HTTP error: " + respCode + " - " + con.getResponseMessage();
                if (debug != null) {
                    debug.println(msg);
                }
                throw new IOException(msg);
            }
            int contentLength = con.getContentLength();
            byte[] byArray = contentLength == -1 ? IOUtils.readAllBytes((InputStream)con.getInputStream()) : IOUtils.readExactlyNBytes((InputStream)con.getInputStream(), (int)contentLength);
            return byArray;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    public static URI getResponderURI(X509Certificate cert) {
        try {
            return OCSP.getResponderURI(X509CertImpl.toImpl(cert));
        }
        catch (CertificateException ce) {
            return null;
        }
    }

    static URI getResponderURI(X509CertImpl certImpl) {
        AuthorityInfoAccessExtension aia = certImpl.getAuthorityInfoAccessExtension();
        if (aia == null) {
            return null;
        }
        List<AccessDescription> descriptions = aia.getAccessDescriptions();
        for (AccessDescription description : descriptions) {
            GeneralName generalName;
            if (!description.getAccessMethod().equals((Object)AccessDescription.Ad_OCSP_Id) || (generalName = description.getAccessLocation()).getType() != 6) continue;
            URIName uri = (URIName)generalName.getName();
            return uri.getURI();
        }
        return null;
    }

    public static interface RevocationStatus {
        public CertStatus getCertStatus();

        public Date getRevocationTime();

        public CRLReason getRevocationReason();

        public Map<String, Extension> getSingleExtensions();

        public static enum CertStatus {
            GOOD,
            REVOKED,
            UNKNOWN;

        }
    }
}

