/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.timestamp;

import com.tencent.kona.sun.security.timestamp.TSRequest;
import com.tencent.kona.sun.security.timestamp.TSResponse;
import com.tencent.kona.sun.security.timestamp.Timestamper;
import com.tencent.kona.sun.security.util.Debug;
import com.tencent.kona.sun.security.util.IOUtils;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HttpTimestamper
implements Timestamper {
    private static final int CONNECT_TIMEOUT = 15000;
    private static final String TS_QUERY_MIME_TYPE = "application/timestamp-query";
    private static final String TS_REPLY_MIME_TYPE = "application/timestamp-reply";
    private static final Debug debug = Debug.getInstance((String)"ts");
    private final URI tsaURI;

    public HttpTimestamper(URI tsaURI) {
        if (!tsaURI.getScheme().equalsIgnoreCase("http") && !tsaURI.getScheme().equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("TSA must be an HTTP or HTTPS URI");
        }
        this.tsaURI = tsaURI;
    }

    @Override
    public TSResponse generateTimestamp(TSRequest tsQuery) throws IOException {
        byte[] replyBuffer;
        HttpURLConnection connection = (HttpURLConnection)this.tsaURI.toURL().openConnection();
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.setRequestProperty("Content-Type", TS_QUERY_MIME_TYPE);
        connection.setRequestMethod("POST");
        connection.setConnectTimeout(15000);
        if (debug != null) {
            Set<Map.Entry<String, List<String>>> headers = connection.getRequestProperties().entrySet();
            debug.println(connection.getRequestMethod() + " " + this.tsaURI + " HTTP/1.1");
            for (Map.Entry entry : headers) {
                debug.println("  " + entry);
            }
            debug.println();
        }
        connection.connect();
        DataOutputStream output = new DataOutputStream(connection.getOutputStream());
        Object object = null;
        try {
            byte[] throwable = tsQuery.encode();
            output.write(throwable, 0, throwable.length);
            output.flush();
            if (debug != null) {
                debug.println("sent timestamp query (length=" + throwable.length + ")");
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (output != null) {
                if (object != null) {
                    try {
                        output.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    output.close();
                }
            }
        }
        Throwable throwable = null;
        try (InputStream input = connection.getInputStream();){
            if (debug != null) {
                String header = connection.getHeaderField(0);
                debug.println(header);
                int i = 1;
                while ((header = connection.getHeaderField(i)) != null) {
                    String key = connection.getHeaderFieldKey(i);
                    debug.println("  " + (key == null ? "" : key + ": ") + header);
                    ++i;
                }
                debug.println();
            }
            HttpTimestamper.verifyMimeType(connection.getContentType());
            int clen = connection.getContentLength();
            replyBuffer = IOUtils.readAllBytes((InputStream)input);
            if (clen != -1 && replyBuffer.length != clen) {
                throw new EOFException("Expected:" + clen + ", read:" + replyBuffer.length);
            }
            if (debug != null) {
                debug.println("received timestamp response (length=" + replyBuffer.length + ")");
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        return new TSResponse(replyBuffer);
    }

    private static void verifyMimeType(String contentType) throws IOException {
        if (!TS_REPLY_MIME_TYPE.equalsIgnoreCase(contentType)) {
            throw new IOException("MIME Content-Type is not application/timestamp-reply");
        }
    }
}

