/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.util;

import com.tencent.kona.crypto.CryptoInsts;
import com.tencent.kona.jdk.internal.misc.SharedSecretsUtil;
import com.tencent.kona.sun.security.rsa.RSAUtil;
import com.tencent.kona.sun.security.util.KeyUtil;
import com.tencent.kona.sun.security.util.KnownOIDs;
import com.tencent.kona.sun.security.x509.AlgorithmId;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PSSParameterSpec;
import java.util.Locale;

public class SignatureUtil {
    private static String checkName(String algName) {
        if ((algName = algName.toUpperCase(Locale.ENGLISH)).contains(".")) {
            KnownOIDs ko;
            if (algName.startsWith("OID.")) {
                algName = algName.substring(4);
            }
            if ((ko = KnownOIDs.findMatch((String)algName)) != null) {
                return ko.stdName().toUpperCase(Locale.ENGLISH);
            }
        }
        return algName;
    }

    private static AlgorithmParameters createAlgorithmParameters(String algName, byte[] paramBytes) throws ProviderException {
        try {
            algName = SignatureUtil.checkName(algName);
            AlgorithmParameters result = CryptoInsts.getAlgorithmParameters((String)algName);
            result.init(paramBytes);
            return result;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new ProviderException(e);
        }
    }

    public static AlgorithmParameterSpec getParamSpec(String sigName, AlgorithmParameters params) throws ProviderException {
        AlgorithmParameterSpec paramSpec = null;
        if (params != null) {
            sigName = SignatureUtil.checkName(sigName);
            if (params.getAlgorithm().contains(".")) {
                try {
                    params = SignatureUtil.createAlgorithmParameters(sigName, params.getEncoded());
                }
                catch (IOException e) {
                    throw new ProviderException(e);
                }
            }
            if (sigName.contains("RSA")) {
                paramSpec = RSAUtil.getParamSpec((AlgorithmParameters)params);
            } else if (sigName.contains("ECDSA")) {
                try {
                    paramSpec = params.getParameterSpec(ECParameterSpec.class);
                }
                catch (Exception e) {
                    throw new ProviderException("Error handling EC parameters", e);
                }
            } else {
                throw new ProviderException("Unrecognized algorithm for signature parameters " + sigName);
            }
        }
        return paramSpec;
    }

    public static AlgorithmParameterSpec getParamSpec(String sigName, byte[] paramBytes) throws ProviderException {
        AlgorithmParameterSpec paramSpec = null;
        if (paramBytes != null) {
            if ((sigName = SignatureUtil.checkName(sigName)).contains("RSA")) {
                AlgorithmParameters params = SignatureUtil.createAlgorithmParameters(sigName, paramBytes);
                paramSpec = RSAUtil.getParamSpec((AlgorithmParameters)params);
            } else {
                if (sigName.contains("ECDSA")) {
                    return null;
                }
                throw new ProviderException("Unrecognized algorithm for signature parameters " + sigName);
            }
        }
        return paramSpec;
    }

    public static void initVerifyWithParam(Signature s, PublicKey key, AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException, InvalidKeyException {
        SharedSecretsUtil.secSignatureInitVerify((Signature)s, (PublicKey)key, (AlgorithmParameterSpec)params);
    }

    public static void initVerifyWithParam(Signature s, Certificate cert, AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException, InvalidKeyException {
        SharedSecretsUtil.secSignatureInitVerify((Signature)s, (Certificate)cert, (AlgorithmParameterSpec)params);
    }

    public static void initSignWithParam(Signature s, PrivateKey key, AlgorithmParameterSpec params, SecureRandom sr) throws InvalidAlgorithmParameterException, InvalidKeyException {
        SharedSecretsUtil.secSignatureInitSign((Signature)s, (PrivateKey)key, (AlgorithmParameterSpec)params, (SecureRandom)sr);
    }

    public static AlgorithmId getDigestAlgInPkcs7SignerInfo(Signature signer, String sigalg, PrivateKey privateKey, boolean directsign) throws NoSuchAlgorithmException {
        AlgorithmId digAlgID;
        if (sigalg.equals("RSASSA-PSS")) {
            try {
                digAlgID = AlgorithmId.get((String)signer.getParameters().getParameterSpec(PSSParameterSpec.class).getDigestAlgorithm());
            }
            catch (InvalidParameterSpecException e) {
                throw new AssertionError("Should not happen", e);
            }
        } else {
            digAlgID = AlgorithmId.get((String)SignatureUtil.extractDigestAlgFromDwithE(sigalg));
        }
        return digAlgID;
    }

    public static String extractDigestAlgFromDwithE(String signatureAlgorithm) {
        int with = (signatureAlgorithm = signatureAlgorithm.toUpperCase(Locale.ENGLISH)).indexOf("WITH");
        if (with > 0) {
            return signatureAlgorithm.substring(0, with);
        }
        throw new IllegalArgumentException("Unknown algorithm: " + signatureAlgorithm);
    }

    public static String extractKeyAlgFromDwithE(String signatureAlgorithm) {
        int and;
        signatureAlgorithm = signatureAlgorithm.toUpperCase(Locale.ENGLISH);
        int with = signatureAlgorithm.indexOf("WITH");
        String keyAlgorithm = null;
        if (with > 0 && (keyAlgorithm = (and = signatureAlgorithm.indexOf("AND", with + 4)) > 0 ? signatureAlgorithm.substring(with + 4, and) : signatureAlgorithm.substring(with + 4)).equalsIgnoreCase("ECDSA")) {
            keyAlgorithm = "EC";
        }
        return keyAlgorithm;
    }

    public static AlgorithmParameterSpec getDefaultParamSpec(String sigAlg, Key k) {
        if ((sigAlg = SignatureUtil.checkName(sigAlg)).equalsIgnoreCase("RSASSA-PSS")) {
            throw new IllegalArgumentException("RSASSA-PSS is not supported");
        }
        return null;
    }

    public static Signature fromKey(String sigAlg, PrivateKey key, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        Signature sigEngine = provider == null || provider.isEmpty() ? CryptoInsts.getSignature((String)sigAlg) : Signature.getInstance(sigAlg, provider);
        return SignatureUtil.autoInitInternal(sigAlg, key, sigEngine);
    }

    public static Signature fromKey(String sigAlg, PrivateKey key, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        Signature sigEngine = provider == null ? CryptoInsts.getSignature((String)sigAlg) : Signature.getInstance(sigAlg, provider);
        return SignatureUtil.autoInitInternal(sigAlg, key, sigEngine);
    }

    private static Signature autoInitInternal(String alg, PrivateKey key, Signature s) throws InvalidKeyException {
        AlgorithmParameterSpec params = SignatureUtil.getDefaultParamSpec(alg, key);
        try {
            SignatureUtil.initSignWithParam(s, key, params, null);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new AssertionError("Should not happen", e);
        }
        return s;
    }

    public static AlgorithmId fromSignature(Signature sigEngine, PrivateKey key) throws SignatureException {
        try {
            AlgorithmParameters params = null;
            try {
                params = sigEngine.getParameters();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            if (params != null) {
                return AlgorithmId.get((AlgorithmParameters)sigEngine.getParameters());
            }
            String sigAlg = sigEngine.getAlgorithm();
            if (sigAlg.equalsIgnoreCase("EdDSA")) {
                sigAlg = key.getAlgorithm();
            }
            return AlgorithmId.get((String)sigAlg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureException("Cannot derive AlgorithmIdentifier", e);
        }
    }

    public static void checkKeyAndSigAlgMatch(PrivateKey key, String sAlg) {
        String kAlg = key.getAlgorithm().toUpperCase(Locale.ENGLISH);
        switch (sAlg = SignatureUtil.checkName(sAlg)) {
            case "RSASSA-PSS": {
                if (kAlg.equals("RSASSA-PSS") || kAlg.equals("RSA")) break;
                throw new IllegalArgumentException("key algorithm not compatible with signature algorithm");
            }
            case "EDDSA": {
                if (kAlg.equals("EDDSA") || kAlg.equals("ED448") || kAlg.equals("ED25519")) break;
                throw new IllegalArgumentException("key algorithm not compatible with signature algorithm");
            }
            default: {
                if (!sAlg.contains("WITH") || !(sAlg.endsWith("WITHRSA") && !kAlg.equals("RSA") || sAlg.endsWith("WITHECDSA") && !kAlg.equals("EC")) && (!sAlg.endsWith("WITHDSA") || kAlg.equals("DSA"))) break;
                throw new IllegalArgumentException("key algorithm not compatible with signature algorithm");
            }
        }
    }

    public static String getDefaultSigAlgForKey(PrivateKey k) {
        String kAlg = k.getAlgorithm();
        switch (kAlg.toUpperCase(Locale.ENGLISH)) {
            case "DSA": 
            case "RSA": {
                return SignatureUtil.ifcFfcStrength(KeyUtil.getKeySize(k)) + "with" + kAlg;
            }
            case "EC": {
                return SignatureUtil.ecStrength(KeyUtil.getKeySize(k)) + "withECDSA";
            }
            case "RSASSA-PSS": 
            case "ED25519": 
            case "ED448": {
                return kAlg;
            }
        }
        return null;
    }

    private static String ecStrength(int bitLength) {
        if (bitLength >= 512) {
            return "SHA512";
        }
        if (bitLength >= 384) {
            return "SHA384";
        }
        return "SHA256";
    }

    private static String ifcFfcStrength(int bitLength) {
        if (bitLength > 7680) {
            return "SHA512";
        }
        if (bitLength > 3072) {
            return "SHA384";
        }
        return "SHA256";
    }
}

