/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.x509;

import com.tencent.kona.sun.security.util.DerInputStream;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.util.KnownOIDs;
import com.tencent.kona.sun.security.util.ObjectIdentifier;
import com.tencent.kona.sun.security.util.Oid;
import com.tencent.kona.sun.security.x509.GeneralName;
import java.io.IOException;

public final class AccessDescription {
    private int myhash = -1;
    private final ObjectIdentifier accessMethod;
    private final GeneralName accessLocation;
    public static final ObjectIdentifier Ad_OCSP_Id = Oid.of((KnownOIDs)KnownOIDs.OCSP);
    public static final ObjectIdentifier Ad_CAISSUERS_Id = Oid.of((KnownOIDs)KnownOIDs.caIssuers);
    public static final ObjectIdentifier Ad_TIMESTAMPING_Id = Oid.of((KnownOIDs)KnownOIDs.AD_TimeStamping);
    public static final ObjectIdentifier Ad_CAREPOSITORY_Id = Oid.of((KnownOIDs)KnownOIDs.caRepository);

    public AccessDescription(ObjectIdentifier accessMethod, GeneralName accessLocation) {
        this.accessMethod = accessMethod;
        this.accessLocation = accessLocation;
    }

    public AccessDescription(DerValue derValue) throws IOException {
        DerInputStream derIn = derValue.getData();
        this.accessMethod = derIn.getOID();
        this.accessLocation = new GeneralName(derIn.getDerValue());
    }

    public ObjectIdentifier getAccessMethod() {
        return this.accessMethod;
    }

    public GeneralName getAccessLocation() {
        return this.accessLocation;
    }

    public void encode(DerOutputStream out) {
        DerOutputStream tmp = new DerOutputStream();
        tmp.putOID(this.accessMethod);
        this.accessLocation.encode(tmp);
        out.write((byte)48, tmp);
    }

    public int hashCode() {
        if (this.myhash == -1) {
            this.myhash = this.accessMethod.hashCode() + this.accessLocation.hashCode();
        }
        return this.myhash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AccessDescription)) {
            return false;
        }
        AccessDescription that = (AccessDescription)obj;
        if (this == that) {
            return true;
        }
        return this.accessMethod.equals((Object)that.getAccessMethod()) && this.accessLocation.equals(that.getAccessLocation());
    }

    public String toString() {
        String method = this.accessMethod.equals((Object)Ad_CAISSUERS_Id) ? "caIssuers" : (this.accessMethod.equals((Object)Ad_CAREPOSITORY_Id) ? "caRepository" : (this.accessMethod.equals((Object)Ad_TIMESTAMPING_Id) ? "timeStamping" : (this.accessMethod.equals((Object)Ad_OCSP_Id) ? "ocsp" : this.accessMethod.toString())));
        return "\n   accessMethod: " + method + "\n   accessLocation: " + this.accessLocation.toString() + "\n";
    }
}

