/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.x509;

import com.tencent.kona.sun.security.util.DerEncoder;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.x509.CertificatePolicyId;
import java.io.IOException;
import java.util.Objects;

public class CertificatePolicyMap
implements DerEncoder {
    private final CertificatePolicyId issuerDomain;
    private final CertificatePolicyId subjectDomain;

    public CertificatePolicyMap(CertificatePolicyId issuer, CertificatePolicyId subject) {
        this.issuerDomain = Objects.requireNonNull(issuer);
        this.subjectDomain = Objects.requireNonNull(subject);
    }

    public CertificatePolicyMap(DerValue val) throws IOException {
        if (val.tag != 48) {
            throw new IOException("Invalid encoding for CertificatePolicyMap");
        }
        this.issuerDomain = new CertificatePolicyId(val.data.getDerValue());
        this.subjectDomain = new CertificatePolicyId(val.data.getDerValue());
    }

    public CertificatePolicyId getIssuerIdentifier() {
        return this.issuerDomain;
    }

    public CertificatePolicyId getSubjectIdentifier() {
        return this.subjectDomain;
    }

    public String toString() {
        return "CertificatePolicyMap: [\nIssuerDomain:" + this.issuerDomain.toString() + "SubjectDomain:" + this.subjectDomain.toString() + "]\n";
    }

    public void encode(DerOutputStream out) {
        DerOutputStream tmp = new DerOutputStream();
        this.issuerDomain.encode(tmp);
        this.subjectDomain.encode(tmp);
        out.write((byte)48, tmp);
    }
}

