/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.x509;

import com.tencent.kona.sun.security.util.DerEncoder;
import com.tencent.kona.sun.security.util.DerInputStream;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.x509.CertificatePolicyId;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class CertificatePolicySet
implements DerEncoder {
    private final Vector<CertificatePolicyId> ids;

    public CertificatePolicySet(Vector<CertificatePolicyId> ids) {
        this.ids = ids;
    }

    public CertificatePolicySet(DerInputStream in) throws IOException {
        this.ids = new Vector();
        DerValue[] seq = in.getSequence(5);
        for (int i = 0; i < seq.length; ++i) {
            CertificatePolicyId id = new CertificatePolicyId(seq[i]);
            this.ids.addElement(id);
        }
    }

    public String toString() {
        return "CertificatePolicySet:[\n" + this.ids.toString() + "]\n";
    }

    public void encode(DerOutputStream out) {
        DerOutputStream tmp = new DerOutputStream();
        for (int i = 0; i < this.ids.size(); ++i) {
            this.ids.elementAt(i).encode(tmp);
        }
        out.write((byte)48, tmp);
    }

    public List<CertificatePolicyId> getCertPolicyIds() {
        return Collections.unmodifiableList(this.ids);
    }
}

