/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.x509;

import com.tencent.kona.sun.security.util.DerInputStream;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.x509.GeneralNameInterface;
import java.io.IOException;
import java.util.Objects;

public class EDIPartyName
implements GeneralNameInterface {
    private static final byte TAG_ASSIGNER = 0;
    private static final byte TAG_PARTYNAME = 1;
    private String assigner = null;
    private String party = null;
    private int myhash = -1;

    public EDIPartyName(String assignerName, String partyName) {
        this.assigner = assignerName;
        this.party = Objects.requireNonNull(partyName);
    }

    public EDIPartyName(String partyName) {
        this(null, partyName);
    }

    public EDIPartyName(DerValue derValue) throws IOException {
        DerInputStream in = new DerInputStream(derValue.toByteArray());
        DerValue[] seq = in.getSequence(2);
        int len = seq.length;
        if (len < 1 || len > 2) {
            throw new IOException("Invalid encoding of EDIPartyName");
        }
        for (int i = 0; i < len; ++i) {
            DerValue opt = seq[i];
            if (opt.isContextSpecific((byte)0) && !opt.isConstructed()) {
                if (this.assigner != null) {
                    throw new IOException("Duplicate nameAssigner found in EDIPartyName");
                }
                opt = opt.data.getDerValue();
                this.assigner = opt.getAsString();
            }
            if (!opt.isContextSpecific((byte)1) || opt.isConstructed()) continue;
            if (this.party != null) {
                throw new IOException("Duplicate partyName found in EDIPartyName");
            }
            opt = opt.data.getDerValue();
            this.party = opt.getAsString();
        }
        if (this.party == null) {
            throw new IOException("party cannot be missing");
        }
    }

    @Override
    public int getType() {
        return 5;
    }

    public void encode(DerOutputStream out) {
        DerOutputStream tagged = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        if (this.assigner != null) {
            DerOutputStream tmp2 = new DerOutputStream();
            tmp2.putPrintableString(this.assigner);
            tagged.write(DerValue.createTag((byte)-128, (boolean)false, (byte)0), tmp2);
        }
        tmp.putPrintableString(this.party);
        tagged.write(DerValue.createTag((byte)-128, (boolean)false, (byte)1), tmp);
        out.write((byte)48, tagged);
    }

    public String getAssignerName() {
        return this.assigner;
    }

    public String getPartyName() {
        return this.party;
    }

    public boolean equals(Object other) {
        if (!(other instanceof EDIPartyName)) {
            return false;
        }
        String otherAssigner = ((EDIPartyName)other).assigner;
        if (this.assigner == null ? otherAssigner != null : !this.assigner.equals(otherAssigner)) {
            return false;
        }
        String otherParty = ((EDIPartyName)other).party;
        if (this.party == null) {
            return otherParty == null;
        }
        return this.party.equals(otherParty);
    }

    public int hashCode() {
        if (this.myhash == -1) {
            this.myhash = 37 + (this.party == null ? 1 : this.party.hashCode());
            if (this.assigner != null) {
                this.myhash = 37 * this.myhash + this.assigner.hashCode();
            }
        }
        return this.myhash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EDIPartyName: ");
        if (this.assigner != null) {
            sb.append("  nameAssigner = ").append(this.assigner).append(',');
        }
        sb.append("  partyName = ").append(this.party);
        return sb.toString();
    }

    @Override
    public int constrains(GeneralNameInterface inputName) throws UnsupportedOperationException {
        int constraintType;
        if (inputName == null) {
            constraintType = -1;
        } else if (inputName.getType() != 5) {
            constraintType = -1;
        } else {
            throw new UnsupportedOperationException("Narrowing, widening, and matching of names not supported for EDIPartyName");
        }
        return constraintType;
    }

    @Override
    public int subtreeDepth() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("subtreeDepth() not supported for EDIPartyName");
    }
}

