/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.x509;

import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.util.KnownOIDs;
import com.tencent.kona.sun.security.util.ObjectIdentifier;
import com.tencent.kona.sun.security.util.Oid;
import com.tencent.kona.sun.security.x509.Extension;
import com.tencent.kona.sun.security.x509.PKIXExtensions;
import java.io.IOException;

public class InhibitAnyPolicyExtension
extends Extension {
    public static ObjectIdentifier AnyPolicy_Id = Oid.of((KnownOIDs)KnownOIDs.CE_CERT_POLICIES_ANY);
    public static final String NAME = "InhibitAnyPolicy";
    private int skipCerts = Integer.MAX_VALUE;

    private void encodeThis() {
        DerOutputStream out = new DerOutputStream();
        out.putInteger(this.skipCerts);
        this.extensionValue = out.toByteArray();
    }

    public InhibitAnyPolicyExtension(int skipCerts) {
        if (skipCerts < -1) {
            throw new IllegalArgumentException("Invalid value for skipCerts");
        }
        this.skipCerts = skipCerts == -1 ? Integer.MAX_VALUE : skipCerts;
        this.extensionId = PKIXExtensions.InhibitAnyPolicy_Id;
        this.critical = true;
        this.encodeThis();
    }

    public InhibitAnyPolicyExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.InhibitAnyPolicy_Id;
        if (!critical.booleanValue()) {
            throw new IOException("Criticality cannot be false for InhibitAnyPolicy");
        }
        this.critical = true;
        this.extensionValue = (byte[])value;
        DerValue val = new DerValue(this.extensionValue);
        if (val.tag != 2) {
            throw new IOException("Invalid encoding of InhibitAnyPolicy: data not integer");
        }
        if (val.data == null) {
            throw new IOException("Invalid encoding of InhibitAnyPolicy: null data");
        }
        int skipCertsValue = val.getInteger();
        if (skipCertsValue < -1) {
            throw new IOException("Invalid value for skipCerts");
        }
        this.skipCerts = skipCertsValue == -1 ? Integer.MAX_VALUE : skipCertsValue;
    }

    @Override
    public String toString() {
        return super.toString() + "InhibitAnyPolicy: " + this.skipCerts + "\n";
    }

    @Override
    public void encode(DerOutputStream out) {
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.InhibitAnyPolicy_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(out);
    }

    public int getSkipCerts() {
        return this.skipCerts;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

