/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.x509;

import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.x509.Extension;
import com.tencent.kona.sun.security.x509.PKIXExtensions;
import java.io.IOException;
import java.util.Date;

public class InvalidityDateExtension
extends Extension {
    public static final String NAME = "InvalidityDate";
    private Date date;

    private void encodeThis() {
        if (this.date == null) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream dos = new DerOutputStream();
        dos.putGeneralizedTime(this.date);
        this.extensionValue = dos.toByteArray();
    }

    public InvalidityDateExtension(Date date) {
        this(false, date);
    }

    public InvalidityDateExtension(boolean critical, Date date) {
        if (date == null) {
            throw new IllegalArgumentException("date cannot be null");
        }
        this.extensionId = PKIXExtensions.InvalidityDate_Id;
        this.critical = critical;
        this.date = date;
        this.encodeThis();
    }

    public InvalidityDateExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.InvalidityDate_Id;
        this.critical = critical;
        this.extensionValue = (byte[])value;
        DerValue val = new DerValue(this.extensionValue);
        this.date = val.getGeneralizedTime();
    }

    public Date getDate() throws IOException {
        if (this.date == null) {
            return null;
        }
        return new Date(this.date.getTime());
    }

    @Override
    public String toString() {
        return super.toString() + "    Invalidity Date: " + this.date;
    }

    @Override
    public void encode(DerOutputStream out) {
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.InvalidityDate_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(out);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static InvalidityDateExtension toImpl(java.security.cert.Extension ext) throws IOException {
        if (ext instanceof InvalidityDateExtension) {
            return (InvalidityDateExtension)ext;
        }
        return new InvalidityDateExtension((Boolean)ext.isCritical(), ext.getValue());
    }
}

