/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.x509;

import com.tencent.kona.sun.security.util.DerInputStream;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.x509.DistributionPointName;
import com.tencent.kona.sun.security.x509.Extension;
import com.tencent.kona.sun.security.x509.PKIXExtensions;
import com.tencent.kona.sun.security.x509.ReasonFlags;
import java.io.IOException;

public class IssuingDistributionPointExtension
extends Extension {
    public static final String NAME = "IssuingDistributionPoint";
    private DistributionPointName distributionPoint = null;
    private ReasonFlags revocationReasons = null;
    private boolean hasOnlyUserCerts = false;
    private boolean hasOnlyCACerts = false;
    private boolean hasOnlyAttributeCerts = false;
    private boolean isIndirectCRL = false;
    private static final byte TAG_DISTRIBUTION_POINT = 0;
    private static final byte TAG_ONLY_USER_CERTS = 1;
    private static final byte TAG_ONLY_CA_CERTS = 2;
    private static final byte TAG_ONLY_SOME_REASONS = 3;
    private static final byte TAG_INDIRECT_CRL = 4;
    private static final byte TAG_ONLY_ATTRIBUTE_CERTS = 5;

    public IssuingDistributionPointExtension(DistributionPointName distributionPoint, ReasonFlags revocationReasons, boolean hasOnlyUserCerts, boolean hasOnlyCACerts, boolean hasOnlyAttributeCerts, boolean isIndirectCRL) {
        if (!(distributionPoint != null || revocationReasons != null || hasOnlyUserCerts || hasOnlyCACerts || hasOnlyAttributeCerts || isIndirectCRL)) {
            throw new IllegalArgumentException("elements cannot be empty");
        }
        if (hasOnlyUserCerts && (hasOnlyCACerts || hasOnlyAttributeCerts) || hasOnlyCACerts && (hasOnlyUserCerts || hasOnlyAttributeCerts) || hasOnlyAttributeCerts && (hasOnlyUserCerts || hasOnlyCACerts)) {
            throw new IllegalArgumentException("Only one of hasOnlyUserCerts, hasOnlyCACerts, hasOnlyAttributeCerts may be set to true");
        }
        this.extensionId = PKIXExtensions.IssuingDistributionPoint_Id;
        this.critical = true;
        this.distributionPoint = distributionPoint;
        this.revocationReasons = revocationReasons;
        this.hasOnlyUserCerts = hasOnlyUserCerts;
        this.hasOnlyCACerts = hasOnlyCACerts;
        this.hasOnlyAttributeCerts = hasOnlyAttributeCerts;
        this.isIndirectCRL = isIndirectCRL;
        this.encodeThis();
    }

    public IssuingDistributionPointExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.IssuingDistributionPoint_Id;
        this.critical = critical;
        if (!(value instanceof byte[])) {
            throw new IOException("Illegal argument type");
        }
        this.extensionValue = (byte[])value;
        DerValue val = new DerValue(this.extensionValue);
        if (val.tag != 48) {
            throw new IOException("Invalid encoding for IssuingDistributionPointExtension.");
        }
        if (val.data == null || val.data.available() == 0) {
            return;
        }
        DerInputStream in = val.data;
        while (in.available() != 0) {
            DerValue opt = in.getDerValue();
            if (opt.isContextSpecific((byte)0) && opt.isConstructed()) {
                this.distributionPoint = new DistributionPointName(opt.data.getDerValue());
                continue;
            }
            if (opt.isContextSpecific((byte)1) && !opt.isConstructed()) {
                opt.resetTag((byte)1);
                this.hasOnlyUserCerts = opt.getBoolean();
                continue;
            }
            if (opt.isContextSpecific((byte)2) && !opt.isConstructed()) {
                opt.resetTag((byte)1);
                this.hasOnlyCACerts = opt.getBoolean();
                continue;
            }
            if (opt.isContextSpecific((byte)3) && !opt.isConstructed()) {
                this.revocationReasons = new ReasonFlags(opt);
                continue;
            }
            if (opt.isContextSpecific((byte)4) && !opt.isConstructed()) {
                opt.resetTag((byte)1);
                this.isIndirectCRL = opt.getBoolean();
                continue;
            }
            if (opt.isContextSpecific((byte)5) && !opt.isConstructed()) {
                opt.resetTag((byte)1);
                this.hasOnlyAttributeCerts = opt.getBoolean();
                continue;
            }
            throw new IOException("Invalid encoding of IssuingDistributionPoint");
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void encode(DerOutputStream out) {
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.IssuingDistributionPoint_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(out);
    }

    public void setRevocationReasons(ReasonFlags val) throws IOException {
        this.revocationReasons = val;
        this.encodeThis();
    }

    public DistributionPointName getDistributionPoint() {
        return this.distributionPoint;
    }

    public ReasonFlags getRevocationReasons() {
        return this.revocationReasons;
    }

    public boolean hasOnlyUserCerts() {
        return this.hasOnlyUserCerts;
    }

    public boolean hasOnlyCACerts() {
        return this.hasOnlyCACerts;
    }

    public boolean hasOnlyAttributeCerts() {
        return this.hasOnlyAttributeCerts;
    }

    public boolean isIndirectCRL() {
        return this.isIndirectCRL;
    }

    private void encodeThis() {
        DerOutputStream tmp;
        if (!(this.distributionPoint != null || this.revocationReasons != null || this.hasOnlyUserCerts || this.hasOnlyCACerts || this.hasOnlyAttributeCerts || this.isIndirectCRL)) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream tagged = new DerOutputStream();
        if (this.distributionPoint != null) {
            tmp = new DerOutputStream();
            this.distributionPoint.encode(tmp);
            tagged.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), tmp);
        }
        if (this.hasOnlyUserCerts) {
            tmp = new DerOutputStream();
            tmp.putBoolean(this.hasOnlyUserCerts);
            tagged.writeImplicit(DerValue.createTag((byte)-128, (boolean)false, (byte)1), tmp);
        }
        if (this.hasOnlyCACerts) {
            tmp = new DerOutputStream();
            tmp.putBoolean(this.hasOnlyCACerts);
            tagged.writeImplicit(DerValue.createTag((byte)-128, (boolean)false, (byte)2), tmp);
        }
        if (this.revocationReasons != null) {
            tmp = new DerOutputStream();
            this.revocationReasons.encode(tmp);
            tagged.writeImplicit(DerValue.createTag((byte)-128, (boolean)false, (byte)3), tmp);
        }
        if (this.isIndirectCRL) {
            tmp = new DerOutputStream();
            tmp.putBoolean(this.isIndirectCRL);
            tagged.writeImplicit(DerValue.createTag((byte)-128, (boolean)false, (byte)4), tmp);
        }
        if (this.hasOnlyAttributeCerts) {
            tmp = new DerOutputStream();
            tmp.putBoolean(this.hasOnlyAttributeCerts);
            tagged.writeImplicit(DerValue.createTag((byte)-128, (boolean)false, (byte)5), tmp);
        }
        DerOutputStream seq = new DerOutputStream();
        seq.write((byte)48, tagged);
        this.extensionValue = seq.toByteArray();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append("IssuingDistributionPoint [\n  ");
        if (this.distributionPoint != null) {
            sb.append(this.distributionPoint);
        }
        if (this.revocationReasons != null) {
            sb.append(this.revocationReasons);
        }
        sb.append("  Only contains user certs: ").append(this.hasOnlyUserCerts).append('\n').append("  Only contains CA certs: ").append(this.hasOnlyCACerts).append('\n').append("  Only contains attribute certs: ").append(this.hasOnlyAttributeCerts).append('\n').append("  Indirect CRL: ").append(this.isIndirectCRL).append("\n]\n");
        return sb.toString();
    }
}

