/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona;

import java.security.AccessController;
import java.util.Locale;
import java.util.regex.Pattern;

public class KonaUtils {
    private static final String OS = KonaUtils.privilegedGetProperty("os.name");
    private static final String ARCH = KonaUtils.privilegedGetProperty("os.arch");
    private static final String JDK_VERSION = KonaUtils.privilegedGetProperty("java.specification.version");
    private static final String JDK_VENDOR = KonaUtils.privilegedGetProperty("java.specification.vendor");
    private static final String DEFAULT_CRYPTO = KonaUtils.privilegedGetProperty("com.tencent.kona.defaultCrypto", "Java");

    public static String privilegedGetProperty(String key, String def) {
        return AccessController.doPrivileged(() -> System.getProperty(key, def));
    }

    public static String privilegedGetProperty(String key) {
        return KonaUtils.privilegedGetProperty(key, null);
    }

    public static Boolean privilegedGetBoolProperty(String key, String def) {
        return AccessController.doPrivileged(() -> Boolean.parseBoolean(System.getProperty(key, def)));
    }

    public static Boolean privilegedGetBoolProperty(String key) {
        return KonaUtils.privilegedGetBoolProperty(key, "false");
    }

    public static boolean isJdk8() {
        return JDK_VERSION.equals("1.8");
    }

    public static boolean isJdk11() {
        return JDK_VERSION.equals("11");
    }

    public static boolean isJdk17() {
        return JDK_VERSION.equals("17");
    }

    public static boolean isJdk21() {
        return JDK_VERSION.equals("21");
    }

    public static boolean isAndroid() {
        return JDK_VENDOR.contains("Android");
    }

    public static String defaultCrypto() {
        return KonaUtils.isLinux() && !KonaUtils.isAndroid() ? DEFAULT_CRYPTO : "Java";
    }

    public static boolean isLinux() {
        return KonaUtils.isOs("linux");
    }

    public static boolean isMac() {
        return KonaUtils.isOs("mac");
    }

    private static boolean isOs(String osname) {
        return OS.toLowerCase(Locale.ENGLISH).startsWith(osname.toLowerCase(Locale.ENGLISH));
    }

    public static boolean isX64() {
        return KonaUtils.isArch("(amd64)|(x86_64)");
    }

    public static boolean isArm64() {
        return KonaUtils.isArch("aarch64");
    }

    private static boolean isArch(String arch) {
        return Pattern.compile(arch, 2).matcher(ARCH).matches();
    }
}

