/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio.route;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Handler;
import android.os.HandlerThread;
import com.tencent.liteav.audio.route.a;
import com.tencent.liteav.audio.route.b;
import com.tencent.liteav.audio.route.c;
import com.tencent.liteav.audio.route.d;
import com.tencent.liteav.audio.route.e;
import com.tencent.liteav.audio.route.f;
import com.tencent.liteav.audio.route.g;
import com.tencent.liteav.audio.route.h;
import com.tencent.liteav.audio.route.i;
import com.tencent.liteav.audio.route.j;
import com.tencent.liteav.audio.route.k;
import com.tencent.liteav.audio.route.l;
import com.tencent.liteav.audio.route.m;
import com.tencent.liteav.audio.route.n;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;

@JNINamespace(value="liteav::audio")
public class AudioRouteManager
extends n.a {
    private static final String TAG = "AudioRouteManager";
    private static final long IN_CALL_DETECTION_TIME = 500L;
    private static final int BLUETOOTH_SCO_RECONNECT_INTERVAL = 1000;
    private final l mAudioRouteSupervisor;
    private final long mNativeAudioRouteManager;
    private final AudioManager mAudioManager;
    private final n mBroadcastReceiver;
    private com.tencent.liteav.base.util.b mHandler = null;
    private boolean mIsServiceStarted = false;
    private a mCurrentAudioIOScene = a.a;
    private a mExpectedAudioIOScene = a.a;
    private b.a mCurrentRouteType = b.a.a;
    private m.a mSwitcher = null;
    private String mCurrentRouteConfig = "";
    private m.a.a mSwitcherListener = new m.a.a(){

        @Override
        public final void a(b.a a2) {
            AudioRouteManager.nativeNotifyAudioRouteChangedFromJava(AudioRouteManager.this.mNativeAudioRouteManager, a2.ordinal());
        }

        @Override
        public final void b(b.a a2) {
            if (a2 == b.a.e) {
                Log.w(AudioRouteManager.TAG, "switch to bluetooth failed, set it unavailable and update route again", new Object[0]);
                AudioRouteManager.this.mAudioRouteSupervisor.a(b.a.e, false);
                AudioRouteManager.this.autoCheckRouteUpdate(false);
                return;
            }
            Log.w(AudioRouteManager.TAG, "switch to %s failed, do nothing", new Object[]{a2});
        }
    };

    @CalledByNative
    public AudioRouteManager(long nativeAudioRouteManager) {
        this.mNativeAudioRouteManager = nativeAudioRouteManager;
        Context context = ContextUtils.getApplicationContext();
        this.mAudioRouteSupervisor = new l();
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.mBroadcastReceiver = new n(context, this);
    }

    @CalledByNative
    public void initialize() {
        HandlerThread handlerThread = new HandlerThread("AudioRouteManagerLooper");
        handlerThread.start();
        this.mHandler = new com.tencent.liteav.base.util.b(handlerThread.getLooper());
    }

    @CalledByNative
    public void start(String configString) {
        AudioRouteManager audioRouteManager = this;
        audioRouteManager.runOnWorkThread(c.a(audioRouteManager, configString));
    }

    @CalledByNative
    public void stop() {
        AudioRouteManager audioRouteManager = this;
        audioRouteManager.runOnWorkThread(f.a(audioRouteManager));
    }

    @CalledByNative
    public void notifyAudioIOSceneChanged(int newScene, long timeout) {
        AudioRouteManager audioRouteManager = this;
        audioRouteManager.runOnWorkThreadAndWaitDone(g.a(audioRouteManager, newScene), timeout);
    }

    @CalledByNative
    public void setHandFreeModeEnabled(boolean enable) {
        AudioRouteManager audioRouteManager = this;
        audioRouteManager.runOnWorkThread(h.a(audioRouteManager, enable));
    }

    @CalledByNative
    public void uninitialize() {
        com.tencent.liteav.base.util.b b2 = this.mHandler;
        this.mHandler = null;
        if (b2 != null) {
            com.tencent.liteav.base.util.b b3 = b2;
            b3.a();
            try {
                b3.getLooper().getThread().join();
                return;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void onWiredHeadsetConnectionChanged(boolean connected) {
        AudioRouteManager audioRouteManager = this;
        audioRouteManager.runOnWorkThread(i.a(audioRouteManager, connected));
    }

    @Override
    public void onBluetoothConnectionChanged(boolean connected) {
        AudioRouteManager audioRouteManager = this;
        audioRouteManager.runOnWorkThread(j.a(audioRouteManager, connected));
    }

    @Override
    public void onBluetoothSCOConnected(boolean connected) {
        AudioRouteManager audioRouteManager = this;
        audioRouteManager.runOnWorkThread(k.a(audioRouteManager, connected));
    }

    private void startInternal(String configString) {
        boolean bl;
        Object object;
        String string;
        block17: {
            if (this.mIsServiceStarted) {
                if (this.mCurrentRouteConfig.equals(configString)) {
                    return;
                }
                Log.w(TAG, "AudioRouteManager's been started, stop it first", new Object[0]);
                this.stopInternal();
            }
            string = configString;
            object = this.mAudioRouteSupervisor;
            if (object.c) {
                Log.w("AudioRouteSupervisor", "error in initialize(), it's already intialized", new Object[0]);
                bl = false;
            } else {
                Log.i("AudioRouteSupervisor", "initialize from string: ".concat(String.valueOf(string)), new Object[0]);
                if (string == null || string.length() <= 0) {
                    bl = false;
                } else if ((string = string.replace("[\n\r]", "")).length() <= 0) {
                    bl = false;
                } else {
                    String[] stringArray = string.split(";");
                    if (stringArray.length <= 0) {
                        bl = false;
                    } else {
                        for (int i2 = 0; i2 < stringArray.length; ++i2) {
                            boolean bl2;
                            int n2 = i2;
                            b.a a2 = b.a.a(stringArray[i2]);
                            Object object2 = object;
                            if (a2 == b.a.a) {
                                Log.e("AudioRouteSupervisor", "error, unknown route name: ".concat(String.valueOf((Object)a2)), new Object[0]);
                                bl2 = false;
                            } else if (object2.b.containsKey((Object)a2)) {
                                Log.e("AudioRouteSupervisor", "error, existed route name: ".concat(String.valueOf((Object)a2)), new Object[0]);
                                bl2 = false;
                            } else {
                                boolean bl3 = a2 == b.a.b || a2 == b.a.c;
                                b b2 = new b(a2, n2, bl3);
                                object2.b.put(a2, b2);
                                Log.i("AudioRouteSupervisor", "add audio route, name: %s", new Object[]{a2});
                                bl2 = true;
                            }
                            if (bl2) continue;
                            bl = false;
                            break block17;
                        }
                        object.c = true;
                        bl = true;
                    }
                }
            }
        }
        if (!bl) {
            Log.e(TAG, "AudioRouteManager start failed", new Object[0]);
            return;
        }
        object = this.mBroadcastReceiver;
        if (((n)((Object)object)).b == null) {
            ((n)((Object)object)).b = new n.b(((n)((Object)object)).a);
        }
        string = new IntentFilter();
        string.addAction("android.intent.action.HEADSET_PLUG");
        string.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        string.addAction("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
        string.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        ((n)((Object)object)).a.registerReceiver((BroadcastReceiver)object, (IntentFilter)string);
        this.updateAudioRouteStatus();
        this.mCurrentRouteConfig = configString;
        this.mIsServiceStarted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopInternal() {
        Log.i(TAG, "stopInternal", new Object[0]);
        if (!this.mIsServiceStarted) {
            Log.e(TAG, "AudioRouteManager is not started", new Object[0]);
            return;
        }
        this.destroySwitcher();
        try {
            this.mAudioManager.setMode(0);
        }
        catch (Exception exception) {
            Log.w(TAG, "AudioManager setMode failed, ignore it", new Object[0]);
        }
        this.mCurrentRouteType = b.a.a;
        this.mCurrentAudioIOScene = a.a;
        this.mExpectedAudioIOScene = a.a;
        Object object = this.mBroadcastReceiver;
        if (object.a != null) {
            try {
                object.a.unregisterReceiver((BroadcastReceiver)object);
            }
            catch (Exception exception) {}
            if (object.b != null) {
                n.b b2 = object.b;
                Object object2 = b2.c;
                synchronized (object2) {
                    if (b2.a != null && b2.b != null) {
                        b2.b();
                        b2.b = null;
                    }
                }
                object.b = null;
            }
        }
        object = this.mAudioRouteSupervisor;
        if (!((l)object).c) {
            Log.w("AudioRouteSupervisor", "error in uninitialize(), it's not been initialized yet", new Object[0]);
        } else {
            ((l)object).b.clear();
            ((l)object).c = false;
        }
        this.mCurrentRouteConfig = "";
        this.mIsServiceStarted = false;
    }

    private void notifyAudioIOSceneChangedInternal() {
        Log.i(TAG, "notify audio io scene changed, %s -> %s", new Object[]{this.mCurrentAudioIOScene, this.mExpectedAudioIOScene});
        if (this.mCurrentAudioIOScene == this.mExpectedAudioIOScene) {
            return;
        }
        if (this.mAudioManager.getMode() == 2) {
            AudioRouteManager audioRouteManager = this;
            audioRouteManager.runOnWorkThread(d.a(audioRouteManager), 500L);
            return;
        }
        int n2 = a.a(this.mExpectedAudioIOScene);
        Log.i(TAG, "setMode to ".concat(String.valueOf(n2)), new Object[0]);
        try {
            this.mAudioManager.setMode(n2);
        }
        catch (Exception exception) {
            Log.w(TAG, "AudioManager setMode failed, ignore it", new Object[0]);
        }
        this.mCurrentAudioIOScene = this.mExpectedAudioIOScene;
        if (this.mSwitcher != null) {
            this.mSwitcher.a(this.mExpectedAudioIOScene);
            return;
        }
        this.autoCheckRouteUpdate(false);
    }

    private void setHandFreeModeEnabledInternal(boolean enable) {
        boolean bl;
        if (!this.mIsServiceStarted) {
            Log.w(TAG, "set handfree mode failed, AudioRouteManager is not started", new Object[0]);
            return;
        }
        l l2 = this.mAudioRouteSupervisor;
        if (!l2.c) {
            Log.e("AudioRouteSupervisor", "error in setHandFreeModeEnabled(), it's not been initialized yet", new Object[0]);
            bl = false;
        } else {
            b b2 = l2.b.get((Object)b.a.c);
            b b3 = l2.b.get((Object)b.a.b);
            if (b2 == null || b3 == null) {
                Log.e("AudioRouteSupervisor", "setHandFreeModeEnabled failed, speakerphone or earphone not existed", new Object[0]);
                bl = false;
            } else {
                int n2 = Math.min(b2.c, b3.c);
                int n3 = Math.max(b2.c, b3.c);
                b2.c = enable ? n3 : n2;
                b3.c = enable ? n2 : n3;
                bl = true;
            }
        }
        if (bl) {
            this.autoCheckRouteUpdate(false);
        }
    }

    private void handleWiredHeadsetChangedInternal(boolean connected) {
        if (!this.mIsServiceStarted) {
            Log.i(TAG, "ignore wired headset changing, AudioRouteManager is not started", new Object[0]);
            return;
        }
        if (this.mAudioRouteSupervisor.a(b.a.d, connected)) {
            this.autoCheckRouteUpdate(false);
        }
    }

    private void handleBluetoothHeadsetChangedInternal(boolean connected) {
        if (!this.mIsServiceStarted) {
            Log.i(TAG, "ignore bluetooth headset changing, AudioRouteManager is not started", new Object[0]);
            return;
        }
        if (this.mAudioRouteSupervisor.a(b.a.e, connected)) {
            this.autoCheckRouteUpdate(false);
        }
    }

    private void handleBluetoothSCOChangedInternal(boolean connected) {
        if (this.mSwitcher != null) {
            this.mSwitcher.a(connected);
        }
        if (!connected && this.mIsServiceStarted && this.mCurrentAudioIOScene != a.a) {
            AudioRouteManager audioRouteManager = this;
            audioRouteManager.runOnWorkThread(e.a(audioRouteManager), 1000L);
        }
    }

    private void updateAudioRouteStatus() {
        if (this.mBroadcastReceiver == null) {
            this.mAudioRouteSupervisor.a(b.a.e, false);
        } else {
            n n2 = this.mBroadcastReceiver;
            this.mAudioRouteSupervisor.a(b.a.e, n2.b == null ? false : n2.b.a());
        }
        this.mAudioRouteSupervisor.a(b.a.d, this.mAudioManager.isWiredHeadsetOn());
        this.mAudioRouteSupervisor.a(b.a.c, true);
        this.mAudioRouteSupervisor.a(b.a.b, true);
        this.autoCheckRouteUpdate(false);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void autoCheckRouteUpdate(boolean force) {
        block11: {
            if (this.mCurrentAudioIOScene == a.a) {
                this.destroySwitcher();
                return;
            }
            var3_2 = this.mAudioRouteSupervisor;
            if (var3_2.c) break block11;
            Log.e("AudioRouteSupervisor", "err in getHighestPriorityRoute(), it's not been initialized yet", new Object[0]);
            ** GOTO lbl-1000
        }
        var4_3 = null;
        var5_4 /* !! */  = var3_2.b.entrySet().iterator();
        while (var5_4 /* !! */ .hasNext()) {
            var7_5 = var5_4 /* !! */ .next().getValue();
            if (var7_5 == null || !var7_5.b || var4_3 != null && var7_5.c < var4_3.c) continue;
            var4_3 = var7_5;
        }
        if (var4_3 != null) {
            v0 = var4_3.a;
        } else lbl-1000:
        // 2 sources

        {
            v0 = var2_6 = l.a;
        }
        if (this.mCurrentRouteType != var2_6 || force) {
            this.mCurrentRouteType = var2_6;
            this.destroySwitcher();
            var6_7 = this.mCurrentAudioIOScene;
            var5_4 /* !! */  = this.mHandler;
            var4_3 = this.mAudioManager;
            var3_2 = var2_6;
            switch (m.1.a[var3_2.ordinal()]) {
                case 1: {
                    v1 /* !! */  = new m.c((AudioManager)var4_3, (Handler)var5_4 /* !! */ , var6_7);
                    break;
                }
                case 2: {
                    v1 /* !! */  = new m.d((AudioManager)var4_3, (Handler)var5_4 /* !! */ , var6_7);
                    break;
                }
                case 3: {
                    v1 /* !! */  = new m.e((AudioManager)var4_3, (Handler)var5_4 /* !! */ , var6_7);
                    break;
                }
                case 4: {
                    v1 /* !! */  = new m.b((AudioManager)var4_3, (Handler)var5_4 /* !! */ , var6_7);
                    break;
                }
                default: {
                    v1 /* !! */  = null;
                }
            }
            this.mSwitcher = v1 /* !! */ ;
            this.mSwitcher.a(this.mSwitcherListener);
            this.mSwitcher.a();
        }
    }

    private void destroySwitcher() {
        if (this.mSwitcher == null) {
            return;
        }
        this.mSwitcher.b();
        this.mSwitcher = null;
    }

    private void runOnWorkThread(Runnable runnable) {
        com.tencent.liteav.base.util.b b2 = this.mHandler;
        if (b2 != null) {
            b2.post(runnable);
        }
    }

    private void runOnWorkThreadAndWaitDone(Runnable runnable, long timeout) {
        com.tencent.liteav.base.util.b b2 = this.mHandler;
        if (b2 != null) {
            b2.a(runnable, timeout);
        }
    }

    private void runOnWorkThread(Runnable runnable, long delay) {
        com.tencent.liteav.base.util.b b2 = this.mHandler;
        if (b2 != null) {
            b2.postDelayed(runnable, delay);
        }
    }

    private static native void nativeNotifyAudioRouteChangedFromJava(long var0, int var2);

    static /* synthetic */ void lambda$handleBluetoothSCOChangedInternal$6(AudioRouteManager this_) {
        this_.autoCheckRouteUpdate(true);
    }

    static /* synthetic */ void lambda$onBluetoothSCOConnected$5(AudioRouteManager this_, boolean connected) {
        this_.handleBluetoothSCOChangedInternal(connected);
    }

    static /* synthetic */ void lambda$onBluetoothConnectionChanged$4(AudioRouteManager this_, boolean connected) {
        this_.handleBluetoothHeadsetChangedInternal(connected);
    }

    static /* synthetic */ void lambda$onWiredHeadsetConnectionChanged$3(AudioRouteManager this_, boolean connected) {
        this_.handleWiredHeadsetChangedInternal(connected);
    }

    static /* synthetic */ void lambda$setHandFreeModeEnabled$2(AudioRouteManager this_, boolean enable) {
        this_.setHandFreeModeEnabledInternal(enable);
    }

    static /* synthetic */ void lambda$notifyAudioIOSceneChanged$1(AudioRouteManager this_, int newScene) {
        this_.mExpectedAudioIOScene = a.a(newScene);
        this_.notifyAudioIOSceneChangedInternal();
    }

    static /* synthetic */ void lambda$start$0(AudioRouteManager this_, String configString) {
        this_.startInternal(configString);
    }

    static /* synthetic */ void access$lambda$0(AudioRouteManager audioRouteManager) {
        audioRouteManager.stopInternal();
    }

    static /* synthetic */ void access$lambda$1(AudioRouteManager audioRouteManager) {
        audioRouteManager.notifyAudioIOSceneChangedInternal();
    }
}

