/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.base;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.view.Window;
import androidx.annotation.AnyThread;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import com.tencent.liteav.base.ThreadUtils;
import com.tencent.liteav.base.VisibleForTesting;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;

@JNINamespace(value="base::android")
public class ApplicationStatus {
    private static final String TOOLBAR_CALLBACK_INTERNAL_WRAPPER_CLASS = "android.support.v7.internal.app.ToolbarActionBar$ToolbarCallbackWrapper";
    private static final String TOOLBAR_CALLBACK_WRAPPER_CLASS = "android.support.v7.app.ToolbarActionBar$ToolbarCallbackWrapper";
    private static final String WINDOW_PROFILER_CALLBACK = "com.android.tools.profiler.support.event.WindowProfilerCallback";
    private static final Map<Activity, a> sActivityInfo = Collections.synchronizedMap(new HashMap());
    @SuppressLint(value={"SupportAnnotationUsage"})
    @GuardedBy(value="sActivityInfo")
    private static int sCurrentApplicationState = 0;
    @SuppressLint(value={"StaticFieldLeak"})
    private static Activity sActivity;
    private static c sNativeApplicationStateListener;
    private static final com.tencent.liteav.base.b<b> sGeneralActivityStateListeners;
    private static final com.tencent.liteav.base.b<c> sApplicationStateListeners;
    private static final com.tencent.liteav.base.b<e> sWindowFocusListeners;

    private ApplicationStatus() {
    }

    @MainThread
    public static void registerWindowFocusChangedListener(e listener) {
        assert (ApplicationStatus.isInitialized());
        sWindowFocusListeners.a(listener);
    }

    @MainThread
    public static void unregisterWindowFocusChangedListener(e listener) {
        sWindowFocusListeners.b(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInitialized() {
        Map<Activity, a> map = sActivityInfo;
        synchronized (map) {
            return sCurrentApplicationState != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public static void initialize(Application application) {
        assert (!ApplicationStatus.isInitialized());
        Map<Activity, a> map = sActivityInfo;
        synchronized (map) {
            sCurrentApplicationState = 4;
        }
        ApplicationStatus.registerWindowFocusChangedListener(new e(){

            @Override
            public final void a(Activity activity, boolean bl) {
                if (!bl || activity == sActivity) {
                    return;
                }
                int n2 = ApplicationStatus.getStateForActivity(activity);
                if (n2 != 6 && n2 != 5) {
                    sActivity = activity;
                }
            }
        });
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public final void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                ApplicationStatus.onStateChange(activity, 1);
                Window.Callback callback = activity.getWindow().getCallback();
                activity.getWindow().setCallback((Window.Callback)Proxy.newProxyInstance(Window.Callback.class.getClassLoader(), new Class[]{Window.Callback.class}, (InvocationHandler)new d(activity, callback)));
            }

            public final void onActivityDestroyed(Activity activity) {
                ApplicationStatus.onStateChange(activity, 6);
            }

            public final void onActivityPaused(Activity activity) {
                ApplicationStatus.onStateChange(activity, 4);
            }

            public final void onActivityResumed(Activity activity) {
                ApplicationStatus.onStateChange(activity, 3);
            }

            public final void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public final void onActivityStarted(Activity activity) {
                ApplicationStatus.onStateChange(activity, 2);
            }

            public final void onActivityStopped(Activity activity) {
                ApplicationStatus.onStateChange(activity, 5);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onStateChange(Activity activity, int newState) {
        a a2;
        if (activity == null) {
            throw new IllegalArgumentException("null activity is not supported");
        }
        if (sActivity == null || newState == 1 || newState == 3 || newState == 2) {
            sActivity = activity;
        }
        int n2 = ApplicationStatus.getStateForApplication();
        Iterator<b> iterator = sActivityInfo;
        synchronized (iterator) {
            if (newState == 1) {
                assert (!sActivityInfo.containsKey(activity));
                sActivityInfo.put(activity, new a(0));
            }
            a2 = sActivityInfo.get(activity);
            sActivityInfo.get(activity).a = newState;
            if (newState == 6) {
                sActivityInfo.remove(activity);
                if (activity == sActivity) {
                    sActivity = null;
                }
            }
            sCurrentApplicationState = ApplicationStatus.determineApplicationStateLocked();
        }
        iterator = a2.b.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
        iterator = sGeneralActivityStateListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
        if (ApplicationStatus.getStateForApplication() != n2) {
            Iterator<c> iterator2 = sApplicationStateListeners.iterator();
            while (iterator2.hasNext()) {
                iterator2.next();
            }
        }
    }

    @VisibleForTesting
    @MainThread
    public static void onStateChangeForTesting(Activity activity, int newState) {
        ApplicationStatus.onStateChange(activity, newState);
    }

    @MainThread
    public static Activity getLastTrackedFocusedActivity() {
        return sActivity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public static List<Activity> getRunningActivities() {
        assert (ApplicationStatus.isInitialized());
        Map<Activity, a> map = sActivityInfo;
        synchronized (map) {
            return new ArrayList<Activity>(sActivityInfo.keySet());
        }
    }

    @AnyThread
    public static int getStateForActivity(@Nullable Activity activity) {
        assert (ApplicationStatus.isInitialized());
        if (activity == null) {
            return 6;
        }
        a a2 = sActivityInfo.get(activity);
        if (a2 != null) {
            return a2.a;
        }
        return 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    @CalledByNative
    public static int getStateForApplication() {
        Map<Activity, a> map = sActivityInfo;
        synchronized (map) {
            return sCurrentApplicationState;
        }
    }

    @AnyThread
    @CalledByNative
    public static boolean hasVisibleActivities() {
        assert (ApplicationStatus.isInitialized());
        int n2 = ApplicationStatus.getStateForApplication();
        return n2 == 1 || n2 == 2;
    }

    @AnyThread
    public static boolean isEveryActivityDestroyed() {
        assert (ApplicationStatus.isInitialized());
        return sActivityInfo.isEmpty();
    }

    @MainThread
    public static void registerStateListenerForAllActivities(b listener) {
        assert (ApplicationStatus.isInitialized());
        sGeneralActivityStateListeners.a(listener);
    }

    @MainThread
    @SuppressLint(value={"NewApi"})
    public static void registerStateListenerForActivity(b listener, Activity activity) {
        assert (ApplicationStatus.isInitialized());
        assert (activity != null);
        a a2 = sActivityInfo.get(activity);
        assert (a2.a != 6);
        a2.b.a(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public static void unregisterActivityStateListener(b listener) {
        sGeneralActivityStateListeners.b(listener);
        Map<Activity, a> map = sActivityInfo;
        synchronized (map) {
            Iterator<a> iterator = sActivityInfo.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().b.b(listener);
            }
            return;
        }
    }

    @MainThread
    public static void registerApplicationStateListener(c listener) {
        sApplicationStateListeners.a(listener);
    }

    @MainThread
    public static void unregisterApplicationStateListener(c listener) {
        sApplicationStateListeners.b(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public static void destroyForJUnitTests() {
        Map<Activity, a> map = sActivityInfo;
        synchronized (map) {
            sApplicationStateListeners.a();
            sGeneralActivityStateListeners.a();
            sActivityInfo.clear();
            sWindowFocusListeners.a();
            sCurrentApplicationState = 0;
            sActivity = null;
            sNativeApplicationStateListener = null;
            return;
        }
    }

    @CalledByNative
    private static void registerThreadSafeNativeApplicationStateListener() {
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (sNativeApplicationStateListener != null) {
                    return;
                }
                sNativeApplicationStateListener = new c(){};
                ApplicationStatus.registerApplicationStateListener(sNativeApplicationStateListener);
            }
        });
    }

    @GuardedBy(value="sActivityInfo")
    private static int determineApplicationStateLocked() {
        boolean bl = false;
        boolean bl2 = false;
        Iterator<a> iterator = sActivityInfo.values().iterator();
        while (iterator.hasNext()) {
            int n2 = iterator.next().a;
            if (n2 != 4 && n2 != 5 && n2 != 6) {
                return 1;
            }
            if (n2 == 4) {
                bl = true;
                continue;
            }
            if (n2 != 5) continue;
            bl2 = true;
        }
        if (bl) {
            return 2;
        }
        if (bl2) {
            return 3;
        }
        return 4;
    }

    static {
        sGeneralActivityStateListeners = new com.tencent.liteav.base.b();
        sApplicationStateListeners = new com.tencent.liteav.base.b();
        sWindowFocusListeners = new com.tencent.liteav.base.b();
    }

    static final class d
    implements InvocationHandler {
        private final Window.Callback a;
        private final Activity b;

        public d(Activity activity, Window.Callback callback) {
            this.a = callback;
            this.b = activity;
        }

        @Override
        public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("onWindowFocusChanged") && args.length == 1 && args[0] instanceof Boolean) {
                boolean bl = (Boolean)args[0];
                d d2 = this;
                d2.a.onWindowFocusChanged(bl);
                Iterator iterator = sWindowFocusListeners.iterator();
                while (iterator.hasNext()) {
                    ((e)iterator.next()).a(d2.b, bl);
                }
                return null;
            }
            try {
                return method.invoke((Object)this.a, args);
            }
            catch (InvocationTargetException invocationTargetException) {
                InvocationTargetException invocationTargetException2 = invocationTargetException;
                if (invocationTargetException.getCause() instanceof AbstractMethodError) {
                    throw invocationTargetException2.getCause();
                }
                throw invocationTargetException2;
            }
        }
    }

    public static interface e {
        public void a(Activity var1, boolean var2);
    }

    public static interface b {
    }

    public static interface c {
    }

    static final class a {
        int a = 6;
        com.tencent.liteav.base.b<b> b = new com.tencent.liteav.base.b();

        private a() {
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

