/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.base;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Environment;
import android.system.Os;
import android.text.TextUtils;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.MainDex;
import com.tencent.liteav.base.c;
import com.tencent.liteav.base.d;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;

@MainDex
public abstract class PathUtils {
    private static final String TAG = "PathUtils";
    private static final String THUMBNAIL_DIRECTORY_NAME = "textures";
    private static final int DATA_DIRECTORY = 0;
    private static final int THUMBNAIL_DIRECTORY = 1;
    private static final int CACHE_DIRECTORY = 2;
    private static final int LOG_DIRECTORY = 3;
    private static final int NUM_DIRECTORIES = 4;
    private static final AtomicBoolean sInitializationStarted = new AtomicBoolean();
    private static FutureTask<String[]> sDirPathFetchTask;
    private static String sDataDirectorySuffix;
    private static String sCacheSubDirectory;

    private PathUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String[] getOrComputeDirectoryPaths() {
        if (!sDirPathFetchTask.cancel(false)) return sDirPathFetchTask.get();
        d d2 = d.a();
        Throwable throwable = null;
        try {
            String[] stringArray = PathUtils.setPrivateDataDirectorySuffixInternal();
            d2.close();
            return stringArray;
        }
        catch (Throwable throwable2) {
            try {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (throwable != null) {
                        try {
                            d2.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {}
                        throw throwable4;
                    } else {
                        d2.close();
                    }
                    throw throwable4;
                }
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            catch (ExecutionException executionException) {}
        }
        return null;
    }

    @SuppressLint(value={"NewApi"})
    private static void chmod(String path, int mode) {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        try {
            Os.chmod((String)path, (int)mode);
            return;
        }
        catch (Exception exception) {
            Log.e(TAG, "Failed to set permissions for path \"" + path + "\"", new Object[0]);
            return;
        }
    }

    private static String[] setPrivateDataDirectorySuffixInternal() {
        File file;
        String[] stringArray = new String[4];
        Context context = ContextUtils.getApplicationContext();
        stringArray[0] = context.getDir(sDataDirectorySuffix, 0).getPath();
        PathUtils.chmod(stringArray[0], 448);
        stringArray[1] = context.getDir(THUMBNAIL_DIRECTORY_NAME, 0).getPath();
        if (context.getCacheDir() != null) {
            stringArray[2] = sCacheSubDirectory == null ? context.getCacheDir().getPath() : new File(context.getCacheDir(), sCacheSubDirectory).getPath();
        }
        if ((file = context.getExternalFilesDir(null)) != null) {
            stringArray[3] = file.getAbsolutePath() + "/log/liteav";
        }
        return stringArray;
    }

    public static void setPrivateDataDirectorySuffix(String suffix, String cacheSubDir) {
        if (!sInitializationStarted.getAndSet(true)) {
            assert (ContextUtils.getApplicationContext() != null);
            sDataDirectorySuffix = suffix;
            sCacheSubDirectory = cacheSubDir;
            sDirPathFetchTask = new FutureTask(c.a());
            return;
        }
        assert (TextUtils.equals((CharSequence)sDataDirectorySuffix, (CharSequence)suffix)) : String.format("%s != %s", suffix, sDataDirectorySuffix);
        assert (TextUtils.equals((CharSequence)sCacheSubDirectory, (CharSequence)cacheSubDir)) : String.format("%s != %s", cacheSubDir, sCacheSubDirectory);
    }

    public static void setPrivateDataDirectorySuffix(String suffix) {
        PathUtils.setPrivateDataDirectorySuffix(suffix, null);
    }

    private static String getDirectoryPath(int index) {
        return a.a[index];
    }

    @CalledByNative
    public static String getDataDirectory() {
        assert (sDirPathFetchTask != null) : "setDataDirectorySuffix must be called first.";
        return PathUtils.getDirectoryPath(0);
    }

    @CalledByNative
    public static String getCacheDirectory() {
        assert (sDirPathFetchTask != null) : "setDataDirectorySuffix must be called first.";
        return PathUtils.getDirectoryPath(2);
    }

    @CalledByNative
    public static String getThumbnailCacheDirectory() {
        assert (sDirPathFetchTask != null) : "setDataDirectorySuffix must be called first.";
        return PathUtils.getDirectoryPath(1);
    }

    @CalledByNative
    public static String getLogDirectory() {
        assert (sDirPathFetchTask != null) : "setDataDirectorySuffix must be called first.";
        return PathUtils.getDirectoryPath(3);
    }

    @CalledByNative
    private static String getDownloadsDirectory() {
        Throwable throwable;
        d d2;
        block9: {
            d2 = d.b();
            throwable = null;
            if (Build.VERSION.SDK_INT < 29) break block9;
            String string = PathUtils.getAllPrivateDownloadsDirectories()[0];
            d2.close();
            return string;
        }
        try {
            String string = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getPath();
            d2.close();
            return string;
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (throwable != null) {
                    try {
                        d2.close();
                    }
                    catch (Throwable throwable5) {}
                } else {
                    d2.close();
                }
                throw throwable4;
            }
        }
    }

    @CalledByNative
    public static String[] getAllPrivateDownloadsDirectories() {
        File[] fileArray;
        Object object;
        if (Build.VERSION.SDK_INT >= 19) {
            object = d.a();
            Throwable throwable = null;
            try {
                fileArray = ContextUtils.getApplicationContext().getExternalFilesDirs(Environment.DIRECTORY_DOWNLOADS);
                ((d)object).close();
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (throwable != null) {
                        try {
                            ((d)object).close();
                        }
                        catch (Throwable throwable5) {}
                    } else {
                        ((d)object).close();
                    }
                    throw throwable4;
                }
            }
        } else {
            fileArray = new File[]{Environment.getExternalStorageDirectory()};
        }
        object = new ArrayList();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            if (fileArray[i2] == null || TextUtils.isEmpty((CharSequence)fileArray[i2].getAbsolutePath())) continue;
            ((ArrayList)object).add(fileArray[i2].getAbsolutePath());
        }
        Object object2 = object;
        return ((ArrayList)object2).toArray(new String[((ArrayList)object2).size()]);
    }

    @CalledByNative
    private static String getNativeLibraryDirectory() {
        ApplicationInfo applicationInfo = ContextUtils.getApplicationContext().getApplicationInfo();
        if ((applicationInfo.flags & 0x80) != 0 || (applicationInfo.flags & 1) == 0) {
            return applicationInfo.nativeLibraryDir;
        }
        return "/system/lib/";
    }

    @CalledByNative
    public static String getExternalStorageDirectory() {
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }

    static /* synthetic */ String[] access$000() {
        return PathUtils.getOrComputeDirectoryPaths();
    }

    static /* synthetic */ String[] access$lambda$0() {
        return PathUtils.setPrivateDataDirectorySuffixInternal();
    }

    static final class a {
        private static final String[] a = PathUtils.access$000();
    }
}

