/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.base;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.ThreadUtils;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;

@JNINamespace(value="base::android")
public class PowerMonitor {
    private static PowerMonitor sInstance;
    private boolean mIsBatteryPower;

    public static void createForTests() {
        sInstance = new PowerMonitor();
    }

    public static void create() {
        ThreadUtils.assertOnUiThread();
        if (sInstance != null) {
            return;
        }
        Context context = ContextUtils.getApplicationContext();
        sInstance = new PowerMonitor();
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = context.registerReceiver(null, intentFilter);
        if (intent != null) {
            PowerMonitor.onBatteryChargingChanged(intent);
        }
        IntentFilter intentFilter2 = new IntentFilter();
        intentFilter2.addAction("android.intent.action.ACTION_POWER_CONNECTED");
        intentFilter2.addAction("android.intent.action.ACTION_POWER_DISCONNECTED");
        context.registerReceiver(new BroadcastReceiver(){

            public final void onReceive(Context context, Intent intent) {
                PowerMonitor.onBatteryChargingChanged(intent);
            }
        }, intentFilter2);
    }

    private PowerMonitor() {
    }

    private static void onBatteryChargingChanged(Intent intent) {
        assert (sInstance != null);
        int n2 = intent.getIntExtra("plugged", -1);
        PowerMonitor.sInstance.mIsBatteryPower = n2 != 2 && n2 != 1;
    }

    @CalledByNative
    private static boolean isBatteryPower() {
        if (sInstance == null) {
            PowerMonitor.create();
        }
        return PowerMonitor.sInstance.mIsBatteryPower;
    }
}

