/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videobase.frame;

import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.frame.g;
import com.tencent.liteav.videobase.frame.k;
import com.tencent.liteav.videobase.utils.Rotation;
import java.nio.ByteBuffer;
import java.util.Collection;

@JNINamespace(value="liteav::video")
public class PixelFrame
extends k {
    private long mTimestamp = 0L;
    protected int mWidth = -1;
    protected int mHeight = -1;
    protected GLConstants.PixelBufferType mPixelBufferType;
    protected GLConstants.PixelFormatType mPixelFormatType;
    private Rotation mRotation = Rotation.a;
    private boolean mIsMirrorHorizontal = false;
    private boolean mIsMirrorVertical = false;
    private float[] mMatrix = null;
    protected byte[] mData = null;
    protected ByteBuffer mBuffer = null;
    protected int mTextureId = -1;
    protected Object mGLContext = null;

    public PixelFrame() {
        super(null);
    }

    public PixelFrame(PixelFrame copyFrom) {
        super(null);
        this.copy(copyFrom);
    }

    @CalledByNative
    public PixelFrame(int width, int height, int bufferType, int formatType) {
        this(null, width, height, GLConstants.PixelBufferType.a(bufferType), GLConstants.PixelFormatType.a(formatType));
    }

    public PixelFrame(g<PixelFrame> recycler, int width, int height, GLConstants.PixelBufferType bufferType, GLConstants.PixelFormatType formatType) {
        super(recycler);
        int n2;
        this.mWidth = width;
        this.mHeight = height;
        this.mPixelFormatType = formatType;
        this.mPixelBufferType = bufferType;
        int n3 = n2 = this.mPixelFormatType == GLConstants.PixelFormatType.f ? width * height * 4 : width * height * 3 / 2;
        if (this.mPixelBufferType == GLConstants.PixelBufferType.d) {
            this.mData = new byte[n2];
            return;
        }
        this.mBuffer = ByteBuffer.allocateDirect(n2);
    }

    @CalledByNative
    public void copy(PixelFrame copyFrom) {
        this.mTimestamp = copyFrom.mTimestamp;
        this.mWidth = copyFrom.mWidth;
        this.mHeight = copyFrom.mHeight;
        this.mPixelBufferType = copyFrom.mPixelBufferType;
        this.mPixelFormatType = copyFrom.mPixelFormatType;
        this.mRotation = copyFrom.mRotation;
        this.mIsMirrorHorizontal = copyFrom.mIsMirrorHorizontal;
        this.mIsMirrorVertical = copyFrom.mIsMirrorVertical;
        if (copyFrom.mMatrix != null) {
            this.mMatrix = new float[16];
            System.arraycopy(copyFrom.getMatrix(), 0, this.mMatrix, 0, this.mMatrix.length);
        }
        this.mMatrix = copyFrom.mMatrix;
        this.mData = copyFrom.mData;
        this.mBuffer = copyFrom.mBuffer;
        this.mTextureId = copyFrom.mTextureId;
        this.mGLContext = copyFrom.mGLContext;
    }

    protected PixelFrame(g<? extends PixelFrame> recycler) {
        super(recycler);
    }

    public void setPixelBufferType(GLConstants.PixelBufferType pixelBufferType) {
        this.mPixelBufferType = pixelBufferType;
    }

    public GLConstants.PixelBufferType getPixelBufferType() {
        return this.mPixelBufferType;
    }

    public void setPixelFormatType(GLConstants.PixelFormatType pixelFormatType) {
        this.mPixelFormatType = pixelFormatType;
    }

    public GLConstants.PixelFormatType getPixelFormatType() {
        return this.mPixelFormatType;
    }

    @CalledByNative
    private int getPixelFormatTypeValue() {
        return this.mPixelFormatType.getValue();
    }

    @CalledByNative
    private int getPixelBufferTypeValue() {
        return this.mPixelBufferType.mValue;
    }

    public void setData(byte[] data) {
        this.mData = data;
    }

    @CalledByNative
    public byte[] getData() {
        return this.mData;
    }

    public void setBuffer(ByteBuffer buffer) {
        this.mBuffer = buffer;
    }

    @CalledByNative
    public ByteBuffer getBuffer() {
        return this.mBuffer;
    }

    public void setTextureId(int textureId) {
        this.mTextureId = textureId;
    }

    public int getTextureId() {
        return this.mTextureId;
    }

    public void setWidth(int width) {
        this.mWidth = width;
    }

    @CalledByNative
    public int getWidth() {
        return this.mWidth;
    }

    public void setHeight(int height) {
        this.mHeight = height;
    }

    @CalledByNative
    public int getHeight() {
        return this.mHeight;
    }

    public void setRotation(Rotation rotation) {
        this.mRotation = rotation;
    }

    public Rotation getRotation() {
        return this.mRotation;
    }

    public void setMirrorHorizontal(boolean mirror) {
        this.mIsMirrorHorizontal = mirror;
    }

    public boolean isMirrorHorizontal() {
        return this.mIsMirrorHorizontal;
    }

    public void setMirrorVertical(boolean mirror) {
        this.mIsMirrorVertical = mirror;
    }

    public boolean isMirrorVertical() {
        return this.mIsMirrorVertical;
    }

    public void setMatrix(float[] matrix) {
        this.mMatrix = matrix;
    }

    public float[] getMatrix() {
        return this.mMatrix;
    }

    public void setTimestamp(long timestamp) {
        this.mTimestamp = timestamp;
    }

    @CalledByNative
    public long getTimestamp() {
        return this.mTimestamp;
    }

    public void setGLContext(Object glContext) {
        this.mGLContext = glContext;
    }

    public Object getGLContext() {
        return this.mGLContext;
    }

    public void swapWidthHeight() {
        int n2 = this.mWidth;
        this.mWidth = this.mHeight;
        this.mHeight = n2;
    }

    public boolean hasTransformParams() {
        return this.mRotation != Rotation.a || this.mIsMirrorHorizontal || this.mIsMirrorVertical || this.mMatrix != null;
    }

    public void postRotate(Rotation rotation) {
        if (rotation == Rotation.b || rotation == Rotation.d) {
            this.swapWidthHeight();
        }
        PixelFrame pixelFrame = this;
        pixelFrame.setRotation(Rotation.a((pixelFrame.mRotation.mValue + rotation.mValue) % 360));
    }

    public boolean isFrameDataValid() {
        return !(this.mPixelBufferType == GLConstants.PixelBufferType.b && this.mTextureId == -1 || this.mPixelBufferType == GLConstants.PixelBufferType.a && this.mBuffer == null || this.mPixelBufferType == GLConstants.PixelBufferType.d && this.mData == null);
    }

    public static void releasePixelFrames(Collection<PixelFrame> pixelFrameList) {
        if (pixelFrameList == null) {
            return;
        }
        for (PixelFrame pixelFrame : pixelFrameList) {
            if (pixelFrame == null) continue;
            pixelFrame.release();
        }
        pixelFrameList.clear();
    }
}

