/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoconsumer.decoder;

import android.os.Looper;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.t;
import com.tencent.liteav.videobase.common.CodecType;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.utils.j;
import com.tencent.liteav.videobase.utils.k;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.e;
import com.tencent.liteav.videobase.videobase.f;
import com.tencent.liteav.videoconsumer.consumer.ServerVideoConsumerConfig;
import com.tencent.liteav.videoconsumer.decoder.ExternalDecodeFactoryManager;
import com.tencent.liteav.videoconsumer.decoder.SoftwareVideoDecoder;
import com.tencent.liteav.videoconsumer.decoder.SpsInfo;
import com.tencent.liteav.videoconsumer.decoder.VideoDecoderDef;
import com.tencent.liteav.videoconsumer.decoder.ab;
import com.tencent.liteav.videoconsumer.decoder.ac;
import com.tencent.liteav.videoconsumer.decoder.ad;
import com.tencent.liteav.videoconsumer.decoder.af;
import com.tencent.liteav.videoconsumer.decoder.ag;
import com.tencent.liteav.videoconsumer.decoder.ah;
import com.tencent.liteav.videoconsumer.decoder.ai;
import com.tencent.liteav.videoconsumer.decoder.ao;
import com.tencent.liteav.videoconsumer.decoder.aq;
import com.tencent.liteav.videoconsumer.decoder.ar;
import com.tencent.liteav.videoconsumer.decoder.b;
import com.tencent.liteav.videoconsumer.decoder.d;
import com.tencent.liteav.videoconsumer.decoder.p;
import com.tencent.liteav.videoconsumer.decoder.w;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;

public final class VideoDecodeController
implements ar {
    @NonNull
    final IVideoReporter a;
    @NonNull
    final d b;
    @NonNull
    final ao c;
    final boolean d;
    public com.tencent.liteav.base.util.b e;
    t f;
    a g;
    Object h;
    com.tencent.liteav.videobase.b.e i;
    boolean j = false;
    aq k;
    JSONArray l;
    public VideoDecoderDef.ConsumerScene m = VideoDecoderDef.ConsumerScene.a;
    final AtomicInteger n = new AtomicInteger(0);
    final j o = new j(1);
    ServerVideoConsumerConfig p;
    final k q;
    private final d.d r = w.a();

    public VideoDecodeController(@NonNull IVideoReporter reporter) {
        this.a = reporter;
        this.d = false;
        b.a.a();
        boolean bl = ExternalDecodeFactoryManager.a();
        b.a.a();
        this.b = new d(this.r, reporter, bl, com.tencent.liteav.videoconsumer.decoder.b.b());
        this.c = new ao(reporter);
        this.q = new k("decoder" + this.hashCode());
    }

    final void f() {
        LiteavLog.i("VideoDecodeController", "initializeEGLCoreInternal()");
        this.i = new com.tencent.liteav.videobase.b.e();
        try {
            this.i.a(this.h, null, 128, 128);
            this.q.a((e)null);
            return;
        }
        catch (com.tencent.liteav.videobase.b.f f2) {
            LiteavLog.e("VideoDecodeController", "create egl core failed.", f2);
            this.a.notifyWarning(e.c.h, "VideoDecode: create EGLCore failed", new Object[0]);
            this.i = null;
            return;
        }
    }

    final void g() {
        LiteavLog.i("VideoDecodeController", "uninitializeEGLCoreInternal()");
        if (this.i == null) {
            return;
        }
        this.q.a();
        try {
            this.i.b();
            this.i.e();
        }
        catch (com.tencent.liteav.videobase.b.f f2) {
            LiteavLog.e("VideoDecodeController", "destroy egl core failed.", f2);
            this.a.notifyWarning(e.c.s, "VideoDecode: destroy EGLCore failed", new Object[0]);
        }
        this.i = null;
    }

    public final void a(Object object) {
        LiteavLog.i("VideoDecodeController", "setSharedEGLContext(object:" + object + ", mEGLCore: " + this.i + ")");
        VideoDecodeController videoDecodeController = this;
        videoDecodeController.a(ai.a(videoDecodeController, object));
    }

    final void a(EncodedVideoFrame encodedVideoFrame, aq.a a2) {
        long l2 = SystemClock.elapsedRealtime();
        this.i();
        SpsInfo spsInfo = this.r.a(encodedVideoFrame.isH265(), encodedVideoFrame.data);
        this.k = a2 == aq.a.a ? new SoftwareVideoDecoder(this.a) : new p(new com.tencent.liteav.base.util.p(spsInfo.width, spsInfo.height), encodedVideoFrame.isH265(), this.l, this.a);
        this.k.initialize();
        this.k.setServerConfig(this.p);
        this.k.setScene(this.m);
        this.k.start(this.i.d(), this);
        this.n.set(0);
        LiteavLog.d("VideoDecodeController", "open decoder cost time: " + (SystemClock.elapsedRealtime() - l2));
        LiteavLog.i("VideoDecodeController", "update decoder type to " + (Object)((Object)a2) + ", video " + spsInfo);
        boolean bl = encodedVideoFrame.isH265();
        aq.a a3 = this.k.getDecoderType();
        ao ao2 = this.c;
        this.c.e = a3;
        if (bl && a3 == aq.a.a) {
            a3 = aq.a.c;
        }
        VideoDecoderDef.DecoderProperty decoderProperty = new VideoDecoderDef.DecoderProperty(a3, bl ? CodecType.b : CodecType.a);
        ao2.a.updateStatus(com.tencent.liteav.videobase.videobase.f.L, decoderProperty);
    }

    final void a(EncodedVideoFrame encodedVideoFrame) {
        EncodedVideoFrame encodedVideoFrame2 = encodedVideoFrame;
        ao ao2 = this.c;
        if (!ao2.i && encodedVideoFrame2.isIDRFrame()) {
            ao2.g = SystemClock.elapsedRealtime();
            ao2.i = true;
            ao2.a.notifyEvent(e.b.A, "Start decode first frame", new Object[0]);
            LiteavLog.d("VideoDecodeControllerStatistics", "received first I frame.");
        }
        if (!ao2.f) {
            ++ao2.h;
        }
        long l2 = encodedVideoFrame2.pts;
        ao.a a2 = ao2.b;
        if (a2.e.isEmpty()) {
            a2.d = SystemClock.elapsedRealtime();
        }
        a2.e.addLast(l2);
        if (this.k != null) {
            this.n.incrementAndGet();
            this.k.decode(encodedVideoFrame);
        }
    }

    final aq.a h() {
        if (this.k == null) {
            return null;
        }
        return this.k.getDecoderType();
    }

    final void i() {
        if (this.k != null) {
            this.k.stop();
            this.k.uninitialize();
            this.k = null;
        }
        this.o.b();
    }

    public final boolean a(Runnable runnable) {
        boolean bl = true;
        com.tencent.liteav.base.util.b b2 = this.e;
        if (b2 != null && b2.getLooper().getThread().isAlive()) {
            if (Looper.myLooper() == b2.getLooper()) {
                runnable.run();
            } else {
                bl = b2.post(runnable);
            }
        } else {
            bl = false;
        }
        if (!bl) {
            LiteavLog.w("VideoDecodeController", "runnable:" + runnable + " is failed to post, handler:" + (Object)((Object)b2));
        }
        return bl;
    }

    final boolean j() {
        try {
            this.i.a();
            return true;
        }
        catch (com.tencent.liteav.videobase.b.f f2) {
            LiteavLog.e("VideoDecodeController", "make current failed.", f2);
            return false;
        }
    }

    @Override
    public final void a(PixelFrame pixelFrame, long l2) {
        long l3 = pixelFrame.getTimestamp();
        this.o.a(pixelFrame);
        VideoDecodeController videoDecodeController = this;
        if (!videoDecodeController.a(ab.a(videoDecodeController, l3, l2))) {
            this.o.b(pixelFrame);
        }
    }

    @Override
    public final void a() {
        VideoDecodeController videoDecodeController = this;
        videoDecodeController.a(ac.a(videoDecodeController));
    }

    @Override
    public final void b() {
        VideoDecodeController videoDecodeController = this;
        videoDecodeController.a(ad.a(videoDecodeController));
    }

    @Override
    public final void c() {
        VideoDecodeController videoDecodeController = this;
        videoDecodeController.a(af.a(videoDecodeController));
    }

    @Override
    public final void d() {
        VideoDecodeController videoDecodeController = this;
        videoDecodeController.a(ag.a(videoDecodeController));
    }

    @Override
    public final void e() {
        VideoDecodeController videoDecodeController = this;
        videoDecodeController.a(ah.a(videoDecodeController));
    }

    public static enum DecodeStrategy {
        a(0),
        b(1),
        c(2),
        d(3);

        private final int mValue;
        private static final DecodeStrategy[] e;

        private DecodeStrategy(int mValue) {
            this.mValue = mValue;
        }

        public static DecodeStrategy a(int n2) {
            DecodeStrategy[] decodeStrategyArray = e;
            int n3 = e.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                DecodeStrategy decodeStrategy = decodeStrategyArray[i2];
                if (decodeStrategy.mValue != n2) continue;
                return decodeStrategy;
            }
            return a;
        }

        static {
            e = DecodeStrategy.values();
        }
    }

    public static interface a
    extends ar {
    }
}

