/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoconsumer.decoder;

import android.graphics.SurfaceTexture;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.HandlerThread;
import android.os.Looper;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.b;
import com.tencent.liteav.videobase.b.e;
import com.tencent.liteav.videobase.b.f;
import com.tencent.liteav.videobase.common.CodecType;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.l;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.e;
import com.tencent.liteav.videoconsumer.consumer.ServerVideoConsumerConfig;
import com.tencent.liteav.videoconsumer.decoder.VideoDecoderDef;
import com.tencent.liteav.videoconsumer.decoder.aq;
import com.tencent.liteav.videoconsumer.decoder.ar;
import com.tencent.liteav.videoconsumer.decoder.o;
import com.tencent.liteav.videoconsumer.decoder.q;
import com.tencent.liteav.videoconsumer.decoder.r;
import com.tencent.liteav.videoconsumer.decoder.s;
import com.tencent.liteav.videoconsumer.decoder.t;
import com.tencent.liteav.videoconsumer.decoder.u;
import com.tencent.liteav.videoconsumer.decoder.v;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class p
implements SurfaceTexture.OnFrameAvailableListener,
aq {
    private static final EncodedVideoFrame a = new EncodedVideoFrame();
    @NonNull
    private final com.tencent.liteav.base.util.p b = new com.tencent.liteav.base.util.p();
    @NonNull
    private final IVideoReporter c;
    private final boolean d;
    private final JSONArray e;
    private volatile b f;
    private MediaCodec g = null;
    private ar h;
    private final MediaCodec.BufferInfo i = new MediaCodec.BufferInfo();
    private final Deque<EncodedVideoFrame> j = new LinkedList<EncodedVideoFrame>();
    private boolean k = true;
    private e l;
    private int m = -1;
    private l n;
    private SurfaceTexture o;
    private Surface p;
    private VideoDecoderDef.ConsumerScene q = VideoDecoderDef.ConsumerScene.a;
    private boolean r = false;
    private o s = new o();
    private boolean t = false;
    private com.tencent.liteav.base.util.t u;

    public p(@NonNull com.tencent.liteav.base.util.p p2, boolean bl, @Nullable JSONArray jSONArray, @NonNull IVideoReporter iVideoReporter) {
        this.d = bl;
        this.e = jSONArray;
        this.b.a = p2.a;
        this.b.b = p2.b;
        this.c = iVideoReporter;
        LiteavLog.i("HardwareVideoDecoder", "create decoder " + p2 + ", useHevc: " + bl + " , params: " + jSONArray);
    }

    @Override
    public final void initialize() {
        HandlerThread handlerThread = new HandlerThread("HardwareVideoDecoder_" + this.hashCode());
        handlerThread.start();
        this.f = new b(handlerThread.getLooper());
    }

    @Override
    public final void uninitialize() {
        if (this.f != null) {
            this.f.a();
        }
    }

    @Override
    public final void setScene(VideoDecoderDef.ConsumerScene scene) {
        p p2 = this;
        p2.a(com.tencent.liteav.videoconsumer.decoder.q.a(p2, scene));
    }

    @Override
    public final void start(Object glContext, ar listener) {
        p p2 = this;
        p2.a(com.tencent.liteav.videoconsumer.decoder.r.a(p2, glContext, listener));
    }

    private boolean a(Object object) {
        this.l = new e();
        try {
            this.l.a(object, null, 128, 128);
            this.l.a();
        }
        catch (f f2) {
            LiteavLog.e("HardwareVideoDecoder", "create EGLCore failed.", f2);
            this.a(e.c.h, "VideoDecode: create EGLCore failed errorCode:" + f2.mErrorCode, new Object[0]);
            return false;
        }
        this.m = OpenGlUtils.generateTextureOES();
        this.n = new l();
        try {
            this.o = new SurfaceTexture(this.m);
            this.p = new Surface(this.o);
            this.o.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        }
        catch (Surface.OutOfResourcesException outOfResourcesException) {
            LiteavLog.e("HardwareVideoDecoder", "create SurfaceTexture failed.", outOfResourcesException);
            this.a(e.c.k, "VideoDecode: insufficient resource, Start decoder failed:" + outOfResourcesException.getMessage(), new Object[0]);
            return false;
        }
        LiteavLog.i("HardwareVideoDecoder", "initialize gl components");
        return true;
    }

    private boolean a(String string, a a2, boolean bl) {
        MediaFormat mediaFormat;
        MediaFormat mediaFormat2 = MediaFormat.createVideoFormat((String)string, (int)this.b.a, (int)this.b.b);
        if (bl) {
            mediaFormat = mediaFormat2;
            if (this.q == VideoDecoderDef.ConsumerScene.c) {
                if (LiteavSystemInfo.getSystemOSVersionInt() >= 26 && LiteavSystemInfo.getHardware().toLowerCase().contains("qcom")) {
                    mediaFormat.setInteger("vendor.qti-ext-dec-low-latency.enable", 1);
                    mediaFormat.setInteger("vendor.qti-ext-dec-picture-order.enable", 1);
                } else if (LiteavSystemInfo.getSystemOSVersionInt() >= 29 && LiteavSystemInfo.getHardware().toLowerCase().contains("kirin")) {
                    mediaFormat.setInteger("vendor.hisi-ext-low-latency-video-dec.video-scene-for-low-latency-req", 1);
                    mediaFormat.setInteger("vendor.hisi-ext-low-latency-video-dec.video-scene-for-low-latency-rdy", -1);
                } else if (LiteavSystemInfo.getSystemOSVersionInt() >= 26 && LiteavSystemInfo.getHardware().toLowerCase().contains("exynos")) {
                    mediaFormat.setInteger("vendor.rtc-ext-dec-low-latency.enable", 1);
                }
                if (LiteavSystemInfo.getSystemOSVersionInt() >= 30) {
                    mediaFormat.setInteger("low-latency", 1);
                }
            }
        }
        mediaFormat = this.e;
        MediaFormat mediaFormat3 = mediaFormat2;
        if (mediaFormat != null) {
            try {
                for (int i2 = 0; i2 < mediaFormat.length(); ++i2) {
                    JSONObject jSONObject = mediaFormat.getJSONObject(i2);
                    mediaFormat3.setInteger(jSONObject.optString("key"), jSONObject.optInt("value"));
                }
            }
            catch (JSONException jSONException) {
                LiteavLog.e("HardwareVideoDecoder", "set MediaCodec device related params failed.", jSONException);
            }
        }
        LiteavLog.i("HardwareVideoDecoder", String.valueOf(mediaFormat2));
        try {
            a2.a = MediaCodec.createDecoderByType((String)string);
            a2.a.configure(mediaFormat2, this.p, null, 0);
            a2.a.setVideoScalingMode(1);
            a2.a.start();
            LiteavLog.i("HardwareVideoDecoder", "Start MediaCodec success.");
            return true;
        }
        catch (Exception exception) {
            LiteavLog.e("HardwareVideoDecoder", "Start MediaCodec failed.", exception);
            com.tencent.liteav.videoconsumer.decoder.p.a(a2.a);
            a2.a = null;
            e.c c2 = e.c.m;
            String string2 = "VideoDecode: Start decoder failed";
            if (exception instanceof IllegalArgumentException) {
                c2 = e.c.i;
                string2 = "VideoDecode: illegal argument, Start decoder failed";
            } else if (exception instanceof IllegalStateException) {
                c2 = e.c.j;
                string2 = "VideoDecode: illegal state, Start decoder failed";
            }
            a2.b = c2;
            a2.c = string2;
            a2.d = exception;
            return false;
        }
    }

    /*
     * Loose catch block
     */
    private static void a(MediaCodec mediaCodec) {
        if (mediaCodec != null) {
            mediaCodec.stop();
            try {
                mediaCodec.release();
                return;
            }
            catch (Exception exception) {
                LiteavLog.e("HardwareVideoDecoder", "release MediaCodec failed.", exception);
                return;
            }
            catch (Exception exception) {
                try {
                    LiteavLog.e("HardwareVideoDecoder", "Stop MediaCodec failed." + exception.getMessage());
                }
                catch (Throwable throwable) {
                    try {
                        mediaCodec.release();
                    }
                    catch (Exception exception2) {
                        LiteavLog.e("HardwareVideoDecoder", "release MediaCodec failed.", exception2);
                    }
                    throw throwable;
                }
                try {
                    mediaCodec.release();
                    return;
                }
                catch (Exception exception3) {
                    LiteavLog.e("HardwareVideoDecoder", "release MediaCodec failed.", exception3);
                    return;
                }
            }
        }
    }

    @Override
    public final void decode(EncodedVideoFrame frame) {
        p p2 = this;
        p2.a(com.tencent.liteav.videoconsumer.decoder.s.a(p2, frame));
    }

    @Override
    public final void stop() {
        p p2 = this;
        p2.a(com.tencent.liteav.videoconsumer.decoder.t.a(p2));
    }

    @Override
    public final aq.a getDecoderType() {
        return aq.a.b;
    }

    @Override
    public final void setServerConfig(ServerVideoConsumerConfig config) {
        p p2 = this;
        p2.a(com.tencent.liteav.videoconsumer.decoder.u.a(p2, config));
    }

    private void a() {
        if (this.u != null) {
            LiteavLog.i("HardwareVideoDecoder", "stopEosTimer");
            this.u.a();
            this.u = null;
        }
    }

    public final void onFrameAvailable(SurfaceTexture surfaceTexture) {
        p p2 = this;
        p2.a(v.a(p2, surfaceTexture));
    }

    private boolean b() {
        try {
            if (this.l != null) {
                this.l.a();
            }
            return true;
        }
        catch (f f2) {
            LiteavLog.e("HardwareVideoDecoder", "makeCurrent failed.", f2);
            return false;
        }
    }

    private void a(e.c c2, String string, Object ... objectArray) {
        this.c.notifyWarning(c2, string, objectArray);
        if (this.h != null) {
            this.h.a();
        }
    }

    private void a(Runnable runnable) {
        b b2 = this.f;
        if (b2 != null) {
            if (b2.getLooper() == Looper.myLooper()) {
                runnable.run();
                return;
            }
            b2.post(runnable);
        }
    }

    static /* synthetic */ void a(p p2, SurfaceTexture surfaceTexture) {
        if (p2.o == null || surfaceTexture != p2.o) {
            LiteavLog.i("HardwareVideoDecoder", "mSurfaceTexture= " + p2.o + " ,surfaceTexture= " + surfaceTexture);
            return;
        }
        p2.b();
        l.b b2 = null;
        try {
            b2 = (l.b)p2.n.a();
        }
        catch (InterruptedException interruptedException) {
            LiteavLog.w("HardwareVideoDecoder", "textureholderpool obtain interrupted.");
        }
        b2.a(36197, p2.m, p2.b.a, p2.b.b);
        PixelFrame pixelFrame = b2.a(p2.l.d());
        if (pixelFrame.getMatrix() == null) {
            pixelFrame.setMatrix(new float[16]);
        }
        try {
            surfaceTexture.updateTexImage();
            surfaceTexture.getTransformMatrix(pixelFrame.getMatrix());
        }
        catch (Exception exception) {
            LiteavLog.w("HardwareVideoDecoder", "updateTexImage exception: ".concat(String.valueOf(exception)));
        }
        p2.k = true;
        long l2 = TimeUnit.NANOSECONDS.toMillis(surfaceTexture.getTimestamp());
        pixelFrame.setTimestamp(l2);
        p2.h.a(pixelFrame, l2);
        b2.release();
        pixelFrame.release();
        if (p2.t) {
            p p3 = p2;
            if (p3.h != null) {
                p3.h.c();
            }
            p2.t = false;
        }
    }

    static /* synthetic */ void a(p p2, ServerVideoConsumerConfig serverVideoConsumerConfig) {
        if (serverVideoConsumerConfig == null) {
            return;
        }
        p2.r = serverVideoConsumerConfig.enableVui;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static /* synthetic */ void a(p p2, EncodedVideoFrame encodedVideoFrame) {
        EncodedVideoFrame encodedVideoFrame2 = encodedVideoFrame;
        p p3 = p2;
        p3.a();
        if (encodedVideoFrame2 != null) {
            p3.j.addLast(encodedVideoFrame2);
        }
        p p4 = p3;
        if (p4.g == null) {
            LiteavLog.w("HardwareVideoDecoder", "MediaCodec is stopped.");
            return;
        }
        try {
            MediaFormat mediaFormat;
            int n2;
            p p5;
            while (p4.k) {
                boolean bl;
                block37: {
                    p5 = p4;
                    for (int i2 = 0; i2 < 3 && (n2 = p5.g.dequeueOutputBuffer(p5.i, TimeUnit.MILLISECONDS.toMicros(10L))) != -1; ++i2) {
                        if (n2 == -3) {
                            LiteavLog.i("HardwareVideoDecoder", "on output buffers changed");
                            continue;
                        }
                        if (n2 == -2) {
                            mediaFormat = p5.g.getOutputFormat();
                            LiteavLog.i("HardwareVideoDecoder", "decode output format changed: ".concat(String.valueOf(mediaFormat)));
                            int n3 = Math.abs(mediaFormat.getInteger("crop-right") - mediaFormat.getInteger("crop-left")) + 1;
                            int n4 = Math.abs(mediaFormat.getInteger("crop-bottom") - mediaFormat.getInteger("crop-top")) + 1;
                            int n5 = mediaFormat.getInteger("width");
                            int n6 = mediaFormat.getInteger("height");
                            LiteavLog.i("HardwareVideoDecoder", "cropWidth: %d, cropHeight: %d, frameWidth: %d, frameHeight: %d", n3, n4, n5, n6);
                            continue;
                        }
                        if (n2 >= 0) {
                            p5.k = false;
                            p5.g.releaseOutputBuffer(n2, true);
                            if ((p5.i.flags & 4) != 0) {
                                LiteavLog.i("HardwareVideoDecoder", "meet end of stream.");
                                p5.a();
                                p p6 = p5;
                                if (p6.h != null) {
                                    p6.h.e();
                                }
                                p5.k = true;
                            }
                            bl = true;
                            break block37;
                        }
                        LiteavLog.d("HardwareVideoDecoder", "dequeueOutputBuffer get invalid index: %d", n2);
                        break;
                    }
                    bl = false;
                }
                if (bl) continue;
            }
            while (!p4.j.isEmpty()) {
                EncodedVideoFrame encodedVideoFrame3 = p4.j.peekFirst();
                if (encodedVideoFrame3 == null || encodedVideoFrame3 != a && (encodedVideoFrame3.data == null || encodedVideoFrame3.data.remaining() == 0)) {
                    LiteavLog.w("HardwareVideoDecoder", "receive empty buffer.");
                } else {
                    MediaFormat mediaFormat2;
                    mediaFormat = mediaFormat2 = p5.g.getInputBuffers();
                    if (mediaFormat2 == null || ((ByteBuffer[])mediaFormat).length == 0) {
                        LiteavLog.e("HardwareVideoDecoder", "get invalid input buffers.");
                        return;
                    }
                    n2 = p5.g.dequeueInputBuffer(10000L);
                    if (n2 < 0) {
                        return;
                    }
                    if (encodedVideoFrame3 != a) {
                        EncodedVideoFrame encodedVideoFrame4 = encodedVideoFrame3;
                        p p7 = p5;
                        if (encodedVideoFrame4.isIDRFrame() && encodedVideoFrame4.codecType == CodecType.a && p7.r && p7.q == VideoDecoderDef.ConsumerScene.c) {
                            byte[] byArray;
                            byte[] byArray2;
                            int[] nArray;
                            byte[] byArray3 = new byte[encodedVideoFrame4.data.remaining()];
                            encodedVideoFrame4.data.get(byArray3);
                            encodedVideoFrame4.data.rewind();
                            int[] nArray2 = nArray = new int[]{-1};
                            Object object = byArray3;
                            int n7 = 0;
                            while (n7 + 4 < ((byte[])object).length && (n7 = EncodedVideoFrame.getNextNALHeaderPos(n7, ByteBuffer.wrap((byte[])object))) >= 0) {
                                if ((object[n7] & 0x1F) != 7) continue;
                                nArray2[0] = n7;
                                break;
                            }
                            if (nArray2[0] < 0) {
                                byArray2 = null;
                            } else {
                                void var26_34;
                                n7 = ((byte[])object).length - nArray2[0];
                                int n8 = nArray2[0];
                                while (var26_34 + 3 < ((byte[])object).length) {
                                    if (object[var26_34] == 0 && object[var26_34 + true] == 0 && object[var26_34 + 2] == 1 || object[var26_34] == 0 && object[var26_34 + true] == 0 && object[var26_34 + 2] == 0 && object[var26_34 + 3] == 1) {
                                        n7 = var26_34 - nArray2[0];
                                        break;
                                    }
                                    ++var26_34;
                                }
                                byte[] byArray4 = new byte[n7];
                                System.arraycopy(object, nArray2[0], byArray4, 0, byArray4.length);
                                byArray2 = byArray = byArray4;
                            }
                            if (byArray2 != null && nArray[0] >= 0) {
                                void var21_25;
                                Object var21_26 = null;
                                try {
                                    void var26_41;
                                    void var26_38;
                                    byte[] byArray5;
                                    nArray2 = byArray;
                                    object = p7.s;
                                    n7 = 0;
                                    int[] nArray3 = nArray2;
                                    byte[] byArray6 = new byte[nArray2.length];
                                    int n9 = 0;
                                    int n10 = 0;
                                    while (n10 < nArray3.length) {
                                        if (n10 < nArray3.length - 3 && nArray3[n10] == 0 && nArray3[n10 + 1] == 0 && nArray3[n10 + 2] == 3 && nArray3[n10 + 3] <= 3) {
                                            byArray6[n9++] = nArray3[n10];
                                            byArray6[n9++] = nArray3[n10 + 1];
                                            n10 += 3;
                                            continue;
                                        }
                                        byArray6[n9++] = nArray3[n10];
                                        ++n10;
                                    }
                                    if (n9 != nArray3.length) {
                                        byte[] byArray7 = new byte[n9];
                                        System.arraycopy(byArray6, 0, byArray7, 0, n9);
                                        byArray5 = byArray7;
                                    } else {
                                        byte[] byArray8;
                                        byArray5 = byArray8 = null;
                                    }
                                    if (byArray5 != null) {
                                        n7 = 1;
                                    } else {
                                        int[] nArray4 = nArray2;
                                    }
                                    byte[] byArray9 = ((o)object).a(new ByteArrayInputStream((byte[])var26_38));
                                    if (byArray9 != null && n7 != 0) {
                                        byte[] byArray10 = com.tencent.liteav.videoconsumer.decoder.o.a(byArray9);
                                    }
                                    void var21_27 = var26_41;
                                }
                                catch (Exception exception) {
                                    LiteavLog.e("HardwareVideoDecoder", "modify dec buffer error ", exception);
                                }
                                if (var21_25 != null) {
                                    encodedVideoFrame4.data = ByteBuffer.allocateDirect(byArray3.length - byArray.length + ((void)var21_25).length);
                                    if (nArray[0] > 0) {
                                        encodedVideoFrame4.data.put(byArray3, 0, nArray[0]);
                                    }
                                    encodedVideoFrame4.data.put((byte[])var21_25);
                                    encodedVideoFrame4.data.put(byArray3, nArray[0] + byArray.length, byArray3.length - nArray[0] - byArray.length);
                                    encodedVideoFrame4.data.rewind();
                                }
                            }
                        }
                        int n11 = encodedVideoFrame3.data.remaining();
                        mediaFormat2[n2].put(encodedVideoFrame3.data);
                        p5.g.queueInputBuffer(n2, 0, n11, TimeUnit.MILLISECONDS.toMicros(encodedVideoFrame3.pts), 0);
                        if (p5.h != null) {
                            p5.h.d();
                        }
                    } else {
                        LiteavLog.i("HardwareVideoDecoder", "feedDataToMediaCodec BUFFER_FLAG_END_OF_STREAM");
                        p5.g.queueInputBuffer(n2, 0, 0, 0L, 4);
                    }
                }
                boolean bl = true;
                if (!bl) return;
                EncodedVideoFrame encodedVideoFrame5 = p4.j.removeFirst();
                if (encodedVideoFrame5 == null) continue;
                encodedVideoFrame5.release();
            }
            return;
        }
        catch (Exception exception) {
            LiteavLog.e("HardwareVideoDecoder", "decode failed.", exception);
            p4.a(e.c.n, "VideoDecode: decode error, restart decoder message:" + exception.getMessage(), new Object[0]);
            return;
        }
    }

    static /* synthetic */ void a(p p2, Object object, ar ar2) {
        ar ar3 = ar2;
        Object object2 = object;
        p p3 = p2;
        LiteavLog.i("HardwareVideoDecoder", "Start internal");
        if (p3.l != null) {
            LiteavLog.w("HardwareVideoDecoder", "Decoder already started.");
            return;
        }
        p3.h = ar3;
        if (p3.a(object2)) {
            a a2;
            String string = p3.d ? "video/hevc" : "video/avc";
            if (p3.a(string, a2 = new a(0), true) || p3.a(string, a2, false)) {
                p3.g = a2.a;
                p3.c.notifyEvent(e.b.B, "Start decoder success", new Object[0]);
                return;
            }
            p3.a(a2.b, "decoder config fail, message:" + a2.c + " exception:" + a2.d.getMessage(), new Object[0]);
        }
    }

    static /* synthetic */ void a(p p2, VideoDecoderDef.ConsumerScene consumerScene) {
        p2.q = consumerScene;
    }

    static /* synthetic */ void a(p p2) {
        p p3 = p2;
        LiteavLog.i("HardwareVideoDecoder", "Stop internal");
        p3.a();
        if (p3.g != null) {
            com.tencent.liteav.videoconsumer.decoder.p.a(p3.g);
            p3.g = null;
        }
        p p4 = p3;
        for (EncodedVideoFrame encodedVideoFrame : p4.j) {
            if (encodedVideoFrame == null) continue;
            encodedVideoFrame.release();
        }
        p4.j.clear();
        p4 = p3;
        LiteavLog.i("HardwareVideoDecoder", "uninitialize gl components");
        if (p4.b()) {
            if (p4.n != null) {
                p4.n.b();
            }
            if (p4.p != null) {
                p4.p.release();
                p4.p = null;
            }
            if (p4.o != null) {
                p4.o.release();
                p4.o = null;
            }
            OpenGlUtils.deleteTexture(p4.m);
            p4.m = -1;
            try {
                if (p4.l != null) {
                    p4.l.b();
                    p4.l.e();
                }
            }
            catch (f f2) {
                LiteavLog.e("HardwareVideoDecoder", "destroy EGLCore failed.", f2);
            }
            p4.l = null;
        }
        p3.k = true;
    }

    static final class a {
        public MediaCodec a = null;
        public e.c b = null;
        public String c = null;
        public Exception d = null;

        private a() {
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

