/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoconsumer.consumer;

import android.os.HandlerThread;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.b;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.base.TakeSnapshotListener;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.common.SnapshotSourceType;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videoconsumer.consumer.ServerVideoConsumerConfig;
import com.tencent.liteav.videoconsumer.consumer.aa;
import com.tencent.liteav.videoconsumer.consumer.ab;
import com.tencent.liteav.videoconsumer.consumer.i;
import com.tencent.liteav.videoconsumer.consumer.k;
import com.tencent.liteav.videoconsumer.consumer.l;
import com.tencent.liteav.videoconsumer.consumer.m;
import com.tencent.liteav.videoconsumer.consumer.n;
import com.tencent.liteav.videoconsumer.consumer.o;
import com.tencent.liteav.videoconsumer.consumer.p;
import com.tencent.liteav.videoconsumer.consumer.q;
import com.tencent.liteav.videoconsumer.consumer.r;
import com.tencent.liteav.videoconsumer.consumer.s;
import com.tencent.liteav.videoconsumer.consumer.t;
import com.tencent.liteav.videoconsumer.consumer.u;
import com.tencent.liteav.videoconsumer.consumer.v;
import com.tencent.liteav.videoconsumer.consumer.x;
import com.tencent.liteav.videoconsumer.consumer.y;
import com.tencent.liteav.videoconsumer.consumer.z;
import com.tencent.liteav.videoconsumer.decoder.VideoDecodeController;
import com.tencent.liteav.videoconsumer.decoder.VideoDecoderDef;
import com.tencent.liteav.videoconsumer.decoder.b;
import com.tencent.liteav.videoconsumer.renderer.VideoRenderListener;

@JNINamespace(value="liteav::video")
public class VideoConsumerProxy {
    private final i mConsumer;

    @CalledByNative
    public VideoConsumerProxy(@NonNull IVideoReporter reporter) {
        this.mConsumer = new i(reporter);
    }

    @CalledByNative
    public void setServerConfig(ServerVideoConsumerConfig config) {
        i i2 = this.mConsumer;
        ServerVideoConsumerConfig serverVideoConsumerConfig = config;
        i2.a(t.a(i2, serverVideoConsumerConfig), "setServerConfig", true);
    }

    @CalledByNative
    public void start() {
        i i2 = this.mConsumer;
        i2.a(v.a(i2), "Start", false);
    }

    @CalledByNative
    public void stop(boolean isNeedClear) {
        this.mConsumer.a(isNeedClear);
    }

    @CalledByNative
    public void pause() {
        i i2 = this.mConsumer;
        i2.a(x.a(i2), "pause", false);
    }

    @CalledByNative
    public void resume() {
        i i2 = this.mConsumer;
        i2.a(y.a(i2), "resume", false);
    }

    @CalledByNative
    public void appendNALPacket(EncodedVideoFrame packet) {
        EncodedVideoFrame encodedVideoFrame = packet;
        i i2 = this.mConsumer;
        if (encodedVideoFrame == null || encodedVideoFrame.data == null) {
            LiteavLog.w("VideoConsumer", "packet or packet.data is null,packet={%s}", encodedVideoFrame);
            return;
        }
        i i3 = i2;
        i3.a(z.a(i3, encodedVideoFrame), "appendNALPacket", false);
    }

    @CalledByNative
    public void setScene(VideoDecoderDef.ConsumerScene scene) {
        i i2 = this.mConsumer;
        VideoDecoderDef.ConsumerScene consumerScene = scene;
        i2.a(aa.a(i2, consumerScene), "setScene", false);
    }

    @CalledByNative
    public void setRenderMirrorEnabled(boolean enabled) {
        i i2 = this.mConsumer;
        i2.a(ab.a(i2, enabled), "setRenderMirrorEnabled", true);
    }

    @CalledByNative
    public void setRenderRotation(Rotation rotation) {
        i i2 = this.mConsumer;
        Rotation rotation2 = rotation;
        i2.a(k.a(i2, rotation2), "setRenderRotation", true);
    }

    @CalledByNative
    public void setScaleType(GLConstants.GLScaleType scaleType) {
        i i2 = this.mConsumer;
        GLConstants.GLScaleType gLScaleType = scaleType;
        i2.a(l.a(i2, gLScaleType), "setScaleType", true);
    }

    @CalledByNative
    public void setDecoderStrategy(VideoDecodeController.DecodeStrategy decodeStrategy) {
        i i2 = this.mConsumer;
        VideoDecodeController.DecodeStrategy decodeStrategy2 = decodeStrategy;
        i2.a(m.a(i2, decodeStrategy2), "setDecoderType", true);
    }

    @CalledByNative
    public void setDisplayTarget(DisplayTarget target) {
        i i2 = this.mConsumer;
        DisplayTarget displayTarget = target;
        i2.a(n.a(i2, displayTarget), "setDisplayTarget", true);
    }

    @CalledByNative
    public void takeSnapshot(SnapshotSourceType sourceType, TakeSnapshotListener listener) {
        i i2 = this.mConsumer;
        TakeSnapshotListener takeSnapshotListener = listener;
        SnapshotSourceType snapshotSourceType = sourceType;
        i2.a(o.a(i2, snapshotSourceType, takeSnapshotListener), "takeSnapshot", true);
    }

    @CalledByNative
    public void setHWDecoderDeviceRelatedParams(String params) {
        String string = params;
        i i2 = this.mConsumer;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            i i3 = i2;
            i3.a(p.a(i3, string), "setHWDecoderDeviceRelatedParams", true);
        }
    }

    @CalledByNative
    public void setCustomRenderListener(GLConstants.PixelFormatType formatType, GLConstants.PixelBufferType bufferType, VideoRenderListener listener) {
        i i2 = this.mConsumer;
        VideoRenderListener videoRenderListener = listener;
        GLConstants.PixelBufferType pixelBufferType = bufferType;
        GLConstants.PixelFormatType pixelFormatType = formatType;
        i2.a(q.a(i2, pixelFormatType, pixelBufferType, videoRenderListener), "setCustomRenderListener", false);
    }

    @CalledByNative
    public void setSharedEGLContext(Object sharedContext) {
        Object object = sharedContext;
        i i2 = this.mConsumer;
        LiteavLog.i("VideoConsumer", "setSharedEGLContext(object:" + object + ")");
        i i3 = i2;
        i3.a(r.a(i3, object), "setSharedEGLContext", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void initialize() {
        i i2;
        i i3 = i2 = this.mConsumer;
        synchronized (i2) {
            if (i2.a != null) {
                LiteavLog.w("VideoConsumer", "videoConsumer is initialized!");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            LiteavLog.i("VideoConsumer", "initialize videoConsumer");
            HandlerThread handlerThread = new HandlerThread("VideoConsumer_" + i2.hashCode());
            handlerThread.start();
            i2.a = new b(handlerThread.getLooper(), s.a(i2));
            i i4 = i2;
            i4.a(u.a(i4), "initialize", false);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @CalledByNative
    public void uninitialize() {
        i i2 = this.mConsumer;
        i2.a(false);
        i2.a(new Runnable(i2){
            final /* synthetic */ i a;
            {
                this.a = i2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                LiteavLog.i("VideoConsumer", "uninitialize videoConsumer");
                if (this.a.c != null) {
                    this.a.c.a(null, false);
                    this.a.c = null;
                }
                this.a.d = null;
                if (this.a.e != null) {
                    VideoDecodeController videoDecodeController = this.a.e;
                    LiteavLog.i("VideoDecodeController", "uninitialize");
                    VideoDecodeController videoDecodeController2 = videoDecodeController;
                    videoDecodeController2.a(new com.tencent.liteav.videoconsumer.decoder.aa(videoDecodeController2));
                    VideoDecodeController videoDecodeController3 = videoDecodeController;
                    synchronized (videoDecodeController3) {
                        if (videoDecodeController.e != null) {
                            videoDecodeController.e.a();
                            videoDecodeController.e = null;
                        }
                    }
                    this.a.e = null;
                }
                this.a.t = null;
                this.a.h = null;
                this.a.f = null;
                this.a.g = null;
                i.5 var1_5 = this;
                synchronized (var1_5) {
                    if (this.a.a != null) {
                        this.a.a.a();
                        this.a.a = null;
                    }
                    return;
                }
            }
        }, "uninitialize", false);
    }

    @CalledByNative
    public long getCurrentRenderTimeStamp() {
        return this.mConsumer.u.get();
    }

    @CalledByNative
    public static VideoDecoderDef.DecodeAbility getDecodeAbility() {
        return b.a.a().a;
    }
}

