/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.encoder;

import androidx.annotation.NonNull;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.b.f;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.base.TakeSnapshotListener;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.common.b;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.d;
import com.tencent.liteav.videobase.frame.j;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videobase.utils.k;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.a;
import com.tencent.liteav.videobase.videobase.e;
import com.tencent.liteav.videoproducer.encoder.VideoEncodeParams;
import com.tencent.liteav.videoproducer.encoder.VideoEncoderDef;
import com.tencent.liteav.videoproducer.encoder.be;
import com.tencent.liteav.videoproducer.producer.ServerVideoProducerConfig;
import com.tencent.liteav.videoproducer.producer.VideoProducerDef;
import java.nio.ByteBuffer;

@JNINamespace(value="liteav::video")
public class SoftwareVideoEncoder
implements e.a,
be {
    private final String mTAG;
    private final IVideoReporter mReporter;
    private long mNativeEncodeWrapper = 0L;
    private VideoEncodeParams mEncodeParams;
    private be.a mListener;
    private com.tencent.liteav.videobase.b.e mEGLCore;
    private j mPixelFrameRenderer;
    private com.tencent.liteav.videobase.frame.e mGLTexturePool;
    private e mFrameConverter;
    private final k mSnapshotTaker;

    public SoftwareVideoEncoder(@NonNull IVideoReporter reporter, VideoProducerDef.StreamType streamType) {
        this.mReporter = reporter;
        this.mSnapshotTaker = new k("softenc" + this.hashCode());
        this.mTAG = "SoftwareVideoEncoder_" + (Object)((Object)streamType) + "_" + this.hashCode();
    }

    @Override
    public void initialize() {
        this.mNativeEncodeWrapper = SoftwareVideoEncoder.nativeCreate(this);
        LiteavLog.i(this.mTAG, "initialize " + this.mNativeEncodeWrapper);
    }

    @Override
    public void uninitialize() {
        LiteavLog.i(this.mTAG, "uninitialize ");
        SoftwareVideoEncoder.nativeDestroy(this.mNativeEncodeWrapper);
    }

    @Override
    public void setServerConfig(ServerVideoProducerConfig serverConfig) {
    }

    @Override
    public boolean start(VideoEncodeParams params, be.a listener) {
        LiteavLog.i(this.mTAG, "Start: ".concat(String.valueOf(params)));
        com.tencent.liteav.videobase.utils.a.a(params);
        this.mEncodeParams = new VideoEncodeParams(params);
        this.mListener = listener;
        SoftwareVideoEncoder.nativeStart(this.mNativeEncodeWrapper, this.mEncodeParams);
        return true;
    }

    @Override
    public void encodeFrame(PixelFrame frame, Rotation rotation, boolean isMirror) {
        if (frame == null) {
            return;
        }
        if (this.mEGLCore == null && !this.initOpenGLComponents(frame.getGLContext())) {
            return;
        }
        PixelFrame pixelFrame = new PixelFrame(frame);
        pixelFrame.postRotate(rotation);
        if (isMirror) {
            PixelFrame pixelFrame2 = pixelFrame;
            pixelFrame2.setMirrorHorizontal(!pixelFrame2.isMirrorHorizontal());
        }
        try {
            this.mEGLCore.a();
            d d2 = this.mGLTexturePool.a(this.mEncodeParams.getWidth(), this.mEncodeParams.getHeight());
            OpenGlUtils.glViewport(0, 0, d2.b(), d2.c());
            this.mSnapshotTaker.a(pixelFrame);
            this.mPixelFrameRenderer.a(pixelFrame, GLConstants.GLScaleType.a, d2);
            this.mFrameConverter.a(frame.getTimestamp(), d2);
            d2.release();
            return;
        }
        catch (f f2) {
            LiteavLog.e(this.mTAG, "makeCurrent failed.", f2);
            return;
        }
    }

    private boolean initOpenGLComponents(Object sharedContext) {
        if (this.mEncodeParams == null) {
            return false;
        }
        this.mEGLCore = new com.tencent.liteav.videobase.b.e();
        try {
            this.mEGLCore.a(sharedContext, null, 128, 128);
        }
        catch (f f2) {
            this.mEGLCore = null;
            LiteavLog.e(this.mTAG, "initializeEGL failed.", f2);
            return false;
        }
        this.mPixelFrameRenderer = new j(this.mEncodeParams.getWidth(), this.mEncodeParams.getHeight());
        this.mGLTexturePool = new com.tencent.liteav.videobase.frame.e();
        this.mSnapshotTaker.a(this.mGLTexturePool);
        this.mSnapshotTaker.a(this.mEncodeParams.getWidth(), this.mEncodeParams.getHeight());
        this.mFrameConverter = new e();
        this.mFrameConverter.a(this.mGLTexturePool);
        this.mFrameConverter.a(new a(this.mEncodeParams.getWidth(), this.mEncodeParams.getHeight()), GLConstants.PixelBufferType.d, GLConstants.PixelFormatType.a, 0, this);
        return true;
    }

    @Override
    public void signalEndOfStream() {
        LiteavLog.i(this.mTAG, "signalEndOfStream");
        if (this.mListener != null) {
            EncodedVideoFrame encodedVideoFrame = new EncodedVideoFrame();
            this.mListener.onEncodedNAL(encodedVideoFrame, true);
        }
    }

    @Override
    public void stop() {
        LiteavLog.i(this.mTAG, "Stop");
        this.mEncodeParams = null;
        SoftwareVideoEncoder.nativeStop(this.mNativeEncodeWrapper);
        this.uninitializeOpenGLComponents();
    }

    private void uninitializeOpenGLComponents() {
        if (this.mEGLCore == null) {
            return;
        }
        LiteavLog.i(this.mTAG, "uninitializeOpenGLComponents");
        try {
            this.mEGLCore.a();
            this.mFrameConverter.a(0, this);
            this.mFrameConverter.a();
            this.mSnapshotTaker.a();
            if (this.mPixelFrameRenderer != null) {
                this.mPixelFrameRenderer.a();
                this.mPixelFrameRenderer = null;
            }
            if (this.mGLTexturePool != null) {
                this.mGLTexturePool.a();
                this.mGLTexturePool.b();
                this.mGLTexturePool = null;
            }
            this.mEGLCore.e();
        }
        catch (f f2) {
            LiteavLog.e(this.mTAG, "makeCurrent failed.", f2);
        }
        this.mEGLCore = null;
    }

    @Override
    public void setRPSIFrameFPS(int fps) {
        LiteavLog.i(this.mTAG, "setRPSIFrameFPS\uff1afps= %d", fps);
        SoftwareVideoEncoder.nativeSetRpsIdrFps(this.mNativeEncodeWrapper, fps);
    }

    @Override
    public void setRPSNearestREFSize(int referenceSize) {
        LiteavLog.i(this.mTAG, "setRPSNearestREFSize ".concat(String.valueOf(referenceSize)));
        SoftwareVideoEncoder.nativeSetNearestRPS(this.mNativeEncodeWrapper, referenceSize);
    }

    @Override
    public void ackRPSRecvFrameIndex(int ackedFrameId, int bitmap) {
        SoftwareVideoEncoder.nativeSetRPSRefBitmap(this.mNativeEncodeWrapper, ackedFrameId, bitmap);
    }

    @Override
    public void restartIDRFrame() {
        LiteavLog.i(this.mTAG, "restartIDRFrame");
        SoftwareVideoEncoder.nativeRestartIDR(this.mNativeEncodeWrapper);
    }

    @Override
    public void setBitrate(int bitrate) {
        LiteavLog.i(this.mTAG, "SetBitrate: ".concat(String.valueOf(bitrate)));
        SoftwareVideoEncoder.nativeSetBitrate(this.mNativeEncodeWrapper, bitrate);
        this.mEncodeParams.setBitrate(bitrate);
    }

    @Override
    public void setFps(int fps) {
        LiteavLog.i(this.mTAG, "setFps: ".concat(String.valueOf(fps)));
        SoftwareVideoEncoder.nativeSetFps(this.mNativeEncodeWrapper, fps);
        this.mEncodeParams.setFps(fps);
    }

    @Override
    public VideoEncodeParams getEncodeParams() {
        return new VideoEncodeParams(this.mEncodeParams);
    }

    @Override
    public void onFrameConverted(int identity, PixelFrame pixelFrame) {
        if (pixelFrame.getPixelFormatType() != GLConstants.PixelFormatType.a && pixelFrame.getPixelBufferType() != GLConstants.PixelBufferType.b) {
            LiteavLog.i(this.mTAG, "pixelFrame pixelFormat not I420 ");
            return;
        }
        if (this.mNativeEncodeWrapper != 0L) {
            SoftwareVideoEncoder.nativeEncodeFrame(this.mNativeEncodeWrapper, pixelFrame.getData(), pixelFrame.getWidth(), pixelFrame.getHeight(), pixelFrame.getTimestamp());
        }
    }

    @CalledByNative
    private void onEncodedNAL(EncodedVideoFrame nal) {
        if (this.mListener != null) {
            this.mListener.onEncodedNAL(nal, false);
        }
    }

    @CalledByNative
    private void onEncodedError(int errorCode) {
        if (this.mListener != null) {
            this.mListener.a(String.valueOf(errorCode));
        }
    }

    @CalledByNative
    private void onRpsFrameRateChanged(boolean isRpsIDRMode, int idrFps) {
        if (this.mListener != null) {
            this.mListener.a(isRpsIDRMode, idrFps);
        }
    }

    @CalledByNative
    private static EncodedVideoFrame createEncodedVideoFrameCallFromNative(ByteBuffer buffer, int nalType, int profileType, int rotation, long dts, long pts, long nativePtr, int width, int height, long frameIndex, long gopIndex, long refFrameIndex) {
        EncodedVideoFrame encodedVideoFrame = new EncodedVideoFrame();
        new EncodedVideoFrame().nalType = com.tencent.liteav.videobase.common.a.a(nalType);
        encodedVideoFrame.profileType = b.a(profileType);
        encodedVideoFrame.data = buffer;
        encodedVideoFrame.dts = dts;
        encodedVideoFrame.pts = pts;
        encodedVideoFrame.rotation = rotation;
        encodedVideoFrame.frameIndex = frameIndex;
        encodedVideoFrame.gopFrameIndex = 0L;
        encodedVideoFrame.gopIndex = gopIndex;
        encodedVideoFrame.refFrameIndex = refFrameIndex;
        encodedVideoFrame.nativePtr = nativePtr;
        encodedVideoFrame.width = width;
        encodedVideoFrame.height = height;
        return encodedVideoFrame;
    }

    @Override
    public VideoEncoderDef.a getEncoderType() {
        return VideoEncoderDef.a.b;
    }

    @Override
    public void takeSnapshot(TakeSnapshotListener listener) {
        this.mSnapshotTaker.a = listener;
    }

    private static native long nativeCreate(SoftwareVideoEncoder var0);

    private static native void nativeDestroy(long var0);

    private static native int nativeStart(long var0, VideoEncodeParams var2);

    private static native int nativeStop(long var0);

    private static native int nativeEncodeFrame(long var0, byte[] var2, int var3, int var4, long var5);

    private static native void nativeSetBitrate(long var0, int var2);

    private static native void nativeSetFps(long var0, int var2);

    private static native void nativeSetRpsIdrFps(long var0, int var2);

    private static native int nativeSetRPSRefBitmap(long var0, int var2, int var3);

    private static native int nativeSetNearestRPS(long var0, int var2);

    private static native void nativeRestartIDR(long var0);
}

