/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.encoder;

import android.annotation.TargetApi;
import android.media.MediaFormat;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Pair;
import android.view.Surface;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.b;
import com.tencent.liteav.videobase.b.c;
import com.tencent.liteav.videobase.b.f;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.base.TakeSnapshotListener;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.frame.j;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videobase.utils.a;
import com.tencent.liteav.videobase.utils.k;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.g;
import com.tencent.liteav.videoproducer.encoder.VideoEncodeParams;
import com.tencent.liteav.videoproducer.encoder.VideoEncoderDef;
import com.tencent.liteav.videoproducer.encoder.aa;
import com.tencent.liteav.videoproducer.encoder.ab;
import com.tencent.liteav.videoproducer.encoder.ad;
import com.tencent.liteav.videoproducer.encoder.ae;
import com.tencent.liteav.videoproducer.encoder.ag;
import com.tencent.liteav.videoproducer.encoder.be;
import com.tencent.liteav.videoproducer.encoder.p;
import com.tencent.liteav.videoproducer.encoder.q;
import com.tencent.liteav.videoproducer.encoder.r;
import com.tencent.liteav.videoproducer.encoder.s;
import com.tencent.liteav.videoproducer.encoder.t;
import com.tencent.liteav.videoproducer.encoder.w;
import com.tencent.liteav.videoproducer.producer.ServerVideoProducerConfig;
import com.tencent.liteav.videoproducer.producer.VideoProducerDef;
import java.util.concurrent.TimeUnit;

@TargetApi(value=18)
public final class o
implements be,
be.a {
    private final String a;
    @NonNull
    private final IVideoReporter b;
    @NonNull
    private final com.tencent.liteav.base.util.p c = new com.tencent.liteav.base.util.p(0, 0);
    private final w d;
    private Surface e;
    private com.tencent.liteav.videobase.b.e f;
    private j g;
    private VideoEncodeParams h;
    private long i = 0L;
    private volatile Handler j;
    private volatile be.a k;
    private c l;
    private final k m;

    public o(Bundle bundle, @NonNull IVideoReporter iVideoReporter, VideoProducerDef.StreamType streamType) {
        this.d = new w(bundle, iVideoReporter, streamType);
        this.b = iVideoReporter;
        this.m = new k("hwEn" + this.hashCode());
        this.a = "HardwareVideoEncoder_" + (Object)((Object)streamType) + "_" + this.hashCode();
    }

    @Override
    public final void initialize() {
        LiteavLog.d(this.a, "initialize");
        this.j = new Handler(Looper.myLooper() == null ? Looper.getMainLooper() : Looper.myLooper());
        this.l = new c(this.j.getLooper());
        w w2 = this.d;
        LiteavLog.d(w2.a, "initialize");
        HandlerThread handlerThread = new HandlerThread("hw-video-encoder");
        handlerThread.start();
        w2.c = new b(handlerThread.getLooper());
    }

    @Override
    public final void setServerConfig(ServerVideoProducerConfig serverConfig) {
        ServerVideoProducerConfig serverVideoProducerConfig = serverConfig;
        w w2 = this.d;
        w2.c.post(aa.a(w2, serverVideoProducerConfig));
    }

    @Override
    public final boolean start(VideoEncodeParams params, be.a listener) {
        com.tencent.liteav.videobase.utils.a.a(params);
        if (this.e != null) {
            LiteavLog.e(this.a, "Encoder has started");
            return false;
        }
        LiteavLog.i(this.a, "Start hw video encoder. %s", params);
        this.k = listener;
        o o2 = this;
        VideoEncodeParams videoEncodeParams = params;
        w w2 = this.d;
        LiteavLog.d(w2.a, "start");
        Surface[] surfaceArray = new Surface[1];
        boolean bl = w2.c.a(ab.a(w2, o2, surfaceArray, videoEncodeParams), 5000L);
        LiteavLog.i(w2.a, "startCodecInternal success: ".concat(String.valueOf(bl)));
        com.tencent.liteav.base.util.p p2 = new com.tencent.liteav.base.util.p(720, 1280);
        if (w2.f != null) {
            p2.a(w2.f.width, w2.f.height);
        }
        Pair pair = new Pair((Object)surfaceArray[0], (Object)p2);
        this.e = (Surface)pair.first;
        this.c.a((com.tencent.liteav.base.util.p)pair.second);
        this.h = new VideoEncodeParams(params);
        return this.e != null;
    }

    @Override
    public final void encodeFrame(PixelFrame frame, Rotation rotation, boolean isMirror) {
        if (frame == null) {
            return;
        }
        if (!this.l.a(frame.getGLContext())) {
            this.b();
        }
        if (this.f == null && !this.a(frame.getGLContext(), this.e)) {
            return;
        }
        PixelFrame pixelFrame = new PixelFrame(frame);
        pixelFrame.postRotate(rotation);
        if (isMirror) {
            PixelFrame pixelFrame2 = pixelFrame;
            pixelFrame2.setMirrorHorizontal(!pixelFrame2.isMirrorHorizontal());
        }
        try {
            this.f.a();
            this.m.a(pixelFrame);
            if (pixelFrame.getRotation() == Rotation.b || pixelFrame.getRotation() == Rotation.d) {
                PixelFrame pixelFrame3 = pixelFrame;
                pixelFrame3.setMirrorHorizontal(!pixelFrame3.isMirrorHorizontal());
            } else {
                PixelFrame pixelFrame4 = pixelFrame;
                pixelFrame4.setMirrorVertical(!pixelFrame4.isMirrorVertical());
            }
            OpenGlUtils.glViewport(0, 0, this.c.a, this.c.b);
            if (this.g != null) {
                this.g.a(pixelFrame, GLConstants.GLScaleType.a, null);
            }
            this.d.a(frame.getTimestamp());
            if (frame.getTimestamp() < this.i) {
                LiteavLog.e(this.a, "timestamp is not increase. pre: " + this.i + ", cur: " + frame.getTimestamp());
            }
            this.i = frame.getTimestamp();
            long l2 = TimeUnit.MILLISECONDS.toNanos(frame.getTimestamp());
            com.tencent.liteav.videobase.b.e e2 = this.f;
            if (e2.a != null && e2.a instanceof com.tencent.liteav.videobase.b.b) {
                com.tencent.liteav.videobase.b.b b2 = (com.tencent.liteav.videobase.b.b)e2.a;
                EGLExt.eglPresentationTimeANDROID((EGLDisplay)b2.a, (EGLSurface)b2.b, (long)l2);
            }
            this.f.c();
            return;
        }
        catch (f f2) {
            this.b.notifyWarning(g.c.d, "VideoEncode: swapBuffer error, EGLCode:" + f2.mErrorCode + " message:" + f2.getMessage(), new Object[0]);
            this.d.a(f2.getMessage());
            LiteavLog.e(this.a, "makeCurrent failed.", f2);
            return;
        }
    }

    private boolean a(Object object, Surface surface) {
        if (surface == null) {
            LiteavLog.w(this.a, "init opengl: surface is null.");
            return false;
        }
        LiteavLog.d(this.a, "initOpenGLComponents");
        this.f = new com.tencent.liteav.videobase.b.e();
        try {
            this.f.a(object, surface, this.c.a, this.c.b);
        }
        catch (f f2) {
            this.b.notifyWarning(g.c.a, "VideoEncode: create EGLCore failed, EGLCode:" + f2.mErrorCode + " message:" + f2.getMessage(), new Object[0]);
            this.d.a(f2.getMessage());
            LiteavLog.e(this.a, "create EGLCore failed.", f2);
            this.f = null;
            return false;
        }
        this.m.a((e)null);
        this.m.a(this.c.a, this.c.b);
        this.g = new j(this.c.a, this.c.b);
        return true;
    }

    @Override
    public final void signalEndOfStream() {
        w w2 = this.d;
        w2.c.post(ae.a(w2));
    }

    @Override
    public final void stop() {
        LiteavLog.d(this.a, "stop");
        this.b();
        if (this.e != null) {
            this.e.release();
            this.e = null;
        }
        w w2 = this.d;
        LiteavLog.d(w2.a, "stop");
        w2.c.post(ag.a(w2));
        this.k = null;
    }

    private void b() {
        if (this.f == null) {
            return;
        }
        LiteavLog.d(this.a, "uninitOpenGLComponents");
        try {
            this.f.a();
            if (this.g != null) {
                this.g.a();
                this.g = null;
            }
            this.m.a();
            this.f.e();
        }
        catch (f f2) {
            LiteavLog.e(this.a, "makeCurrent failed.", f2);
        }
        this.f = null;
    }

    @Override
    public final void restartIDRFrame() {
    }

    @Override
    public final void setRPSIFrameFPS(int fps) {
    }

    @Override
    public final void setRPSNearestREFSize(int referenceSize) {
    }

    @Override
    public final void ackRPSRecvFrameIndex(int ackedFrameId, int bitmap) {
    }

    @Override
    public final void setBitrate(int bitrate) {
        LiteavLog.i(this.a, "SetBitrate ".concat(String.valueOf(bitrate)));
        if (this.h != null) {
            this.h.bitrate = bitrate;
        }
        w w2 = this.d;
        w2.c.post(ad.a(w2, bitrate));
    }

    @Override
    public final void setFps(int fps) {
    }

    @Override
    public final VideoEncodeParams getEncodeParams() {
        return new VideoEncodeParams(this.h);
    }

    @Override
    public final void uninitialize() {
        LiteavLog.d(this.a, "uninitialize");
        w w2 = this.d;
        LiteavLog.d(w2.a, "uninitialize");
        w2.c.a();
        this.l.a();
        this.j = null;
    }

    @Override
    public final VideoEncoderDef.a getEncoderType() {
        return VideoEncoderDef.a.a;
    }

    @Override
    public final void takeSnapshot(TakeSnapshotListener listener) {
        this.m.a = listener;
    }

    private void a(Runnable runnable) {
        Handler handler = this.j;
        if (handler != null) {
            if (handler.getLooper() == Looper.myLooper()) {
                runnable.run();
                return;
            }
            handler.post(runnable);
        }
    }

    @Override
    public final void a() {
        o o2 = this;
        o2.a(p.a(o2));
    }

    @Override
    public final void a(String string) {
        o o2 = this;
        o2.a(q.a(o2, string));
    }

    @Override
    public final void a(boolean bl, int n2) {
    }

    @Override
    public final void onOutputFormatChanged(MediaFormat format) {
        o o2 = this;
        o2.a(r.a(o2, format));
    }

    @Override
    public final void onEncodedNAL(EncodedVideoFrame nal, boolean isEos) {
        o o2 = this;
        o2.a(s.a(o2, nal, isEos));
    }

    @Override
    public final void onEncodedFail(g.a code) {
        o o2 = this;
        o2.a(t.a(o2, code));
    }

    static /* synthetic */ void a(o o2, g.a a2) {
        be.a a3 = o2.k;
        if (a3 != null) {
            a3.onEncodedFail(a2);
        }
    }

    static /* synthetic */ void a(o o2, EncodedVideoFrame encodedVideoFrame, boolean bl) {
        be.a a2 = o2.k;
        if (a2 != null) {
            a2.onEncodedNAL(encodedVideoFrame, bl);
        }
    }

    static /* synthetic */ void a(o o2, MediaFormat mediaFormat) {
        be.a a2 = o2.k;
        if (a2 != null) {
            a2.onOutputFormatChanged(mediaFormat);
        }
    }

    static /* synthetic */ void a(o o2, String string) {
        be.a a2 = o2.k;
        if (a2 != null) {
            a2.a(string);
        }
    }

    static /* synthetic */ void a(o o2) {
        be.a a2 = o2.k;
        if (a2 != null) {
            a2.a();
        }
    }
}

