/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio.earmonitor;

import com.tencent.liteav.audio.earmonitor.a;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;

@JNINamespace(value="liteav::audio")
public abstract class SystemAudioKit {
    private final long mNativeSystemAudioKit;

    @CalledByNative
    public static SystemAudioKit create(long nativeSystemAudioKit) {
        if (LiteavSystemInfo.getManufacturer().equalsIgnoreCase("huawei")) {
            return new a(nativeSystemAudioKit, ContextUtils.getApplicationContext());
        }
        return null;
    }

    SystemAudioKit(long nativeSystemAudioKit) {
        this.mNativeSystemAudioKit = nativeSystemAudioKit;
    }

    @CalledByNative
    public abstract void initialize();

    @CalledByNative
    public abstract void terminate();

    @CalledByNative
    public abstract void startEarMonitoring();

    @CalledByNative
    public abstract void stopEarMonitoring();

    @CalledByNative
    public abstract void setEarMonitoringVolume(int var1);

    protected void notifyEarMonitoringInitialized(SystemAudioKit audioKit, boolean success) {
        SystemAudioKit.nativeNotifyEarMonitoringInitialized(this.mNativeSystemAudioKit, audioKit, success);
    }

    protected void notifySystemError(SystemAudioKit audioKit) {
        SystemAudioKit.nativeNotifySystemError(this.mNativeSystemAudioKit, audioKit);
    }

    private static native void nativeNotifyEarMonitoringInitialized(long var0, SystemAudioKit var2, boolean var3);

    private static native void nativeNotifySystemError(long var0, SystemAudioKit var2);
}

