/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.live;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.view.Surface;
import com.tencent.liteav.audio.TXAudioEffectManager;
import com.tencent.liteav.audio.TXAudioEffectManagerImpl;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.beauty.TXBeautyManager;
import com.tencent.liteav.beauty.TXBeautyManagerImpl;
import com.tencent.liteav.live.a;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.rtmp.ITXLivePushListener;
import com.tencent.rtmp.TXLivePushConfig;
import com.tencent.rtmp.TXLivePusher;
import com.tencent.rtmp.b;
import com.tencent.rtmp.ui.TXCloudVideoView;
import com.tencent.ugc.TXRecordCommon;
import java.lang.ref.WeakReference;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;

@JNINamespace(value="liteav")
public class TXLivePusherJni
implements ITXLivePushListener,
TXLivePusher.AudioCustomProcessListener,
TXLivePusher.ITXAudioVolumeEvaluationListener,
TXLivePusher.ITXSnapshotListener,
TXLivePusher.OnBGMNotify,
TXLivePusher.VideoCustomProcessListener,
b,
TXCloudVideoView.b {
    private long mNativeTXLivePusherJni = 0L;
    private TXLivePusher.OnBGMNotify mOnBGMNotify;
    private ITXLivePushListener mITXLivePushListener;
    private TXLivePusher.ITXSnapshotListener mITXSnapshotListener;
    private TXRecordCommon.ITXVideoRecordListener mITXVideoRecordListener;
    private TXLivePusher.VideoCustomProcessListener mVideoCustomProcessListener;
    private TXLivePusher.AudioCustomProcessListener mAudioCustomProcessListener;
    private TXLivePusher.ITXAudioVolumeEvaluationListener mITXAudioVolumeEvaluationListener;
    private TXLivePushConfig mConfig;
    private int mVideoQuality = -1;
    private TXAudioEffectManager mAudioEffectManager;
    private TXBeautyManager mBeautyManager;
    private Surface mSurface;
    private int mSurfaceWidth = -1;
    private int mSurfaceHeight = -1;

    public TXLivePusherJni(Context context) {
        ContextUtils.initApplicationContext(context.getApplicationContext());
        ContextUtils.setDataDirectorySuffix("liteav");
        this.mConfig = new TXLivePushConfig();
        this.mNativeTXLivePusherJni = TXLivePusherJni.nativeCreate(new WeakReference<TXLivePusherJni>(this));
        this.mAudioEffectManager = new TXAudioEffectManagerImpl(TXLivePusherJni.nativeCreateAudioEffectManager(this.mNativeTXLivePusherJni));
        this.mBeautyManager = new TXBeautyManagerImpl(TXLivePusherJni.nativeCreateBeautyManager(this.mNativeTXLivePusherJni));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    @Override
    public void release() {
        if (this.mNativeTXLivePusherJni != 0L) {
            TXLivePusherJni.nativeDestroy(this.mNativeTXLivePusherJni);
            this.mNativeTXLivePusherJni = 0L;
        }
    }

    @Override
    public void setPushListener(ITXLivePushListener listener) {
        this.mITXLivePushListener = listener;
    }

    @Override
    public void setVideoProcessListener(TXLivePusher.VideoCustomProcessListener listener) {
        this.mVideoCustomProcessListener = listener;
    }

    @Override
    public void setAudioProcessListener(TXLivePusher.AudioCustomProcessListener listener) {
        this.mAudioCustomProcessListener = listener;
    }

    @Override
    public void setBGMNofify(TXLivePusher.OnBGMNotify notify) {
        this.mOnBGMNotify = notify;
    }

    @Override
    public void setAudioVolumeEvaluationListener(TXLivePusher.ITXAudioVolumeEvaluationListener listener) {
        this.mITXAudioVolumeEvaluationListener = listener;
    }

    @Override
    public void setVideoRecordListener(TXRecordCommon.ITXVideoRecordListener listener) {
        this.mITXVideoRecordListener = listener;
    }

    @Override
    public void setConfig(TXLivePushConfig config) {
        if (config == null) {
            return;
        }
        this.mConfig = config;
        TXLivePusherJni.nativeSetCaptureConfig(this.mNativeTXLivePusherJni, this.mConfig.mCustomModeType, this.mConfig.mLocalVideoMirrorType, this.mConfig.mPauseImg, this.mConfig.mPauseFps, this.mConfig.mFrontCamera, this.mConfig.mTouchFocus, this.mConfig.mEnableZoom, this.mConfig.mEnableScreenCaptureAutoRotate, this.mConfig.mEnableHighResolutionCapture, this.mConfig.mPauseFlag);
        TXLivePusherJni.nativeSetEncoderConfig(this.mNativeTXLivePusherJni, this.mConfig.mHomeOrientation, this.mConfig.mVideoResolution.ordinal(), this.mConfig.mAutoAdjustBitrate, this.mConfig.mVideoBitrate, this.mConfig.mMaxVideoBitrate, this.mConfig.mMinVideoBitrate, this.mConfig.mVideoEncodeGop, this.mConfig.mVideoFPS, this.mConfig.mVideoEncoderXMirror, this.mConfig.mHardwareAccel, this.mConfig.mEnableVideoHardEncoderMainProfile);
        TXLivePusherJni.nativeSetWaterMark(this.mNativeTXLivePusherJni, this.mConfig.mWatermark, this.mConfig.mWatermarkXF, this.mConfig.mWatermarkYF, this.mConfig.mWatermarkWidth);
        TXLivePusherJni.nativeSetAudioConfig(this.mNativeTXLivePusherJni, this.mConfig.mAudioChannels, this.mConfig.mAudioSample, this.mConfig.mVolumeType, this.mConfig.mEnableAudioPreview, this.mConfig.mEnableAns);
        TXLivePusherJni.nativeSetNetworkConfig(this.mNativeTXLivePusherJni, this.mConfig.mAutoAdjustStrategy, this.mConfig.mEnablePureAudioPush, this.mConfig.mConnectRetryCount, this.mConfig.mConnectRetryInterval, this.mConfig.mRtmpChannelType);
    }

    @Override
    public TXLivePushConfig getConfig() {
        return this.mConfig;
    }

    @Override
    public void startCameraPreview(TXCloudVideoView view) {
        if (view != null) {
            a.a(view, new WeakReference<TXCloudVideoView.b>(this));
            TXLivePusherJni.nativeShowDebugView(this.mNativeTXLivePusherJni, a.a(view));
        }
        TXLivePusherJni.nativeSetView(this.mNativeTXLivePusherJni, new DisplayTarget(view));
        TXLivePusherJni.nativeStartCamera(this.mNativeTXLivePusherJni);
    }

    @Override
    public void stopCameraPreview(boolean isNeedClearLastImg) {
        TXLivePusherJni.nativeStopCameraPreview(this.mNativeTXLivePusherJni, isNeedClearLastImg);
    }

    @Override
    public int startPusher(String rtmpURL) {
        return TXLivePusherJni.nativeStartPusher(this.mNativeTXLivePusherJni, rtmpURL);
    }

    @Override
    public void stopPusher() {
        TXLivePusherJni.nativeStopPusher(this.mNativeTXLivePusherJni);
    }

    @Override
    public void startScreenCapture() {
        TXLivePusherJni.nativeStartScreenCapture(this.mNativeTXLivePusherJni);
    }

    @Override
    public void stopScreenCapture() {
        TXLivePusherJni.nativeStopScreenCapture(this.mNativeTXLivePusherJni);
    }

    @Override
    public void pausePusher() {
        TXLivePusherJni.nativePausePusher(this.mNativeTXLivePusherJni);
    }

    @Override
    public void resumePusher() {
        TXLivePusherJni.nativeResumePusher(this.mNativeTXLivePusherJni);
    }

    @Override
    public boolean isPushing() {
        return TXLivePusherJni.nativeIsPushing(this.mNativeTXLivePusherJni);
    }

    @Override
    public void setVideoQuality(int quality, boolean adjustBitrate, boolean adjustResolution) {
        boolean bl = adjustBitrate && adjustResolution;
        this.mVideoQuality = quality;
        this.mConfig.setAudioSampleRate(48000);
        this.mConfig.setHardwareAcceleration(1);
        this.mConfig.setAutoAdjustBitrate(adjustBitrate);
        switch (quality) {
            case 1: {
                this.mConfig.setVideoResolution(0);
                this.mConfig.setAutoAdjustStrategy(adjustResolution ? 1 : 0);
                this.mConfig.setVideoEncodeGop(3);
                if (bl) {
                    this.mConfig.setMinVideoBitrate(301);
                } else {
                    this.mConfig.setMinVideoBitrate(500);
                }
                this.mConfig.setVideoBitrate(800);
                this.mConfig.setMaxVideoBitrate(900);
                break;
            }
            case 2: {
                this.mConfig.setVideoResolution(1);
                this.mConfig.setAutoAdjustStrategy(adjustResolution ? 1 : 0);
                this.mConfig.setVideoEncodeGop(3);
                if (bl) {
                    this.mConfig.setMinVideoBitrate(600);
                } else {
                    this.mConfig.setMinVideoBitrate(800);
                }
                this.mConfig.setVideoBitrate(1200);
                this.mConfig.setMaxVideoBitrate(1500);
                break;
            }
            case 3: {
                this.mConfig.setVideoResolution(2);
                this.mConfig.setAutoAdjustStrategy(adjustResolution ? 1 : 0);
                this.mConfig.setVideoEncodeGop(3);
                if (bl) {
                    this.mConfig.setMinVideoBitrate(600);
                } else {
                    this.mConfig.setMinVideoBitrate(1000);
                }
                this.mConfig.setVideoBitrate(1800);
                this.mConfig.setMaxVideoBitrate(1800);
                break;
            }
            case 7: {
                this.mConfig.setVideoResolution(30);
                this.mConfig.setAutoAdjustStrategy(adjustResolution ? 1 : 0);
                this.mConfig.setVideoEncodeGop(3);
                this.mConfig.setMinVideoBitrate(2500);
                this.mConfig.setVideoBitrate(3000);
                this.mConfig.setMaxVideoBitrate(3000);
                break;
            }
            case 6: {
                this.mConfig.setVideoResolution(0);
                this.mConfig.setAutoAdjustStrategy(5);
                this.mConfig.setVideoEncodeGop(1);
                this.mConfig.setMinVideoBitrate(190);
                this.mConfig.setVideoBitrate(400);
                this.mConfig.setMaxVideoBitrate(810);
                break;
            }
            case 4: {
                if (this.mVideoQuality == 1) {
                    this.mConfig.setVideoResolution(0);
                    this.mConfig.setMinVideoBitrate(500);
                    this.mConfig.setVideoBitrate(800);
                    this.mConfig.setMaxVideoBitrate(900);
                } else if (this.mVideoQuality == 3) {
                    this.mConfig.setVideoResolution(2);
                    this.mConfig.setMinVideoBitrate(1000);
                    this.mConfig.setVideoBitrate(1800);
                    this.mConfig.setMaxVideoBitrate(1800);
                } else if (this.mVideoQuality == 7) {
                    this.mConfig.setVideoResolution(30);
                    this.mConfig.setMinVideoBitrate(2000);
                    this.mConfig.setVideoBitrate(3000);
                    this.mConfig.setMaxVideoBitrate(3000);
                } else {
                    this.mConfig.setVideoResolution(1);
                    this.mConfig.setMinVideoBitrate(800);
                    this.mConfig.setVideoBitrate(1200);
                    this.mConfig.setMaxVideoBitrate(1500);
                }
                this.mConfig.setAutoAdjustStrategy(4);
                this.mConfig.setVideoEncodeGop(1);
                break;
            }
            case 5: {
                this.mConfig.setVideoResolution(6);
                this.mConfig.setMinVideoBitrate(350);
                this.mConfig.setVideoBitrate(350);
                this.mConfig.setMaxVideoBitrate(350);
                this.mConfig.setAutoAdjustStrategy(4);
                this.mConfig.setVideoEncodeGop(1);
                break;
            }
            default: {
                return;
            }
        }
        TXLivePusherJni tXLivePusherJni = this;
        tXLivePusherJni.setConfig(tXLivePusherJni.mConfig);
    }

    @Override
    public void switchCamera() {
        this.mConfig.setFrontCamera(!this.mConfig.mFrontCamera);
        TXLivePusherJni.nativeSwitchCamera(this.mNativeTXLivePusherJni);
    }

    @Override
    public boolean setMirror(boolean enable) {
        return TXLivePusherJni.nativeSetMirror(this.mNativeTXLivePusherJni, enable);
    }

    @Override
    public void setRenderRotation(int rotation) {
        TXLivePusherJni.nativeSetRenderRotation(this.mNativeTXLivePusherJni, rotation);
    }

    @Override
    public boolean turnOnFlashLight(boolean enable) {
        return TXLivePusherJni.nativeTurnOnFlashLight(this.mNativeTXLivePusherJni, enable);
    }

    @Override
    public int getMaxZoom() {
        return TXLivePusherJni.nativeGetMaxZoom(this.mNativeTXLivePusherJni);
    }

    @Override
    public boolean setZoom(int value) {
        return TXLivePusherJni.nativeSetZoom(this.mNativeTXLivePusherJni, value);
    }

    @Override
    public void setExposureCompensation(float value) {
        TXLivePusherJni.nativeSetExposureCompensation(this.mNativeTXLivePusherJni, value);
    }

    @Override
    public TXBeautyManager getBeautyManager() {
        return this.mBeautyManager;
    }

    @Override
    public boolean setBeautyFilter(int style, int beautyLevel, int whiteningLevel, int ruddyLevel) {
        return TXLivePusherJni.nativeSetBeautyFilter(this.mNativeTXLivePusherJni, style, beautyLevel, whiteningLevel, ruddyLevel);
    }

    @Override
    public void setFilter(Bitmap bmp) {
        TXLivePusherJni.nativeSetFilter(this.mNativeTXLivePusherJni, bmp);
    }

    @Override
    public void setSpecialRatio(float ratio) {
        TXLivePusherJni.nativeSetSpecialRatio(this.mNativeTXLivePusherJni, ratio);
    }

    @Override
    public void setEyeScaleLevel(int eyeScaleLevel) {
        this.mBeautyManager.setEyeScaleLevel(eyeScaleLevel);
    }

    @Override
    public void setFaceSlimLevel(int faceSlimLevel) {
        this.mBeautyManager.setFaceSlimLevel(faceSlimLevel);
    }

    @Override
    public void setFaceVLevel(int faceVLevel) {
        this.mBeautyManager.setFaceVLevel(faceVLevel);
    }

    @Override
    public void setChinLevel(int chinLevel) {
        this.mBeautyManager.setChinLevel(chinLevel);
    }

    @Override
    public void setFaceShortLevel(int faceShortLevel) {
        this.mBeautyManager.setFaceShortLevel(faceShortLevel);
    }

    @Override
    public void setNoseSlimLevel(int noseSlimLevel) {
        this.mBeautyManager.setNoseSlimLevel(noseSlimLevel);
    }

    @Override
    public boolean setGreenScreenFile(String file) {
        return this.mBeautyManager.setGreenScreenFile(file) != 0;
    }

    @Override
    public void setMotionTmpl(String motionPath) {
        this.mBeautyManager.setMotionTmpl(motionPath);
    }

    @Override
    public void setMotionMute(boolean motionMute) {
        this.mBeautyManager.setMotionMute(motionMute);
    }

    @Override
    public void setMute(boolean mute) {
        TXLivePusherJni.nativeSetMute(this.mNativeTXLivePusherJni, mute);
    }

    @Override
    public TXAudioEffectManager getAudioEffectManager() {
        return this.mAudioEffectManager;
    }

    @Override
    public void enableAudioVolumeEvaluation(int intervalMs) {
        TXLivePusherJni.nativeEnableAudioVolumeEvaluation(this.mNativeTXLivePusherJni, intervalMs);
    }

    @Override
    public int startRecord(String videoFilePath) {
        return TXLivePusherJni.nativeStartRecord(this.mNativeTXLivePusherJni, videoFilePath);
    }

    @Override
    public void stopRecord() {
        TXLivePusherJni.nativeStopRecord(this.mNativeTXLivePusherJni);
    }

    @Override
    public void snapshot(TXLivePusher.ITXSnapshotListener listener) {
        this.mITXSnapshotListener = listener;
        TXLivePusherJni.nativeSnapshot(this.mNativeTXLivePusherJni);
    }

    @Override
    public int sendCustomVideoTexture(int textureID, int width, int height) {
        PixelFrame pixelFrame = new PixelFrame();
        EGLContext eGLContext = null;
        EGL10 eGL10 = (EGL10)EGLContext.getEGL();
        if (eGL10 != null) {
            eGLContext = eGL10.eglGetCurrentContext();
            pixelFrame.setGLContext(eGLContext);
        }
        if (eGLContext == null) {
            return -1;
        }
        pixelFrame.setPixelFormatType(GLConstants.PixelFormatType.f);
        pixelFrame.setPixelBufferType(GLConstants.PixelBufferType.b);
        pixelFrame.setTextureId(textureID);
        pixelFrame.setWidth(width);
        pixelFrame.setHeight(height);
        TXLivePusherJni.nativeSendCustomVideoFrame(this.mNativeTXLivePusherJni, pixelFrame);
        return 0;
    }

    @Override
    public int sendCustomVideoData(byte[] buffer, int bufferType, int width, int height) {
        PixelFrame pixelFrame = new PixelFrame();
        switch (bufferType) {
            case 3: {
                pixelFrame.setPixelFormatType(GLConstants.PixelFormatType.a);
                break;
            }
            case 5: {
                pixelFrame.setPixelFormatType(GLConstants.PixelFormatType.f);
                break;
            }
            default: {
                return -3;
            }
        }
        pixelFrame.setPixelBufferType(GLConstants.PixelBufferType.d);
        pixelFrame.setData(buffer);
        pixelFrame.setWidth(width);
        pixelFrame.setHeight(height);
        TXLivePusherJni.nativeSendCustomVideoFrame(this.mNativeTXLivePusherJni, pixelFrame);
        return 0;
    }

    @Override
    public void sendCustomPCMData(byte[] pcmBuffer) {
        TXLivePusherJni.nativeSendCustomPCMData(this.mNativeTXLivePusherJni, pcmBuffer);
    }

    @Override
    public void setSurface(Surface surface) {
        if (surface == null) {
            return;
        }
        this.mSurface = surface;
        if (this.mSurfaceWidth >= 0 && this.mSurfaceHeight >= 0) {
            TXLivePusherJni.nativeSetView(this.mNativeTXLivePusherJni, new DisplayTarget(this.mSurface, this.mSurfaceWidth, this.mSurfaceHeight));
        }
    }

    @Override
    public void setSurfaceSize(int width, int height) {
        if (width < 0 || height < 0) {
            return;
        }
        this.mSurfaceWidth = width;
        this.mSurfaceHeight = height;
        if (this.mSurface != null) {
            TXLivePusherJni.nativeSetView(this.mNativeTXLivePusherJni, new DisplayTarget(this.mSurface, this.mSurfaceWidth, this.mSurfaceHeight));
        }
    }

    @Override
    public void setFocusPosition(float x2, float y2) {
        TXLivePusherJni.nativeSetFocusPosition(this.mNativeTXLivePusherJni, x2, y2);
    }

    @Override
    public boolean sendMessageEx(byte[] msg) {
        return TXLivePusherJni.nativeSendMessageEx(this.mNativeTXLivePusherJni, msg);
    }

    @Override
    public void sendMessage(byte[] msg) {
        TXLivePusherJni.nativeSendMessage(this.mNativeTXLivePusherJni, msg);
    }

    @Override
    public void onLogRecord(String str) {
        TXLivePusherJni.nativeOnLogRecord(this.mNativeTXLivePusherJni, str);
    }

    @Override
    public void callExperimentalAPI(String jsonStr) {
        TXLivePusherJni.nativeCallExperimentalAPI(this.mNativeTXLivePusherJni, jsonStr);
    }

    @Override
    public boolean playBGM(String path) {
        return TXLivePusherJni.nativePlayBGM(this.mNativeTXLivePusherJni, path);
    }

    @Override
    public boolean stopBGM() {
        return TXLivePusherJni.nativeStopBGM(this.mNativeTXLivePusherJni);
    }

    @Override
    public boolean pauseBGM() {
        return TXLivePusherJni.nativePauseBGM(this.mNativeTXLivePusherJni);
    }

    @Override
    public boolean resumeBGM() {
        return TXLivePusherJni.nativeResumeBGM(this.mNativeTXLivePusherJni);
    }

    @Override
    public int getMusicDuration(String path) {
        return TXLivePusherJni.nativeGetMusicDuration(this.mNativeTXLivePusherJni, path);
    }

    @Override
    public boolean setBGMVolume(float volume) {
        return TXLivePusherJni.nativeSetBGMVolume(this.mNativeTXLivePusherJni, volume);
    }

    @Override
    public boolean setMicVolume(float volume) {
        return TXLivePusherJni.nativeSetMicVolume(this.mNativeTXLivePusherJni, volume);
    }

    @Override
    public void setBGMPitch(float pitch) {
        TXLivePusherJni.nativeSetBGMPitch(this.mNativeTXLivePusherJni, pitch);
    }

    @Override
    public void setReverb(int reverbType) {
        TXLivePusherJni.nativeSetReverb(this.mNativeTXLivePusherJni, reverbType);
    }

    @Override
    public void setVoiceChangerType(int voiceChangerType) {
        TXLivePusherJni.nativeSetVoiceChangerType(this.mNativeTXLivePusherJni, voiceChangerType);
    }

    @Override
    public boolean setBGMPosition(int position) {
        return TXLivePusherJni.nativeSetBGMPosition(this.mNativeTXLivePusherJni, position);
    }

    @Override
    public void onShowLog(boolean enable) {
        TXLivePusherJni.nativeShowDebugView(this.mNativeTXLivePusherJni, enable);
    }

    @Override
    @CalledByNative
    public void onPushEvent(int event, Bundle param) {
        ITXLivePushListener iTXLivePushListener = this.mITXLivePushListener;
        if (iTXLivePushListener != null) {
            iTXLivePushListener.onPushEvent(event, param);
        }
    }

    @Override
    @CalledByNative
    public void onNetStatus(Bundle status) {
        ITXLivePushListener iTXLivePushListener = this.mITXLivePushListener;
        if (iTXLivePushListener != null) {
            iTXLivePushListener.onNetStatus(status);
        }
    }

    @CalledByNative
    public boolean onCustomPreprocessFrame(PixelFrame srcFrame, PixelFrame dstFrame) {
        int n2 = this.onTextureCustomProcess(srcFrame.getTextureId(), srcFrame.getWidth(), srcFrame.getHeight());
        if (n2 != -1) {
            dstFrame.setTextureId(n2);
            return true;
        }
        return false;
    }

    @Override
    public int onTextureCustomProcess(int textureId, int width, int height) {
        TXLivePusher.VideoCustomProcessListener videoCustomProcessListener = this.mVideoCustomProcessListener;
        if (videoCustomProcessListener != null) {
            return videoCustomProcessListener.onTextureCustomProcess(textureId, width, height);
        }
        return -1;
    }

    @Override
    public void onDetectFacePoints(float[] points) {
        TXLivePusher.VideoCustomProcessListener videoCustomProcessListener = this.mVideoCustomProcessListener;
        if (videoCustomProcessListener != null) {
            videoCustomProcessListener.onDetectFacePoints(points);
        }
    }

    @Override
    @CalledByNative
    public void onTextureDestoryed() {
        TXLivePusher.VideoCustomProcessListener videoCustomProcessListener = this.mVideoCustomProcessListener;
        if (videoCustomProcessListener != null) {
            videoCustomProcessListener.onTextureDestoryed();
        }
    }

    @CalledByNative
    public byte[] onNativeRecordRawPcmData(byte[] data, long ts, int sampleRate, int channels, int bits, boolean withBgm) {
        this.onRecordRawPcmData(data, ts, sampleRate, channels, bits, withBgm);
        return data;
    }

    @Override
    public void onRecordRawPcmData(byte[] data, long ts, int sampleRate, int channels, int bits, boolean withBgm) {
        TXLivePusher.AudioCustomProcessListener audioCustomProcessListener = this.mAudioCustomProcessListener;
        if (audioCustomProcessListener != null) {
            audioCustomProcessListener.onRecordRawPcmData(data, ts, sampleRate, channels, bits, withBgm);
        }
    }

    @CalledByNative
    public byte[] onNativeRecordPcmData(byte[] data, long ts, int sampleRate, int channels, int bits) {
        this.onRecordPcmData(data, ts, sampleRate, channels, bits);
        return data;
    }

    @Override
    public void onRecordPcmData(byte[] data, long ts, int sampleRate, int channels, int bits) {
        TXLivePusher.AudioCustomProcessListener audioCustomProcessListener = this.mAudioCustomProcessListener;
        if (audioCustomProcessListener != null) {
            audioCustomProcessListener.onRecordPcmData(data, ts, sampleRate, channels, bits);
        }
    }

    @Override
    @CalledByNative
    public void onSnapshot(Bitmap bmp) {
        TXLivePusher.ITXSnapshotListener iTXSnapshotListener = this.mITXSnapshotListener;
        if (iTXSnapshotListener != null) {
            iTXSnapshotListener.onSnapshot(bmp);
        }
    }

    @Override
    @CalledByNative
    public void onBGMStart() {
        TXLivePusher.OnBGMNotify onBGMNotify = this.mOnBGMNotify;
        if (onBGMNotify != null) {
            onBGMNotify.onBGMStart();
        }
    }

    @Override
    @CalledByNative
    public void onBGMProgress(long progress, long duration) {
        TXLivePusher.OnBGMNotify onBGMNotify = this.mOnBGMNotify;
        if (onBGMNotify != null) {
            onBGMNotify.onBGMProgress(progress, duration);
        }
    }

    @Override
    @CalledByNative
    public void onBGMComplete(int err) {
        TXLivePusher.OnBGMNotify onBGMNotify = this.mOnBGMNotify;
        if (onBGMNotify != null) {
            onBGMNotify.onBGMComplete(err);
        }
    }

    @Override
    @CalledByNative
    public void onAudioVolumeEvaluationNotify(int volume) {
        TXLivePusher.ITXAudioVolumeEvaluationListener iTXAudioVolumeEvaluationListener = this.mITXAudioVolumeEvaluationListener;
        if (iTXAudioVolumeEvaluationListener != null) {
            iTXAudioVolumeEvaluationListener.onAudioVolumeEvaluationNotify(volume);
        }
    }

    @CalledByNative
    public void onRecordComplete(int errcode, String errmsg, String outputFilePath, String coverImagePath) {
        TXRecordCommon.ITXVideoRecordListener iTXVideoRecordListener = this.mITXVideoRecordListener;
        if (iTXVideoRecordListener != null) {
            TXRecordCommon.TXRecordResult tXRecordResult = new TXRecordCommon.TXRecordResult();
            tXRecordResult.retCode = errcode == 0 ? 0 : -1;
            tXRecordResult.descMsg = errmsg;
            tXRecordResult.videoPath = outputFilePath;
            tXRecordResult.coverPath = coverImagePath;
            iTXVideoRecordListener.onRecordComplete(tXRecordResult);
        }
    }

    @CalledByNative
    public void onRecordProgress(long milliSeconds) {
        TXRecordCommon.ITXVideoRecordListener iTXVideoRecordListener = this.mITXVideoRecordListener;
        if (iTXVideoRecordListener != null) {
            iTXVideoRecordListener.onRecordProgress(milliSeconds);
        }
    }

    @CalledByNative
    public void onRecordEvent(int event, Bundle param) {
        TXRecordCommon.ITXVideoRecordListener iTXVideoRecordListener = this.mITXVideoRecordListener;
        if (iTXVideoRecordListener != null) {
            iTXVideoRecordListener.onRecordEvent(event, param);
        }
    }

    @CalledByNative
    public static TXLivePusherJni weakToStrongReference(WeakReference<TXLivePusherJni> weakReference) {
        return (TXLivePusherJni)weakReference.get();
    }

    private static native long nativeCreate(WeakReference<TXLivePusherJni> var0);

    private static native void nativeDestroy(long var0);

    private static native void nativeSetCaptureConfig(long var0, int var2, int var3, Bitmap var4, int var5, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10, int var11);

    private static native void nativeSetEncoderConfig(long var0, int var2, int var3, boolean var4, int var5, int var6, int var7, int var8, int var9, boolean var10, int var11, boolean var12);

    private static native void nativeSetWaterMark(long var0, Bitmap var2, float var3, float var4, float var5);

    private static native void nativeSetAudioConfig(long var0, int var2, int var3, int var4, boolean var5, boolean var6);

    private static native void nativeSetNetworkConfig(long var0, int var2, boolean var3, int var4, int var5, int var6);

    private static native void nativeSetView(long var0, DisplayTarget var2);

    private static native void nativeStartCamera(long var0);

    private static native void nativeStopCameraPreview(long var0, boolean var2);

    private static native int nativeStartPusher(long var0, String var2);

    private static native void nativeStopPusher(long var0);

    private static native void nativeStartScreenCapture(long var0);

    private static native void nativeStopScreenCapture(long var0);

    private static native void nativePausePusher(long var0);

    private static native void nativeResumePusher(long var0);

    private static native boolean nativeIsPushing(long var0);

    private static native void nativeSwitchCamera(long var0);

    private static native boolean nativeSetMirror(long var0, boolean var2);

    private static native void nativeSetRenderRotation(long var0, int var2);

    private static native boolean nativeTurnOnFlashLight(long var0, boolean var2);

    private static native int nativeGetMaxZoom(long var0);

    private static native boolean nativeSetZoom(long var0, int var2);

    private static native void nativeSetExposureCompensation(long var0, float var2);

    private static native long nativeCreateBeautyManager(long var0);

    private static native boolean nativeSetBeautyFilter(long var0, int var2, int var3, int var4, int var5);

    private static native void nativeSetFilter(long var0, Bitmap var2);

    private static native void nativeSetSpecialRatio(long var0, float var2);

    private static native void nativeSetMute(long var0, boolean var2);

    private static native long nativeCreateAudioEffectManager(long var0);

    private static native void nativeEnableAudioVolumeEvaluation(long var0, int var2);

    private static native int nativeStartRecord(long var0, String var2);

    private static native void nativeStopRecord(long var0);

    private static native void nativeSnapshot(long var0);

    private static native void nativeSendCustomVideoFrame(long var0, PixelFrame var2);

    private static native void nativeSendCustomPCMData(long var0, byte[] var2);

    private static native void nativeSetFocusPosition(long var0, float var2, float var3);

    private static native boolean nativeSendMessageEx(long var0, byte[] var2);

    private static native void nativeSendMessage(long var0, byte[] var2);

    private static native void nativeOnLogRecord(long var0, String var2);

    private static native void nativeCallExperimentalAPI(long var0, String var2);

    private static native boolean nativePlayBGM(long var0, String var2);

    private static native boolean nativeStopBGM(long var0);

    private static native boolean nativePauseBGM(long var0);

    private static native boolean nativeResumeBGM(long var0);

    private static native int nativeGetMusicDuration(long var0, String var2);

    private static native boolean nativeSetBGMVolume(long var0, float var2);

    private static native boolean nativeSetMicVolume(long var0, float var2);

    private static native void nativeSetBGMPitch(long var0, float var2);

    private static native void nativeSetReverb(long var0, int var2);

    private static native void nativeSetVoiceChangerType(long var0, int var2);

    private static native boolean nativeSetBGMPosition(long var0, int var2);

    private static native void nativeShowDebugView(long var0, boolean var2);
}

