/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.live;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.live2.V2TXLiveDef;
import com.tencent.live2.V2TXLivePlayer;
import com.tencent.live2.V2TXLivePlayerObserver;
import com.tencent.live2.impl.V2TXLiveDefInner;
import com.tencent.live2.impl.V2TXLivePlayerImpl;
import com.tencent.live2.impl.a.a;
import com.tencent.rtmp.ui.TXCloudVideoView;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.microedition.khronos.egl.EGLContext;
import org.json.JSONObject;

@JNINamespace(value="liteav")
public class V2TXLivePlayerJni
extends V2TXLivePlayer {
    private static final String TAG = "V2TXLivePlayerJni";
    protected long mNativeV2TXLivePlayerJni = 0L;
    private V2TXLivePlayerImpl mProxy;
    private Boolean mShowDebugView;
    private Boolean mEnableCustomRendering;
    private V2TXLivePlayerObserver mObserver;
    private Surface mSurface;
    private V2TXLiveDefInner.SurfaceSize mSurfaceSize;
    private Boolean mEnableExtensionCallback;
    private DisplayTarget mDisplayTarget;
    private Rotation mRotation;
    private GLConstants.GLScaleType mScaleType;
    private Boolean mIsPauseAudio;
    private Boolean mIsPauseVideo;
    private Integer mVolume;
    private Float mMin;
    private Float mMax;
    private Integer mVolumeIntervalMs;
    private GLConstants.PixelFormatType mPixelFormatType;
    private GLConstants.PixelBufferType mBufferType;
    private Set<Integer> mSEIPayloadSet = new HashSet<Integer>();
    private String mLEBEnv = "";
    private Boolean mEnableHardwareDecode;
    private Integer mRetryInterval;
    private Integer mRetryLimits;
    private Integer mFramework;
    private Integer mComponent;
    private Boolean mEnableRTMPAcc;
    private Integer mAudioRoute;
    private HashMap<String, Object> mPropertyMap = new HashMap();

    public V2TXLivePlayerJni(Context context, V2TXLivePlayerImpl proxy) {
        this.mProxy = proxy;
        ContextUtils.initApplicationContext(context.getApplicationContext());
        ContextUtils.setDataDirectorySuffix("liteav");
    }

    @CalledByNative
    public static V2TXLiveDef.V2TXLivePlayerStatistics getJavaV2TXLivePlayerStatistics(int appCpu, int systemCpu, int width, int height, int fps, int videoBitrate, int audioBitrate) {
        V2TXLiveDef.V2TXLivePlayerStatistics v2TXLivePlayerStatistics = new V2TXLiveDef.V2TXLivePlayerStatistics();
        new V2TXLiveDef.V2TXLivePlayerStatistics().appCpu = appCpu;
        v2TXLivePlayerStatistics.systemCpu = systemCpu;
        v2TXLivePlayerStatistics.width = width;
        v2TXLivePlayerStatistics.height = height;
        v2TXLivePlayerStatistics.fps = fps;
        v2TXLivePlayerStatistics.videoBitrate = videoBitrate;
        v2TXLivePlayerStatistics.audioBitrate = audioBitrate;
        return v2TXLivePlayerStatistics;
    }

    private static native long nativeCreate(WeakReference<V2TXLivePlayerJni> var0);

    private static native void nativeDestroy(long var0);

    private static native void nativeEnableExtensionCallback(long var0, boolean var2);

    private static native int nativeSetRenderView(long var0, DisplayTarget var2);

    private static native int nativeSetRenderRotation(long var0, int var2);

    private static native int nativeSetRenderFillMode(long var0, int var2);

    private static native int nativeStartPlay(long var0, String var2);

    private static native int nativeStopPlay(long var0);

    private static native int nativeIsPlaying(long var0);

    private static native int nativePauseAudio(long var0);

    private static native int nativeResumeAudio(long var0);

    private static native int nativePauseVideo(long var0);

    private static native int nativeResumeVideo(long var0);

    private static native int nativeSetPlayoutVolume(long var0, int var2);

    private static native int nativeSetCacheParams(long var0, float var2, float var3);

    private static native int nativeSwitchStream(long var0, String var2);

    private static native int nativeEnableVolumeEvaluation(long var0, int var2);

    private static native int nativeSnapshot(long var0);

    private static native int nativeEnableCustomRendering(long var0, boolean var2, int var3, int var4);

    private static native int nativeEnableReceiveSeiMessage(long var0, boolean var2, int var3);

    private static native void nativeShowDebugView(long var0, boolean var2);

    private static native void nativeSetLEBEnv(long var0, String var2);

    private static native void nativeEnableHardwareDecode(long var0, boolean var2);

    private static native void nativeSetRetryInterval(long var0, int var2);

    private static native void nativeSetRetryLimits(long var0, int var2);

    private static native void nativeSetFramework(long var0, int var2, int var3);

    private static native void nativeEnableRTMPAcc(long var0, boolean var2);

    private static native void nativeSetAudioRoute(long var0, int var2);

    private static native int nativeSetProperty(long var0, String var2, Object var3);

    @CalledByNative
    public static V2TXLivePlayerJni weakToStrongReference(WeakReference<V2TXLivePlayerJni> weakReference) {
        return (V2TXLivePlayerJni)weakReference.get();
    }

    private boolean isNativeValid() {
        return this.mNativeV2TXLivePlayerJni != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableExtensionCallback(boolean enable) {
        V2TXLivePlayerJni v2TXLivePlayerJni = this;
        synchronized (v2TXLivePlayerJni) {
            this.mEnableExtensionCallback = enable;
            if (this.isNativeValid()) {
                V2TXLivePlayerJni.nativeEnableExtensionCallback(this.mNativeV2TXLivePlayerJni, enable);
            }
            return;
        }
    }

    @Override
    public void setObserver(V2TXLivePlayerObserver observer) {
        this.mObserver = observer;
        if (observer != null && observer instanceof a) {
            this.enableExtensionCallback(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setRenderView(TXCloudVideoView view) {
        V2TXLivePlayerJni v2TXLivePlayerJni = this;
        synchronized (v2TXLivePlayerJni) {
            this.mDisplayTarget = view != null ? new DisplayTarget(view) : null;
            if (this.isNativeValid()) {
                return V2TXLivePlayerJni.nativeSetRenderView(this.mNativeV2TXLivePlayerJni, this.mDisplayTarget);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setRenderView(TextureView view) {
        V2TXLivePlayerJni v2TXLivePlayerJni = this;
        synchronized (v2TXLivePlayerJni) {
            this.mDisplayTarget = view != null ? new DisplayTarget(view) : null;
            if (this.isNativeValid()) {
                return V2TXLivePlayerJni.nativeSetRenderView(this.mNativeV2TXLivePlayerJni, this.mDisplayTarget);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setRenderView(SurfaceView view) {
        V2TXLivePlayerJni v2TXLivePlayerJni = this;
        synchronized (v2TXLivePlayerJni) {
            this.mDisplayTarget = view != null ? new DisplayTarget(view) : null;
            if (this.isNativeValid()) {
                return V2TXLivePlayerJni.nativeSetRenderView(this.mNativeV2TXLivePlayerJni, this.mDisplayTarget);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setRenderRotation(V2TXLiveDef.V2TXLiveRotation liveRotation) {
        V2TXLivePlayerJni v2TXLivePlayerJni = this;
        synchronized (v2TXLivePlayerJni) {
            switch (liveRotation) {
                case V2TXLiveRotation90: {
                    this.mRotation = Rotation.b;
                    break;
                }
                case V2TXLiveRotation180: {
                    this.mRotation = Rotation.c;
                    break;
                }
                case V2TXLiveRotation270: {
                    this.mRotation = Rotation.d;
                    break;
                }
                default: {
                    this.mRotation = Rotation.a;
                }
            }
            if (this.isNativeValid()) {
                return V2TXLivePlayerJni.nativeSetRenderRotation(this.mNativeV2TXLivePlayerJni, this.mRotation.mValue);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setRenderFillMode(V2TXLiveDef.V2TXLiveFillMode mode) {
        V2TXLivePlayerJni v2TXLivePlayerJni = this;
        synchronized (v2TXLivePlayerJni) {
            switch (mode) {
                case V2TXLiveFillModeFill: {
                    this.mScaleType = GLConstants.GLScaleType.a;
                    break;
                }
                case V2TXLiveFillModeScaleFill: {
                    this.mScaleType = GLConstants.GLScaleType.c;
                    break;
                }
                default: {
                    this.mScaleType = GLConstants.GLScaleType.b;
                }
            }
            if (this.isNativeValid()) {
                return V2TXLivePlayerJni.nativeSetRenderFillMode(this.mNativeV2TXLivePlayerJni, this.mScaleType.mValue);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startPlay(String url) {
        V2TXLivePlayerJni v2TXLivePlayerJni = this;
        synchronized (v2TXLivePlayerJni) {
            if (!this.isNativeValid()) {
                this.mNativeV2TXLivePlayerJni = V2TXLivePlayerJni.nativeCreate(new WeakReference<V2TXLivePlayerJni>(this));
                if (this.mShowDebugView != null) {
                    V2TXLivePlayerJni.nativeShowDebugView(this.mNativeV2TXLivePlayerJni, this.mShowDebugView);
                }
                if (this.mEnableExtensionCallback != null) {
                    V2TXLivePlayerJni.nativeEnableExtensionCallback(this.mNativeV2TXLivePlayerJni, this.mEnableExtensionCallback);
                }
                V2TXLivePlayerJni.nativeSetRenderView(this.mNativeV2TXLivePlayerJni, this.mDisplayTarget);
                if (this.mRotation != null) {
                    V2TXLivePlayerJni.nativeSetRenderRotation(this.mNativeV2TXLivePlayerJni, this.mRotation.mValue);
                }
                if (this.mScaleType != null) {
                    V2TXLivePlayerJni.nativeSetRenderFillMode(this.mNativeV2TXLivePlayerJni, this.mScaleType.mValue);
                }
                if (this.mIsPauseAudio != null) {
                    if (this.mIsPauseAudio.booleanValue()) {
                        V2TXLivePlayerJni.nativePauseAudio(this.mNativeV2TXLivePlayerJni);
                    } else {
                        V2TXLivePlayerJni.nativeResumeAudio(this.mNativeV2TXLivePlayerJni);
                    }
                }
                if (this.mIsPauseVideo != null) {
                    if (this.mIsPauseVideo.booleanValue()) {
                        V2TXLivePlayerJni.nativePauseVideo(this.mNativeV2TXLivePlayerJni);
                    } else {
                        V2TXLivePlayerJni.nativeResumeVideo(this.mNativeV2TXLivePlayerJni);
                    }
                }
                if (this.mVolume != null) {
                    V2TXLivePlayerJni.nativeSetPlayoutVolume(this.mNativeV2TXLivePlayerJni, this.mVolume);
                }
                if (this.mMin != null && this.mMax != null) {
                    V2TXLivePlayerJni.nativeSetCacheParams(this.mNativeV2TXLivePlayerJni, this.mMin.floatValue(), this.mMax.floatValue());
                }
                if (this.mVolumeIntervalMs != null) {
                    V2TXLivePlayerJni.nativeEnableVolumeEvaluation(this.mNativeV2TXLivePlayerJni, this.mVolumeIntervalMs);
                }
                if (this.mEnableCustomRendering != null && this.mPixelFormatType != null && this.mBufferType != null) {
                    V2TXLivePlayerJni.nativeEnableCustomRendering(this.mNativeV2TXLivePlayerJni, this.mEnableCustomRendering, this.mPixelFormatType.getValue(), this.mBufferType.ordinal());
                }
                if (this.mSEIPayloadSet.size() > 0) {
                    Iterator<Object> iterator = this.mSEIPayloadSet.iterator();
                    while (iterator.hasNext()) {
                        int n2 = iterator.next();
                        V2TXLivePlayerJni.nativeEnableReceiveSeiMessage(this.mNativeV2TXLivePlayerJni, true, n2);
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)this.mLEBEnv)) {
                    V2TXLivePlayerJni.nativeSetLEBEnv(this.mNativeV2TXLivePlayerJni, this.mLEBEnv);
                }
                if (this.mEnableHardwareDecode != null) {
                    V2TXLivePlayerJni.nativeEnableHardwareDecode(this.mNativeV2TXLivePlayerJni, this.mEnableHardwareDecode);
                }
                if (this.mRetryLimits != null) {
                    V2TXLivePlayerJni.nativeSetRetryLimits(this.mNativeV2TXLivePlayerJni, this.mRetryLimits);
                }
                if (this.mRetryInterval != null) {
                    V2TXLivePlayerJni.nativeSetRetryInterval(this.mNativeV2TXLivePlayerJni, this.mRetryInterval);
                }
                if (this.mFramework != null && this.mComponent != null) {
                    V2TXLivePlayerJni.nativeSetFramework(this.mNativeV2TXLivePlayerJni, this.mFramework, this.mComponent);
                }
                if (this.mEnableRTMPAcc != null) {
                    V2TXLivePlayerJni.nativeEnableRTMPAcc(this.mNativeV2TXLivePlayerJni, this.mEnableRTMPAcc);
                }
                if (this.mAudioRoute != null) {
                    V2TXLivePlayerJni.nativeSetAudioRoute(this.mNativeV2TXLivePlayerJni, this.mAudioRoute);
                }
                for (Map.Entry entry : this.mPropertyMap.entrySet()) {
                    V2TXLivePlayerJni.nativeSetProperty(this.mNativeV2TXLivePlayerJni, (String)entry.getKey(), entry.getValue());
                }
            }
            return V2TXLivePlayerJni.nativeStartPlay(this.mNativeV2TXLivePlayerJni, url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int stopPlay() {
        V2TXLivePlayerJni v2TXLivePlayerJni = this;
        synchronized (v2TXLivePlayerJni) {
            DisplayTarget displayTarget = this.mDisplayTarget;
            if (displayTarget != null) {
                displayTarget.hideAll();
            }
            if (this.isNativeValid()) {
                V2TXLivePlayerJni.nativeStopPlay(this.mNativeV2TXLivePlayerJni);
                V2TXLivePlayerJni.nativeDestroy(this.mNativeV2TXLivePlayerJni);
                this.mNativeV2TXLivePlayerJni = 0L;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int isPlaying() {
        V2TXLivePlayerJni v2TXLivePlayerJni = this;
        synchronized (v2TXLivePlayerJni) {
            if (this.isNativeValid()) {
                return V2TXLivePlayerJni.nativeIsPlaying(this.mNativeV2TXLivePlayerJni);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int pauseAudio() {
        V2TXLivePlayerJni v2TXLivePlayerJni = this;
        synchronized (v2TXLivePlayerJni) {
            this.mIsPauseAudio = Boolean.TRUE;
            if (this.isNativeValid()) {
                return V2TXLivePlayerJni.nativePauseAudio(this.mNativeV2TXLivePlayerJni);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int resumeAudio() {
        V2TXLivePlayerJni v2TXLivePlayerJni = this;
        synchronized (v2TXLivePlayerJni) {
            this.mIsPauseAudio = Boolean.FALSE;
            if (this.isNativeValid()) {
                return V2TXLivePlayerJni.nativeResumeAudio(this.mNativeV2TXLivePlayerJni);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int pauseVideo() {
        V2TXLivePlayerJni v2TXLivePlayerJni = this;
        synchronized (v2TXLivePlayerJni) {
            this.mIsPauseVideo = Boolean.TRUE;
            if (this.isNativeValid()) {
                return V2TXLivePlayerJni.nativePauseVideo(this.mNativeV2TXLivePlayerJni);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int resumeVideo() {
        V2TXLivePlayerJni v2TXLivePlayerJni = this;
        synchronized (v2TXLivePlayerJni) {
            this.mIsPauseVideo = Boolean.FALSE;
            if (this.isNativeValid()) {
                return V2TXLivePlayerJni.nativeResumeVideo(this.mNativeV2TXLivePlayerJni);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setPlayoutVolume(int volume) {
        V2TXLivePlayerJni v2TXLivePlayerJni = this;
        synchronized (v2TXLivePlayerJni) {
            this.mVolume = volume;
            if (this.isNativeValid()) {
                return V2TXLivePlayerJni.nativeSetPlayoutVolume(this.mNativeV2TXLivePlayerJni, volume);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setCacheParams(float min, float max) {
        V2TXLivePlayerJni v2TXLivePlayerJni = this;
        synchronized (v2TXLivePlayerJni) {
            if (min < 0.0f || max < 0.0f) {
                return -2;
            }
            this.mMin = Float.valueOf(min);
            this.mMax = Float.valueOf(max);
            if (this.isNativeValid()) {
                return V2TXLivePlayerJni.nativeSetCacheParams(this.mNativeV2TXLivePlayerJni, min, max);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int switchStream(String newUrl) {
        V2TXLivePlayerJni v2TXLivePlayerJni = this;
        synchronized (v2TXLivePlayerJni) {
            if (TextUtils.isEmpty((CharSequence)newUrl)) {
                LiteavLog.e(TAG, "Invalid params.");
                return -2;
            }
            if (this.isNativeValid()) {
                return V2TXLivePlayerJni.nativeSwitchStream(this.mNativeV2TXLivePlayerJni, newUrl);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int enableVolumeEvaluation(int intervalMs) {
        V2TXLivePlayerJni v2TXLivePlayerJni = this;
        synchronized (v2TXLivePlayerJni) {
            this.mVolumeIntervalMs = intervalMs;
            if (this.isNativeValid()) {
                return V2TXLivePlayerJni.nativeEnableVolumeEvaluation(this.mNativeV2TXLivePlayerJni, intervalMs);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int snapshot() {
        V2TXLivePlayerJni v2TXLivePlayerJni = this;
        synchronized (v2TXLivePlayerJni) {
            if (this.isNativeValid()) {
                return V2TXLivePlayerJni.nativeSnapshot(this.mNativeV2TXLivePlayerJni);
            }
        }
        return -3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int enableObserveVideoFrame(boolean enable, V2TXLiveDef.V2TXLivePixelFormat format, V2TXLiveDef.V2TXLiveBufferType type) {
        V2TXLivePlayerJni v2TXLivePlayerJni = this;
        synchronized (v2TXLivePlayerJni) {
            if (format == V2TXLiveDef.V2TXLivePixelFormat.V2TXLivePixelFormatI420 && type == V2TXLiveDef.V2TXLiveBufferType.V2TXLiveBufferTypeByteArray) {
                this.mPixelFormatType = GLConstants.PixelFormatType.a;
                this.mBufferType = GLConstants.PixelBufferType.d;
            } else if (format == V2TXLiveDef.V2TXLivePixelFormat.V2TXLivePixelFormatTexture2D && type == V2TXLiveDef.V2TXLiveBufferType.V2TXLiveBufferTypeTexture) {
                this.mPixelFormatType = GLConstants.PixelFormatType.f;
                this.mBufferType = GLConstants.PixelBufferType.b;
            } else if (format == V2TXLiveDef.V2TXLivePixelFormat.V2TXLivePixelFormatI420 && type == V2TXLiveDef.V2TXLiveBufferType.V2TXLiveBufferTypeByteBuffer) {
                this.mPixelFormatType = GLConstants.PixelFormatType.a;
                this.mBufferType = GLConstants.PixelBufferType.a;
            } else {
                LiteavLog.e(TAG, "Enable custom render failed, invalid params. format:" + (Object)((Object)format) + " type:" + (Object)((Object)type));
                return -4;
            }
            this.mEnableCustomRendering = enable;
            if (this.isNativeValid()) {
                return V2TXLivePlayerJni.nativeEnableCustomRendering(this.mNativeV2TXLivePlayerJni, enable, this.mPixelFormatType.getValue(), this.mBufferType.ordinal());
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int enableReceiveSeiMessage(boolean enable, int payloadType) {
        V2TXLivePlayerJni v2TXLivePlayerJni = this;
        synchronized (v2TXLivePlayerJni) {
            if (enable) {
                this.mSEIPayloadSet.add(payloadType);
            } else {
                this.mSEIPayloadSet.remove(payloadType);
            }
            if (this.isNativeValid()) {
                return V2TXLivePlayerJni.nativeEnableReceiveSeiMessage(this.mNativeV2TXLivePlayerJni, enable, payloadType);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showDebugView(boolean isShow) {
        V2TXLivePlayerJni v2TXLivePlayerJni = this;
        synchronized (v2TXLivePlayerJni) {
            this.mShowDebugView = isShow;
            if (this.isNativeValid()) {
                V2TXLivePlayerJni.nativeShowDebugView(this.mNativeV2TXLivePlayerJni, isShow);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int setProperty(String key, Object value) {
        V2TXLivePlayerJni v2TXLivePlayerJni = this;
        synchronized (v2TXLivePlayerJni) {
            String string = key;
            int n2 = -1;
            switch (string.hashCode()) {
                case -780243797: {
                    if (!string.equals("enableHardwareAcceleration")) break;
                    n2 = 0;
                    break;
                }
                case 1637676021: {
                    if (!string.equals("maxNumberOfReconnection")) break;
                    n2 = 1;
                    break;
                }
                case 1899639930: {
                    if (!string.equals("secondsBetweenReconnection")) break;
                    n2 = 2;
                    break;
                }
                case -525993788: {
                    if (!string.equals("setHeaders")) break;
                    n2 = 3;
                    break;
                }
                case -1551400628: {
                    if (!string.equals("setLEBEnvironment")) break;
                    n2 = 4;
                    break;
                }
                case 2085561276: {
                    if (!string.equals("setFramework")) break;
                    n2 = 5;
                    break;
                }
                case 1120433643: {
                    if (!string.equals("setSurface")) break;
                    n2 = 6;
                    break;
                }
                case 480042124: {
                    if (!string.equals("setSurfaceSize")) break;
                    n2 = 7;
                    break;
                }
                case 1694085113: {
                    if (!string.equals("enableRTMPAcc")) break;
                    n2 = 8;
                    break;
                }
                case 2013602325: {
                    if (!string.equals("setAudioRoute")) break;
                    n2 = 9;
                    break;
                }
            }
            switch (n2) {
                case 0: {
                    if (!(value instanceof Boolean)) {
                        LiteavLog.e(TAG, "setProperty error, key:" + key + ", value:" + value);
                        return -2;
                    }
                    V2TXLivePlayerJni v2TXLivePlayerJni2 = this;
                    synchronized (v2TXLivePlayerJni2) {
                        this.mEnableHardwareDecode = (Boolean)value;
                        if (!this.isNativeValid()) return 0;
                        V2TXLivePlayerJni.nativeEnableHardwareDecode(this.mNativeV2TXLivePlayerJni, this.mEnableHardwareDecode);
                        break;
                    }
                }
                case 1: {
                    if (!(value instanceof Integer)) {
                        LiteavLog.e(TAG, "setProperty error, key:" + key + ", value:" + value);
                        return -2;
                    }
                    V2TXLivePlayerJni v2TXLivePlayerJni3 = this;
                    synchronized (v2TXLivePlayerJni3) {
                        this.mRetryLimits = (Integer)value;
                        if (!this.isNativeValid()) return 0;
                        V2TXLivePlayerJni.nativeSetRetryLimits(this.mNativeV2TXLivePlayerJni, this.mRetryLimits);
                        break;
                    }
                }
                case 2: {
                    if (!(value instanceof Integer)) {
                        LiteavLog.e(TAG, "setProperty error, key:" + key + ", value:" + value);
                        return -2;
                    }
                    V2TXLivePlayerJni v2TXLivePlayerJni4 = this;
                    synchronized (v2TXLivePlayerJni4) {
                        this.mRetryInterval = (Integer)value;
                        if (!this.isNativeValid()) return 0;
                        V2TXLivePlayerJni.nativeSetRetryInterval(this.mNativeV2TXLivePlayerJni, this.mRetryInterval);
                        break;
                    }
                }
                case 3: {
                    V2TXLivePlayerJni v2TXLivePlayerJni5 = this;
                    synchronized (v2TXLivePlayerJni5) {
                        this.mPropertyMap.put(key, value);
                        if (!this.isNativeValid()) return 0;
                        V2TXLivePlayerJni.nativeSetProperty(this.mNativeV2TXLivePlayerJni, key, value);
                        break;
                    }
                }
                case 4: {
                    if (!(value instanceof String)) {
                        return -2;
                    }
                    String string2 = (String)value;
                    if (TextUtils.isEmpty((CharSequence)string2)) {
                        return -2;
                    }
                    V2TXLivePlayerJni v2TXLivePlayerJni6 = this;
                    synchronized (v2TXLivePlayerJni6) {
                        this.mLEBEnv = string2;
                        if (!this.isNativeValid()) return 0;
                        V2TXLivePlayerJni.nativeSetLEBEnv(this.mNativeV2TXLivePlayerJni, this.mLEBEnv);
                        break;
                    }
                }
                case 5: {
                    if (!(value instanceof String)) {
                        LiteavLog.e(TAG, "setProperty error, key:" + key + ", value:" + value);
                        return -2;
                    }
                    String string3 = (String)value;
                    try {
                        JSONObject jSONObject = new JSONObject(string3);
                        V2TXLivePlayerJni v2TXLivePlayerJni7 = this;
                        synchronized (v2TXLivePlayerJni7) {
                            this.mFramework = jSONObject.optInt("framework", 0);
                            this.mComponent = jSONObject.optInt("component", 0);
                            if (!this.isNativeValid()) return 0;
                            V2TXLivePlayerJni.nativeSetFramework(this.mNativeV2TXLivePlayerJni, this.mFramework, this.mComponent);
                            break;
                        }
                    }
                    catch (Exception exception) {
                        LiteavLog.e(TAG, "setProperty error, key:" + key + ", value:" + value, exception);
                        return -2;
                    }
                }
                case 6: {
                    if (value == null) {
                        V2TXLivePlayerJni v2TXLivePlayerJni8 = this;
                        synchronized (v2TXLivePlayerJni8) {
                            this.mSurface = null;
                            this.mDisplayTarget = null;
                            if (!this.isNativeValid()) return 0;
                            V2TXLivePlayerJni.nativeSetRenderView(this.mNativeV2TXLivePlayerJni, null);
                            return 0;
                        }
                    }
                    if (!(value instanceof Surface)) {
                        LiteavLog.e(TAG, "setProperty error, key:" + key + ", value:" + value);
                        return -2;
                    }
                    V2TXLivePlayerJni v2TXLivePlayerJni9 = this;
                    synchronized (v2TXLivePlayerJni9) {
                        this.mSurface = (Surface)value;
                        if (this.mSurfaceSize == null) return 0;
                        this.mDisplayTarget = new DisplayTarget(this.mSurface, this.mSurfaceSize.width, this.mSurfaceSize.height);
                        if (!this.isNativeValid()) return 0;
                        V2TXLivePlayerJni.nativeSetRenderView(this.mNativeV2TXLivePlayerJni, this.mDisplayTarget);
                        break;
                    }
                }
                case 7: {
                    if (value == null) {
                        this.mSurfaceSize = null;
                        return 0;
                    }
                    if (!(value instanceof V2TXLiveDefInner.SurfaceSize)) {
                        LiteavLog.e(TAG, "setProperty error, key:" + key + ", value:" + value);
                        return -2;
                    }
                    V2TXLivePlayerJni v2TXLivePlayerJni10 = this;
                    synchronized (v2TXLivePlayerJni10) {
                        this.mSurfaceSize = (V2TXLiveDefInner.SurfaceSize)value;
                        if (this.mSurface == null) return 0;
                        this.mDisplayTarget = new DisplayTarget(this.mSurface, this.mSurfaceSize.width, this.mSurfaceSize.height);
                        if (!this.isNativeValid()) return 0;
                        V2TXLivePlayerJni.nativeSetRenderView(this.mNativeV2TXLivePlayerJni, this.mDisplayTarget);
                        break;
                    }
                }
                case 8: {
                    if (!(value instanceof Boolean)) {
                        LiteavLog.e(TAG, "setProperty error, key:" + key + ", value:" + value);
                        return -2;
                    }
                    V2TXLivePlayerJni v2TXLivePlayerJni11 = this;
                    synchronized (v2TXLivePlayerJni11) {
                        this.mEnableRTMPAcc = (Boolean)value;
                        if (!this.isNativeValid()) return 0;
                        V2TXLivePlayerJni.nativeEnableRTMPAcc(this.mNativeV2TXLivePlayerJni, this.mEnableRTMPAcc);
                        break;
                    }
                }
                case 9: {
                    if (!(value instanceof Integer)) {
                        LiteavLog.e(TAG, "setProperty error, key:" + key + ", value:" + value);
                        return -2;
                    }
                    V2TXLivePlayerJni v2TXLivePlayerJni12 = this;
                    synchronized (v2TXLivePlayerJni12) {
                        this.mAudioRoute = (Integer)value;
                        if (!this.isNativeValid()) return 0;
                        V2TXLivePlayerJni.nativeSetAudioRoute(this.mNativeV2TXLivePlayerJni, this.mAudioRoute);
                        break;
                    }
                }
                default: {
                    LiteavLog.e(TAG, "setProperty error, key:" + key + ", value:" + value);
                    return -4;
                }
            }
            return 0;
        }
    }

    @CalledByNative
    public void onError(int code, String msg, Bundle extraInfo) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onError(this.mProxy, code, msg, extraInfo);
        }
    }

    @CalledByNative
    public void onWarning(int code, String msg, Bundle extraInfo) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onWarning(this.mProxy, code, msg, extraInfo);
        }
    }

    @CalledByNative
    public void onVideoResolutionChanged(int width, int height) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onVideoResolutionChanged(this.mProxy, width, height);
        }
    }

    @CalledByNative
    public void onConnected(Bundle bundle) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onConnected(this.mProxy, bundle);
        }
    }

    @CalledByNative
    public void onVideoPlaying(boolean firstPlay, Bundle extraInfo) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onVideoPlaying(this.mProxy, firstPlay, extraInfo);
        }
    }

    @CalledByNative
    public void onAudioPlaying(boolean firstPlay, Bundle extraInfo) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onAudioPlaying(this.mProxy, firstPlay, extraInfo);
        }
    }

    @CalledByNative
    public void onVideoLoading(Bundle extraInfo) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onVideoLoading(this.mProxy, extraInfo);
        }
    }

    @CalledByNative
    public void onAudioLoading(Bundle extraInfo) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onAudioLoading(this.mProxy, extraInfo);
        }
    }

    @CalledByNative
    public void onPlayoutVolumeUpdate(int volume) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onPlayoutVolumeUpdate(this.mProxy, volume);
        }
    }

    @CalledByNative
    public void onStatisticsUpdate(V2TXLiveDef.V2TXLivePlayerStatistics statistics) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onStatisticsUpdate(this.mProxy, statistics);
        }
    }

    @CalledByNative
    public void onSnapshotComplete(Bitmap image) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onSnapshotComplete(this.mProxy, image);
        }
    }

    @CalledByNative
    public void onRenderVideoFrame(PixelFrame pixelFrame) {
        V2TXLiveDef.V2TXLiveVideoFrame v2TXLiveVideoFrame = new V2TXLiveDef.V2TXLiveVideoFrame();
        switch (pixelFrame.getPixelFormatType()) {
            case a: {
                v2TXLiveVideoFrame.pixelFormat = V2TXLiveDef.V2TXLivePixelFormat.V2TXLivePixelFormatI420;
                break;
            }
            case f: {
                v2TXLiveVideoFrame.pixelFormat = V2TXLiveDef.V2TXLivePixelFormat.V2TXLivePixelFormatTexture2D;
                break;
            }
            default: {
                LiteavLog.e(TAG, "Invalid pixelFormat. pixelFormat:" + (Object)((Object)pixelFrame.getPixelFormatType()) + ".");
            }
        }
        switch (pixelFrame.getPixelBufferType()) {
            case a: {
                v2TXLiveVideoFrame.bufferType = V2TXLiveDef.V2TXLiveBufferType.V2TXLiveBufferTypeByteBuffer;
                break;
            }
            case d: {
                v2TXLiveVideoFrame.bufferType = V2TXLiveDef.V2TXLiveBufferType.V2TXLiveBufferTypeByteArray;
                break;
            }
            case b: {
                v2TXLiveVideoFrame.bufferType = V2TXLiveDef.V2TXLiveBufferType.V2TXLiveBufferTypeTexture;
                break;
            }
            default: {
                LiteavLog.e(TAG, "Invalid bufferType. bufferType:" + (Object)((Object)pixelFrame.getPixelBufferType()) + ".");
            }
        }
        V2TXLiveDef.V2TXLiveTexture v2TXLiveTexture = new V2TXLiveDef.V2TXLiveTexture();
        new V2TXLiveDef.V2TXLiveTexture().textureId = pixelFrame.getTextureId();
        if (pixelFrame.getGLContext() instanceof EGLContext) {
            v2TXLiveTexture.eglContext10 = (EGLContext)pixelFrame.getGLContext();
        } else if (Build.VERSION.SDK_INT >= 17 && pixelFrame.getGLContext() instanceof android.opengl.EGLContext) {
            v2TXLiveTexture.eglContext14 = (android.opengl.EGLContext)pixelFrame.getGLContext();
        }
        v2TXLiveVideoFrame.texture = v2TXLiveTexture;
        v2TXLiveVideoFrame.data = pixelFrame.getData();
        v2TXLiveVideoFrame.buffer = pixelFrame.getBuffer();
        v2TXLiveVideoFrame.width = pixelFrame.getWidth();
        v2TXLiveVideoFrame.height = pixelFrame.getHeight();
        switch (pixelFrame.getRotation()) {
            case a: {
                v2TXLiveVideoFrame.rotation = 0;
                break;
            }
            case b: {
                v2TXLiveVideoFrame.rotation = 90;
                break;
            }
            case c: {
                v2TXLiveVideoFrame.rotation = 180;
                break;
            }
            case d: {
                v2TXLiveVideoFrame.rotation = 270;
                break;
            }
            default: {
                v2TXLiveVideoFrame.rotation = 0;
            }
        }
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onRenderVideoFrame(this.mProxy, v2TXLiveVideoFrame);
        }
    }

    @CalledByNative
    public void onReceiveSeiMessage(int payloadType, byte[] data) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onReceiveSeiMessage(this.mProxy, payloadType, data);
        }
    }

    @CalledByNative
    public void onPlayEvent(int code, Bundle params) {
    }

    @CalledByNative
    public void onPlayNetStatus(Bundle params) {
    }

    @CalledByNative
    public void onNetworkQuality(int quality) {
    }
}

