/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoconsumer.decoder;

import android.graphics.SurfaceTexture;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.HandlerThread;
import android.os.Looper;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.b;
import com.tencent.liteav.videobase.b.f;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.common.CodecType;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.d;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.frame.j;
import com.tencent.liteav.videobase.frame.k;
import com.tencent.liteav.videobase.frame.l;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.g;
import com.tencent.liteav.videoconsumer.consumer.ServerVideoConsumerConfig;
import com.tencent.liteav.videoconsumer.decoder.VideoDecoderDef;
import com.tencent.liteav.videoconsumer.decoder.as;
import com.tencent.liteav.videoconsumer.decoder.at;
import com.tencent.liteav.videoconsumer.decoder.p;
import com.tencent.liteav.videoconsumer.decoder.r;
import com.tencent.liteav.videoconsumer.decoder.s;
import com.tencent.liteav.videoconsumer.decoder.t;
import com.tencent.liteav.videoconsumer.decoder.u;
import com.tencent.liteav.videoconsumer.decoder.v;
import com.tencent.liteav.videoconsumer.decoder.w;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class q
implements SurfaceTexture.OnFrameAvailableListener,
as {
    private static final EncodedVideoFrame a = new EncodedVideoFrame();
    @NonNull
    private final com.tencent.liteav.base.util.p b = new com.tencent.liteav.base.util.p();
    @NonNull
    private final IVideoReporter c;
    private final JSONArray d;
    private volatile b e;
    private MediaCodec f = null;
    private at g;
    private final MediaCodec.BufferInfo h = new MediaCodec.BufferInfo();
    private final Deque<EncodedVideoFrame> i = new LinkedList<EncodedVideoFrame>();
    private boolean j = true;
    private com.tencent.liteav.videobase.b.e k;
    private int l = -1;
    private l m;
    private SurfaceTexture n;
    private Surface o;
    private VideoDecoderDef.ConsumerScene p = VideoDecoderDef.ConsumerScene.a;
    private boolean q = false;
    private p r = new p();
    private boolean s = false;
    private com.tencent.liteav.base.util.t t;
    private MediaFormat u;
    private j v;
    private e w;
    private boolean x;

    public q(@NonNull com.tencent.liteav.base.util.p p2, boolean bl, boolean bl2, @Nullable JSONArray jSONArray, @NonNull IVideoReporter iVideoReporter) {
        this(MediaFormat.createVideoFormat((String)(bl ? "video/hevc" : "video/avc"), (int)p2.a, (int)p2.b), bl2, jSONArray, iVideoReporter);
    }

    public q(@NonNull MediaFormat mediaFormat, boolean bl, @Nullable JSONArray jSONArray, @NonNull IVideoReporter iVideoReporter) {
        this.b.a = mediaFormat.getInteger("width");
        this.b.b = mediaFormat.getInteger("height");
        this.u = mediaFormat;
        this.c = iVideoReporter;
        this.d = jSONArray;
        this.x = bl;
        LiteavLog.i("HardwareVideoDecoder", "create decoder isLowLatencyEnabled:" + this.x + ", format: " + this.u + " , params: " + jSONArray);
    }

    @Override
    public final void initialize() {
        HandlerThread handlerThread = new HandlerThread("HardwareVideoDecoder_" + this.hashCode());
        handlerThread.start();
        this.e = new b(handlerThread.getLooper());
    }

    @Override
    public final void uninitialize() {
        if (this.e != null) {
            this.e.a();
        }
    }

    @Override
    public final void setScene(VideoDecoderDef.ConsumerScene scene) {
        q q2 = this;
        q2.a(com.tencent.liteav.videoconsumer.decoder.r.a(q2, scene));
    }

    @Override
    public final void start(Object glContext, at listener) {
        q q2 = this;
        q2.a(com.tencent.liteav.videoconsumer.decoder.s.a(q2, glContext, listener));
    }

    private boolean a(Object object) {
        this.k = new com.tencent.liteav.videobase.b.e();
        try {
            this.k.a(object, null, 128, 128);
            this.k.a();
        }
        catch (f f2) {
            LiteavLog.e("HardwareVideoDecoder", "create EGLCore failed.", f2);
            this.a(g.c.h, "VideoDecode: create EGLCore failed errorCode:" + f2.mErrorCode, new Object[0]);
            return false;
        }
        this.l = OpenGlUtils.generateTextureOES();
        this.m = new l();
        try {
            this.n = new SurfaceTexture(this.l);
            this.o = new Surface(this.n);
            this.n.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        }
        catch (Surface.OutOfResourcesException outOfResourcesException) {
            LiteavLog.e("HardwareVideoDecoder", "create SurfaceTexture failed.", outOfResourcesException);
            this.a(g.c.k, "VideoDecode: insufficient resource, Start decoder failed:" + outOfResourcesException.getMessage(), new Object[0]);
            return false;
        }
        LiteavLog.i("HardwareVideoDecoder", "initialize gl components");
        return true;
    }

    private boolean a(a a2, boolean bl, MediaFormat mediaFormat) {
        MediaFormat mediaFormat2;
        if (bl) {
            mediaFormat2 = mediaFormat;
            if (LiteavSystemInfo.getSystemOSVersionInt() >= 30) {
                mediaFormat2.setInteger("low-latency", 1);
            }
            if (LiteavSystemInfo.getSystemOSVersionInt() >= 26 && LiteavSystemInfo.getHardware().toLowerCase().contains("qcom")) {
                mediaFormat2.setInteger("vendor.qti-ext-dec-low-latency.enable", 1);
                mediaFormat2.setInteger("vendor.qti-ext-dec-picture-order.enable", 1);
            } else if (LiteavSystemInfo.getSystemOSVersionInt() >= 29 && LiteavSystemInfo.getHardware().toLowerCase().contains("kirin")) {
                mediaFormat2.setInteger("vendor.hisi-ext-low-latency-video-dec.video-scene-for-low-latency-req", 1);
                mediaFormat2.setInteger("vendor.hisi-ext-low-latency-video-dec.video-scene-for-low-latency-rdy", -1);
            } else if (LiteavSystemInfo.getSystemOSVersionInt() >= 26 && LiteavSystemInfo.getHardware().toLowerCase().contains("exynos")) {
                mediaFormat2.setInteger("vendor.rtc-ext-dec-low-latency.enable", 1);
            }
        }
        JSONArray jSONArray = this.d;
        mediaFormat2 = mediaFormat;
        if (jSONArray != null) {
            try {
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    JSONObject jSONObject = jSONArray.getJSONObject(i2);
                    mediaFormat2.setInteger(jSONObject.optString("key"), jSONObject.optInt("value"));
                }
            }
            catch (JSONException jSONException) {
                LiteavLog.e("HardwareVideoDecoder", "set MediaCodec device related params failed.", jSONException);
            }
        }
        LiteavLog.i("HardwareVideoDecoder", String.valueOf(mediaFormat));
        try {
            String string = mediaFormat.getString("mime");
            a2.a = MediaCodec.createDecoderByType((String)string);
            a2.a.configure(mediaFormat, this.o, null, 0);
            a2.a.setVideoScalingMode(1);
            a2.a.start();
            LiteavLog.i("HardwareVideoDecoder", "Start MediaCodec success.");
            return true;
        }
        catch (Exception exception) {
            LiteavLog.e("HardwareVideoDecoder", "Start MediaCodec failed.", exception);
            com.tencent.liteav.videoconsumer.decoder.q.a(a2.a);
            a2.a = null;
            g.c c2 = g.c.m;
            String string = "VideoDecode: Start decoder failed";
            if (exception instanceof IllegalArgumentException) {
                c2 = g.c.i;
                string = "VideoDecode: illegal argument, Start decoder failed";
            } else if (exception instanceof IllegalStateException) {
                c2 = g.c.j;
                string = "VideoDecode: illegal state, Start decoder failed";
            }
            a2.b = c2;
            a2.c = string;
            a2.d = exception;
            return false;
        }
    }

    /*
     * Loose catch block
     */
    private static void a(MediaCodec mediaCodec) {
        if (mediaCodec != null) {
            mediaCodec.stop();
            try {
                mediaCodec.release();
                return;
            }
            catch (Exception exception) {
                LiteavLog.e("HardwareVideoDecoder", "release MediaCodec failed.", exception);
                return;
            }
            catch (Exception exception) {
                try {
                    LiteavLog.e("HardwareVideoDecoder", "Stop MediaCodec failed." + exception.getMessage());
                }
                catch (Throwable throwable) {
                    try {
                        mediaCodec.release();
                    }
                    catch (Exception exception2) {
                        LiteavLog.e("HardwareVideoDecoder", "release MediaCodec failed.", exception2);
                    }
                    throw throwable;
                }
                try {
                    mediaCodec.release();
                    return;
                }
                catch (Exception exception3) {
                    LiteavLog.e("HardwareVideoDecoder", "release MediaCodec failed.", exception3);
                    return;
                }
            }
        }
    }

    @Override
    public final void decode(EncodedVideoFrame frame) {
        q q2 = this;
        q2.a(com.tencent.liteav.videoconsumer.decoder.t.a(q2, frame));
    }

    @Override
    public final void stop() {
        q q2 = this;
        q2.a(com.tencent.liteav.videoconsumer.decoder.u.a(q2));
    }

    @Override
    public final as.a getDecoderType() {
        return as.a.b;
    }

    @Override
    public final void setServerConfig(ServerVideoConsumerConfig config) {
        q q2 = this;
        q2.a(com.tencent.liteav.videoconsumer.decoder.v.a(q2, config));
    }

    private void a() {
        if (this.t != null) {
            LiteavLog.i("HardwareVideoDecoder", "stopEosTimer");
            this.t.a();
            this.t = null;
        }
    }

    public final void onFrameAvailable(SurfaceTexture surfaceTexture) {
        q q2 = this;
        q2.a(com.tencent.liteav.videoconsumer.decoder.w.a(q2, surfaceTexture));
    }

    private PixelFrame a(PixelFrame pixelFrame) {
        Object object;
        int n2 = pixelFrame.getWidth();
        int n3 = pixelFrame.getHeight();
        if (this.v != null) {
            j j2 = this.v;
            object = new com.tencent.liteav.base.util.p(j2.a, j2.b);
            if (((com.tencent.liteav.base.util.p)object).a != n2 || ((com.tencent.liteav.base.util.p)object).b != n3) {
                this.v.a();
                this.v = null;
            }
        }
        if (this.v == null) {
            this.v = new j(n2, n3);
        }
        if (this.w == null) {
            this.w = new e();
        }
        OpenGlUtils.glViewport(0, 0, n2, n3);
        object = this.w.a(n2, n3);
        this.v.a(pixelFrame, GLConstants.GLScaleType.a, (d)object);
        PixelFrame pixelFrame2 = ((d)object).a(this.k.d());
        GLES20.glFinish();
        ((k)object).release();
        pixelFrame.release();
        return pixelFrame2;
    }

    private boolean b() {
        try {
            if (this.k != null) {
                this.k.a();
            }
            return true;
        }
        catch (f f2) {
            LiteavLog.e("HardwareVideoDecoder", "makeCurrent failed.", f2);
            return false;
        }
    }

    private void a(g.c c2, String string, Object ... objectArray) {
        this.c.notifyWarning(c2, string, objectArray);
        if (this.g != null) {
            this.g.a();
        }
    }

    private void a(Runnable runnable) {
        b b2 = this.e;
        if (b2 != null) {
            if (b2.getLooper() == Looper.myLooper()) {
                runnable.run();
                return;
            }
            b2.post(runnable);
        }
    }

    static /* synthetic */ void a(q q2, SurfaceTexture surfaceTexture) {
        if (q2.n == null || surfaceTexture != q2.n) {
            LiteavLog.i("HardwareVideoDecoder", "mSurfaceTexture= " + q2.n + " ,surfaceTexture= " + surfaceTexture);
            return;
        }
        q2.b();
        l.b b2 = null;
        try {
            b2 = (l.b)q2.m.a();
        }
        catch (InterruptedException interruptedException) {
            LiteavLog.w("HardwareVideoDecoder", "textureholderpool obtain interrupted.");
        }
        b2.a(36197, q2.l, q2.b.a, q2.b.b);
        PixelFrame pixelFrame = b2.a(q2.k.d());
        if (pixelFrame.getMatrix() == null) {
            pixelFrame.setMatrix(new float[16]);
        }
        try {
            surfaceTexture.updateTexImage();
            surfaceTexture.getTransformMatrix(pixelFrame.getMatrix());
        }
        catch (Exception exception) {
            LiteavLog.w("HardwareVideoDecoder", "updateTexImage exception: ".concat(String.valueOf(exception)));
        }
        q2.j = true;
        long l2 = TimeUnit.NANOSECONDS.toMillis(surfaceTexture.getTimestamp());
        if (l2 == 0L) {
            l2 = TimeUnit.MICROSECONDS.toMillis(q2.h.presentationTimeUs);
        }
        if (LiteavSystemInfo.getSystemOSVersionInt() <= 22) {
            pixelFrame = q2.a(pixelFrame);
        }
        pixelFrame.setTimestamp(l2);
        q2.g.a(pixelFrame, l2);
        b2.release();
        pixelFrame.release();
        if (q2.s) {
            q q3 = q2;
            if (q3.g != null) {
                q3.g.c();
            }
            q2.s = false;
        }
    }

    static /* synthetic */ void a(q q2, ServerVideoConsumerConfig serverVideoConsumerConfig) {
        if (serverVideoConsumerConfig == null) {
            return;
        }
        q2.q = serverVideoConsumerConfig.enableVui;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static /* synthetic */ void a(q q2, EncodedVideoFrame encodedVideoFrame) {
        EncodedVideoFrame encodedVideoFrame2 = encodedVideoFrame;
        q q3 = q2;
        q3.a();
        if (encodedVideoFrame2 != null) {
            q3.i.addLast(encodedVideoFrame2);
        }
        q q4 = q3;
        if (q4.f == null) {
            LiteavLog.w("HardwareVideoDecoder", "MediaCodec is stopped.");
            return;
        }
        try {
            MediaFormat mediaFormat;
            int n2;
            q q5;
            while (q4.j) {
                boolean bl;
                block37: {
                    q5 = q4;
                    for (int i2 = 0; i2 < 3 && (n2 = q5.f.dequeueOutputBuffer(q5.h, TimeUnit.MILLISECONDS.toMicros(10L))) != -1; ++i2) {
                        if (n2 == -3) {
                            LiteavLog.i("HardwareVideoDecoder", "on output buffers changed");
                            continue;
                        }
                        if (n2 == -2) {
                            mediaFormat = q5.f.getOutputFormat();
                            LiteavLog.i("HardwareVideoDecoder", "decode output format changed: ".concat(String.valueOf(mediaFormat)));
                            int n3 = Math.abs(mediaFormat.getInteger("crop-right") - mediaFormat.getInteger("crop-left")) + 1;
                            int n4 = Math.abs(mediaFormat.getInteger("crop-bottom") - mediaFormat.getInteger("crop-top")) + 1;
                            int n5 = mediaFormat.getInteger("width");
                            int n6 = mediaFormat.getInteger("height");
                            LiteavLog.i("HardwareVideoDecoder", "cropWidth: %d, cropHeight: %d, frameWidth: %d, frameHeight: %d", n3, n4, n5, n6);
                            continue;
                        }
                        if (n2 >= 0) {
                            q5.j = false;
                            q5.f.releaseOutputBuffer(n2, true);
                            if ((q5.h.flags & 4) != 0) {
                                LiteavLog.i("HardwareVideoDecoder", "meet end of stream.");
                                q5.a();
                                q q6 = q5;
                                if (q6.g != null) {
                                    q6.g.e();
                                }
                                q5.j = true;
                            }
                            bl = true;
                            break block37;
                        }
                        LiteavLog.d("HardwareVideoDecoder", "dequeueOutputBuffer get invalid index: %d", n2);
                        break;
                    }
                    bl = false;
                }
                if (bl) continue;
            }
            while (!q4.i.isEmpty()) {
                EncodedVideoFrame encodedVideoFrame3 = q4.i.peekFirst();
                if (encodedVideoFrame3 == null || encodedVideoFrame3 != a && (encodedVideoFrame3.data == null || encodedVideoFrame3.data.remaining() == 0)) {
                    LiteavLog.w("HardwareVideoDecoder", "receive empty buffer.");
                } else {
                    MediaFormat mediaFormat2;
                    mediaFormat = mediaFormat2 = q5.f.getInputBuffers();
                    if (mediaFormat2 == null || ((ByteBuffer[])mediaFormat).length == 0) {
                        LiteavLog.e("HardwareVideoDecoder", "get invalid input buffers.");
                        return;
                    }
                    n2 = q5.f.dequeueInputBuffer(10000L);
                    if (n2 < 0) {
                        return;
                    }
                    if (encodedVideoFrame3 != a) {
                        EncodedVideoFrame encodedVideoFrame4 = encodedVideoFrame3;
                        q q7 = q5;
                        if (encodedVideoFrame4.isIDRFrame() && encodedVideoFrame4.codecType == CodecType.a && q7.q && q7.p == VideoDecoderDef.ConsumerScene.c) {
                            byte[] byArray;
                            byte[] byArray2;
                            int[] nArray;
                            byte[] byArray3 = new byte[encodedVideoFrame4.data.remaining()];
                            encodedVideoFrame4.data.get(byArray3);
                            encodedVideoFrame4.data.rewind();
                            int[] nArray2 = nArray = new int[]{-1};
                            Object object = byArray3;
                            int n7 = 0;
                            while (n7 + 4 < ((byte[])object).length && (n7 = EncodedVideoFrame.getNextNALHeaderPos(n7, ByteBuffer.wrap((byte[])object))) >= 0) {
                                if ((object[n7] & 0x1F) != 7) continue;
                                nArray2[0] = n7;
                                break;
                            }
                            if (nArray2[0] < 0) {
                                byArray2 = null;
                            } else {
                                void var26_34;
                                n7 = ((byte[])object).length - nArray2[0];
                                int n8 = nArray2[0];
                                while (var26_34 + 3 < ((byte[])object).length) {
                                    if (object[var26_34] == 0 && object[var26_34 + true] == 0 && object[var26_34 + 2] == 1 || object[var26_34] == 0 && object[var26_34 + true] == 0 && object[var26_34 + 2] == 0 && object[var26_34 + 3] == 1) {
                                        n7 = var26_34 - nArray2[0];
                                        break;
                                    }
                                    ++var26_34;
                                }
                                byte[] byArray4 = new byte[n7];
                                System.arraycopy(object, nArray2[0], byArray4, 0, byArray4.length);
                                byArray2 = byArray = byArray4;
                            }
                            if (byArray2 != null && nArray[0] >= 0) {
                                void var21_25;
                                Object var21_26 = null;
                                try {
                                    void var26_41;
                                    void var26_38;
                                    byte[] byArray5;
                                    nArray2 = byArray;
                                    object = q7.r;
                                    n7 = 0;
                                    int[] nArray3 = nArray2;
                                    byte[] byArray6 = new byte[nArray2.length];
                                    int n9 = 0;
                                    int n10 = 0;
                                    while (n10 < nArray3.length) {
                                        if (n10 < nArray3.length - 3 && nArray3[n10] == 0 && nArray3[n10 + 1] == 0 && nArray3[n10 + 2] == 3 && nArray3[n10 + 3] <= 3) {
                                            byArray6[n9++] = nArray3[n10];
                                            byArray6[n9++] = nArray3[n10 + 1];
                                            n10 += 3;
                                            continue;
                                        }
                                        byArray6[n9++] = nArray3[n10];
                                        ++n10;
                                    }
                                    if (n9 != nArray3.length) {
                                        byte[] byArray7 = new byte[n9];
                                        System.arraycopy(byArray6, 0, byArray7, 0, n9);
                                        byArray5 = byArray7;
                                    } else {
                                        byte[] byArray8;
                                        byArray5 = byArray8 = null;
                                    }
                                    if (byArray5 != null) {
                                        n7 = 1;
                                    } else {
                                        int[] nArray4 = nArray2;
                                    }
                                    byte[] byArray9 = ((p)object).a(new ByteArrayInputStream((byte[])var26_38));
                                    if (byArray9 != null && n7 != 0) {
                                        byte[] byArray10 = com.tencent.liteav.videoconsumer.decoder.p.a(byArray9);
                                    }
                                    void var21_27 = var26_41;
                                }
                                catch (Exception exception) {
                                    LiteavLog.e("HardwareVideoDecoder", "modify dec buffer error ", exception);
                                }
                                if (var21_25 != null) {
                                    encodedVideoFrame4.data = ByteBuffer.allocateDirect(byArray3.length - byArray.length + ((void)var21_25).length);
                                    if (nArray[0] > 0) {
                                        encodedVideoFrame4.data.put(byArray3, 0, nArray[0]);
                                    }
                                    encodedVideoFrame4.data.put((byte[])var21_25);
                                    encodedVideoFrame4.data.put(byArray3, nArray[0] + byArray.length, byArray3.length - nArray[0] - byArray.length);
                                    encodedVideoFrame4.data.rewind();
                                }
                            }
                        }
                        int n11 = encodedVideoFrame3.data.remaining();
                        mediaFormat2[n2].put(encodedVideoFrame3.data);
                        q5.f.queueInputBuffer(n2, 0, n11, TimeUnit.MILLISECONDS.toMicros(encodedVideoFrame3.pts), 0);
                        if (q5.g != null) {
                            q5.g.d();
                        }
                    } else {
                        LiteavLog.i("HardwareVideoDecoder", "feedDataToMediaCodec BUFFER_FLAG_END_OF_STREAM");
                        q5.f.queueInputBuffer(n2, 0, 0, 0L, 4);
                    }
                }
                boolean bl = true;
                if (!bl) return;
                EncodedVideoFrame encodedVideoFrame5 = q4.i.removeFirst();
                if (encodedVideoFrame5 == null) continue;
                encodedVideoFrame5.release();
            }
            return;
        }
        catch (Exception exception) {
            LiteavLog.e("HardwareVideoDecoder", "decode failed.", exception);
            q4.a(g.c.n, "VideoDecode: decode error, restart decoder message:" + exception.getMessage(), new Object[0]);
            return;
        }
    }

    static /* synthetic */ void a(q q2, Object object, at at2) {
        at at3 = at2;
        Object object2 = object;
        q q3 = q2;
        LiteavLog.i("HardwareVideoDecoder", "Start internal");
        if (q3.k != null) {
            LiteavLog.w("HardwareVideoDecoder", "Decoder already started.");
            return;
        }
        q3.g = at3;
        if (q3.a(object2)) {
            a a2 = new a(0);
            boolean bl = q3.a(a2, q3.x, q3.u);
            if (bl || q3.a(a2, false, q3.u)) {
                q3.f = a2.a;
                if (q3.g != null) {
                    q3.g.a(q3.x && bl);
                }
                q3.c.notifyEvent(g.b.B, "Start decoder success", new Object[0]);
                return;
            }
            q3.a(a2.b, "decoder config fail, message:" + a2.c + " exception:" + a2.d.getMessage(), new Object[0]);
        }
    }

    static /* synthetic */ void a(q q2, VideoDecoderDef.ConsumerScene consumerScene) {
        q2.p = consumerScene;
    }

    static /* synthetic */ void a(q q2) {
        q q3 = q2;
        LiteavLog.i("HardwareVideoDecoder", "Stop internal");
        q3.a();
        if (q3.f != null) {
            com.tencent.liteav.videoconsumer.decoder.q.a(q3.f);
            q3.f = null;
        }
        q q4 = q3;
        for (EncodedVideoFrame encodedVideoFrame : q4.i) {
            if (encodedVideoFrame == null) continue;
            encodedVideoFrame.release();
        }
        q4.i.clear();
        q4 = q3;
        LiteavLog.i("HardwareVideoDecoder", "uninitialize gl components");
        if (q4.b()) {
            if (q4.m != null) {
                q4.m.b();
            }
            if (q4.o != null) {
                q4.o.release();
                q4.o = null;
            }
            if (q4.n != null) {
                q4.n.release();
                q4.n = null;
            }
            if (q4.w != null) {
                q4.w.b();
                q4.w = null;
            }
            if (q4.v != null) {
                q4.v.a();
                q4.v = null;
            }
            OpenGlUtils.deleteTexture(q4.l);
            q4.l = -1;
            try {
                if (q4.k != null) {
                    q4.k.b();
                    q4.k.e();
                }
            }
            catch (f f2) {
                LiteavLog.e("HardwareVideoDecoder", "destroy EGLCore failed.", f2);
            }
            q4.k = null;
        }
        q3.j = true;
    }

    static final class a {
        public MediaCodec a = null;
        public g.c b = null;
        public String c = null;
        public Exception d = null;

        private a() {
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

