/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.encoder;

import android.media.MediaFormat;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.videobase.g;
import com.tencent.liteav.videoproducer.encoder.VideoEncoderDef;
import java.nio.ByteBuffer;

@JNINamespace(value="liteav::video")
public class NativeEncoderDataListener
implements VideoEncoderDef.VideoEncoderDataListener {
    public static final String TAG = "NativeEncoderDataListener";
    private long mNativeVideoEncodeDataListener = 0L;
    private int mStreamType = 0;

    @CalledByNative
    public NativeEncoderDataListener(long nativeClient, int streamType) {
        this.mNativeVideoEncodeDataListener = nativeClient;
        this.mStreamType = streamType;
    }

    @CalledByNative
    public synchronized void reset() {
        this.mNativeVideoEncodeDataListener = 0L;
    }

    @Override
    public synchronized void onOutputFormatChanged(MediaFormat format) {
    }

    @Override
    public synchronized void onEncodedNAL(EncodedVideoFrame nal, boolean isEos) {
        if (this.mNativeVideoEncodeDataListener != 0L) {
            NativeEncoderDataListener nativeEncoderDataListener = this;
            EncodedVideoFrame encodedVideoFrame = nal;
            nativeEncoderDataListener.nativeOnEncodedNAL(nativeEncoderDataListener.mNativeVideoEncodeDataListener, this.mStreamType, encodedVideoFrame, encodedVideoFrame.data, nal.nalType.mValue, nal.profileType.mValue, nal.codecType.mValue, nal.rotation, nal.dts, nal.pts, nal.gopIndex, nal.gopFrameIndex, nal.frameIndex, nal.refFrameIndex, nal.width, nal.height, nal.svcInfo != null, nal.svcInfo == null ? 0 : nal.svcInfo);
            return;
        }
        LiteavLog.d(TAG, "onEncodedNAL nativeclient is zero.");
    }

    @Override
    public synchronized void onEncodedFail(g.a code) {
        if (this.mNativeVideoEncodeDataListener != 0L) {
            NativeEncoderDataListener nativeEncoderDataListener = this;
            nativeEncoderDataListener.nativeOnEncodedFail(nativeEncoderDataListener.mNativeVideoEncodeDataListener, this.mStreamType, g.a(code));
            return;
        }
        LiteavLog.i(TAG, "onEncodedFail nativeclient is zero.");
    }

    private native void nativeOnEncodedNAL(long var1, int var3, EncodedVideoFrame var4, ByteBuffer var5, int var6, int var7, int var8, int var9, long var10, long var12, long var14, long var16, long var18, long var20, int var22, int var23, boolean var24, int var25);

    private native void nativeOnEncodedFail(long var1, int var3, int var4);
}

