/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.live;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import com.tencent.liteav.audio.TXAudioEffectManager;
import com.tencent.liteav.audio.TXAudioEffectManagerImpl;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.beauty.TXBeautyManager;
import com.tencent.liteav.beauty.TXBeautyManagerImpl;
import com.tencent.liteav.device.TXDeviceManager;
import com.tencent.liteav.device.TXDeviceManagerImpl;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.utils.Rotation;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.live2.V2TXLiveDef;
import com.tencent.live2.V2TXLivePusher;
import com.tencent.live2.V2TXLivePusherObserver;
import com.tencent.live2.impl.V2TXLiveDefInner;
import com.tencent.live2.impl.a.b;
import com.tencent.rtmp.ui.TXCloudVideoView;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;
import org.json.JSONArray;
import org.json.JSONObject;

@JNINamespace(value="liteav")
public class V2TXLivePusherJni
extends V2TXLivePusher {
    private static final String TAG = "V2TXLivePusherJni";
    private long mNativeV2TXLivePusherJni;
    private V2TXLivePusherObserver mObserver;
    private TXAudioEffectManager mAudioEffectManager;
    private TXBeautyManager mBeautyManager;
    private TXDeviceManager mDeviceManager;
    private V2TXLiveDefInner.SurfaceSize mSurfaceSize;
    private Surface mSurface;

    public V2TXLivePusherJni(Context context, int mode) {
        ContextUtils.initApplicationContext(context.getApplicationContext());
        ContextUtils.setDataDirectorySuffix("liteav");
        this.mNativeV2TXLivePusherJni = V2TXLivePusherJni.nativeCreate(new WeakReference<V2TXLivePusherJni>(this), mode);
        this.mAudioEffectManager = new TXAudioEffectManagerImpl(V2TXLivePusherJni.nativeCreateAudioEffectManager(this.mNativeV2TXLivePusherJni));
        this.mBeautyManager = new TXBeautyManagerImpl(V2TXLivePusherJni.nativeCreateBeautyManager(this.mNativeV2TXLivePusherJni));
        this.mDeviceManager = new TXDeviceManagerImpl(V2TXLivePusherJni.nativeCreateDeviceManager(this.mNativeV2TXLivePusherJni));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    @Override
    public void release() {
        if (this.mNativeV2TXLivePusherJni != 0L) {
            V2TXLivePusherJni.nativeDestroy(this.mNativeV2TXLivePusherJni);
            this.mNativeV2TXLivePusherJni = 0L;
        }
    }

    @Override
    public void setObserver(V2TXLivePusherObserver observer) {
        this.mObserver = observer;
        if (observer != null && observer instanceof b) {
            V2TXLivePusherJni.nativeEnableExtensionCallback(this.mNativeV2TXLivePusherJni, true);
        }
    }

    @Override
    public int setRenderView(TXCloudVideoView view) {
        return V2TXLivePusherJni.nativeSetRenderView(this.mNativeV2TXLivePusherJni, new DisplayTarget(view));
    }

    @Override
    public int setRenderView(TextureView view) {
        return V2TXLivePusherJni.nativeSetRenderView(this.mNativeV2TXLivePusherJni, new DisplayTarget(view));
    }

    @Override
    public int setRenderView(SurfaceView view) {
        return V2TXLivePusherJni.nativeSetRenderView(this.mNativeV2TXLivePusherJni, new DisplayTarget(view));
    }

    @Override
    public int setRenderMirror(V2TXLiveDef.V2TXLiveMirrorType mirrorType) {
        return V2TXLivePusherJni.nativeSetRenderMirror(this.mNativeV2TXLivePusherJni, mirrorType.ordinal());
    }

    @Override
    public int setEncoderMirror(boolean mirror) {
        return V2TXLivePusherJni.nativeSetEncoderMirror(this.mNativeV2TXLivePusherJni, mirror);
    }

    @Override
    public int setRenderRotation(V2TXLiveDef.V2TXLiveRotation liveRotation) {
        Rotation rotation;
        switch (liveRotation) {
            case V2TXLiveRotation90: {
                rotation = Rotation.b;
                break;
            }
            case V2TXLiveRotation180: {
                rotation = Rotation.c;
                break;
            }
            case V2TXLiveRotation270: {
                rotation = Rotation.d;
                break;
            }
            default: {
                rotation = Rotation.a;
            }
        }
        return V2TXLivePusherJni.nativeSetRenderRotation(this.mNativeV2TXLivePusherJni, rotation.mValue);
    }

    @Override
    public int startCamera(boolean frontCamera) {
        return V2TXLivePusherJni.nativeStartCamera(this.mNativeV2TXLivePusherJni, frontCamera);
    }

    @Override
    public int stopCamera() {
        return V2TXLivePusherJni.nativeStopCamera(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int startMicrophone() {
        return V2TXLivePusherJni.nativeStartMicrophone(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int stopMicrophone() {
        return V2TXLivePusherJni.nativeStopMicrophone(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int startVirtualCamera(Bitmap image) {
        return V2TXLivePusherJni.nativeStartVirtualCamera(this.mNativeV2TXLivePusherJni, image);
    }

    @Override
    public int stopVirtualCamera() {
        return V2TXLivePusherJni.nativeStopVirtualCamera(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int startScreenCapture() {
        return V2TXLivePusherJni.nativeStartScreenCapture(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int stopScreenCapture() {
        return V2TXLivePusherJni.nativeStopScreenCapture(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int pauseAudio() {
        return V2TXLivePusherJni.nativePauseAudio(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int resumeAudio() {
        return V2TXLivePusherJni.nativeResumeAudio(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int pauseVideo() {
        return V2TXLivePusherJni.nativePauseVideo(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int resumeVideo() {
        return V2TXLivePusherJni.nativeResumeVideo(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int startPush(String url) {
        return V2TXLivePusherJni.nativeStartPush(this.mNativeV2TXLivePusherJni, url);
    }

    @Override
    public int stopPush() {
        return V2TXLivePusherJni.nativeStopPush(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int isPushing() {
        return V2TXLivePusherJni.nativeIsPushing(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int setAudioQuality(V2TXLiveDef.V2TXLiveAudioQuality quality) {
        return V2TXLivePusherJni.nativeSetAudioQuality(this.mNativeV2TXLivePusherJni, quality.ordinal());
    }

    @Override
    public int setVideoQuality(V2TXLiveDef.V2TXLiveVideoEncoderParam param) {
        return V2TXLivePusherJni.nativeSetVideoQuality(this.mNativeV2TXLivePusherJni, param.videoResolution.ordinal(), param.videoResolutionMode.ordinal(), param.videoFps, param.videoBitrate, param.minVideoBitrate);
    }

    @Override
    public TXAudioEffectManager getAudioEffectManager() {
        return this.mAudioEffectManager;
    }

    @Override
    public TXBeautyManager getBeautyManager() {
        return this.mBeautyManager;
    }

    @Override
    public TXDeviceManager getDeviceManager() {
        return this.mDeviceManager;
    }

    @Override
    public int snapshot() {
        return V2TXLivePusherJni.nativeSnapshot(this.mNativeV2TXLivePusherJni);
    }

    @Override
    public int setWatermark(Bitmap image, float x2, float y2, float scale) {
        return V2TXLivePusherJni.nativeSetWatermark(this.mNativeV2TXLivePusherJni, image, x2, y2, scale);
    }

    @Override
    public int enableVolumeEvaluation(int intervalMs) {
        return V2TXLivePusherJni.nativeEnableVolumeEvaluation(this.mNativeV2TXLivePusherJni, intervalMs);
    }

    @Override
    public int enableCustomVideoProcess(boolean enable, V2TXLiveDef.V2TXLivePixelFormat pixelFormat, V2TXLiveDef.V2TXLiveBufferType bufferType) {
        return V2TXLivePusherJni.nativeEnableCustomVideoProcess(this.mNativeV2TXLivePusherJni, enable, pixelFormat.ordinal(), bufferType.ordinal());
    }

    @Override
    public int enableCustomVideoCapture(boolean enable) {
        return V2TXLivePusherJni.nativeEnableCustomVideoCapture(this.mNativeV2TXLivePusherJni, enable);
    }

    @Override
    public int sendCustomVideoFrame(V2TXLiveDef.V2TXLiveVideoFrame videoFrame) {
        PixelFrame pixelFrame = new PixelFrame();
        if (!V2TXLivePusherJni.v2VideoFrameToPixelFrame(videoFrame, pixelFrame)) {
            return -1;
        }
        return V2TXLivePusherJni.nativeSendCustomVideoFrame(this.mNativeV2TXLivePusherJni, pixelFrame);
    }

    @Override
    public int enableCustomAudioCapture(boolean enable) {
        return V2TXLivePusherJni.nativeEnableCustomAudioCapture(this.mNativeV2TXLivePusherJni, enable);
    }

    @Override
    public int sendCustomAudioFrame(V2TXLiveDef.V2TXLiveAudioFrame audioFrame) {
        return V2TXLivePusherJni.nativeSendCustomAudioFrame(this.mNativeV2TXLivePusherJni, audioFrame.data, audioFrame.sampleRate, audioFrame.channel);
    }

    @Override
    public int sendSeiMessage(int payloadType, byte[] data) {
        return V2TXLivePusherJni.nativeSendSeiMessage(this.mNativeV2TXLivePusherJni, payloadType, data);
    }

    @Override
    public void showDebugView(boolean isShow) {
        V2TXLivePusherJni.nativeShowDebugView(this.mNativeV2TXLivePusherJni, isShow);
    }

    @Override
    public int setProperty(String key, Object value) {
        String string = key;
        int n2 = -1;
        switch (string.hashCode()) {
            case 2132058329: {
                if (!string.equals("setVideoQualityEx")) break;
                n2 = 0;
                break;
            }
            case -631683741: {
                if (!string.equals("enableANS")) break;
                n2 = 1;
                break;
            }
            case -631683974: {
                if (!string.equals("enableAGC")) break;
                n2 = 2;
                break;
            }
            case 1538362833: {
                if (!string.equals("setMetaData")) break;
                n2 = 3;
                break;
            }
            case 2085561276: {
                if (!string.equals("setFramework")) break;
                n2 = 4;
                break;
            }
            case 1120433643: {
                if (!string.equals("setSurface")) break;
                n2 = 5;
                break;
            }
            case 480042124: {
                if (!string.equals("setSurfaceSize")) break;
                n2 = 6;
                break;
            }
            case 1309735633: {
                if (!string.equals("enableRealtimeMode")) break;
                n2 = 7;
            }
        }
        switch (n2) {
            case 0: {
                if (!(value instanceof String)) {
                    LiteavLog.e(TAG, "setProperty error, key:" + key + ", value:" + value);
                    return -2;
                }
                String string2 = (String)value;
                try {
                    JSONObject jSONObject = new JSONObject(string2);
                    int n3 = jSONObject.optInt("videoWidth");
                    int n4 = jSONObject.optInt("videoHeight");
                    int n5 = jSONObject.optInt("videoFps");
                    int n6 = jSONObject.optInt("videoBitrate");
                    int n7 = jSONObject.optInt("minVideoBitrate");
                    int n8 = jSONObject.optInt("videoGop");
                    V2TXLivePusherJni.nativeSetVideoQualityEx(this.mNativeV2TXLivePusherJni, n3, n4, n5, n6, n7, n8);
                    break;
                }
                catch (Exception exception) {
                    Log.e((String)TAG, (String)("setProperty error, key:" + key + ", value:" + value));
                    return -2;
                }
            }
            case 1: 
            case 2: {
                return this.enable3A(key, value);
            }
            case 3: {
                if (!(value instanceof HashMap)) {
                    LiteavLog.e(TAG, "setProperty error, key:" + key + ", value:" + value);
                    return -2;
                }
                HashMap hashMap = (HashMap)value;
                V2TXLivePusherJni.nativeSetMetaData(this.mNativeV2TXLivePusherJni, hashMap);
                break;
            }
            case 4: {
                if (!(value instanceof String)) {
                    LiteavLog.e(TAG, "setProperty error, key:" + key + ", value:" + value);
                    return -2;
                }
                String string3 = (String)value;
                try {
                    JSONObject jSONObject = new JSONObject(string3);
                    int n9 = jSONObject.optInt("framework", 0);
                    int n10 = jSONObject.optInt("component", 0);
                    V2TXLivePusherJni.nativeSetFramework(this.mNativeV2TXLivePusherJni, n9, n10);
                    break;
                }
                catch (Exception exception) {
                    LiteavLog.e(TAG, "setProperty error, key:" + key + ", value:" + value, exception);
                    return -2;
                }
            }
            case 5: {
                if (value == null) {
                    this.mSurface = null;
                    V2TXLivePusherJni.nativeSetRenderView(this.mNativeV2TXLivePusherJni, null);
                    break;
                }
                if (value instanceof Surface) {
                    this.mSurface = (Surface)value;
                    if (this.mSurfaceSize == null) break;
                    V2TXLivePusherJni.nativeSetRenderView(this.mNativeV2TXLivePusherJni, new DisplayTarget(this.mSurface, this.mSurfaceSize.width, this.mSurfaceSize.height));
                    break;
                }
                LiteavLog.e(TAG, "setProperty error, key:" + key + ", value:" + value);
                return -2;
            }
            case 6: {
                if (value == null) {
                    this.mSurfaceSize = null;
                    break;
                }
                if (value instanceof V2TXLiveDefInner.SurfaceSize) {
                    this.mSurfaceSize = (V2TXLiveDefInner.SurfaceSize)value;
                    if (this.mSurface == null) break;
                    V2TXLivePusherJni.nativeSetRenderView(this.mNativeV2TXLivePusherJni, new DisplayTarget(this.mSurface, this.mSurfaceSize.width, this.mSurfaceSize.height));
                    break;
                }
                LiteavLog.e(TAG, "setProperty error, key:" + key + ", value:" + value);
                return -2;
            }
            case 7: {
                if (!(value instanceof Boolean)) {
                    return -2;
                }
                V2TXLivePusherJni.nativeEnableRealtimeMode(this.mNativeV2TXLivePusherJni, (Boolean)value);
                break;
            }
            default: {
                LiteavLog.e(TAG, "setProperty error, key:" + key + ", value:" + value);
                return -2;
            }
        }
        return 0;
    }

    @Override
    public int setMixTranscodingConfig(V2TXLiveDef.V2TXLiveTranscodingConfig config) {
        String string = "";
        if (config != null) {
            JSONObject jSONObject = null;
            try {
                jSONObject = new JSONObject();
                jSONObject.put("videoWidth", config.videoWidth);
                jSONObject.put("videoHeight", config.videoHeight);
                jSONObject.put("videoBitrate", config.videoBitrate);
                jSONObject.put("videoFramerate", config.videoFramerate);
                jSONObject.put("videoGOP", config.videoGOP);
                jSONObject.put("backgroundColor", config.backgroundColor);
                jSONObject.put("backgroundImage", (Object)(TextUtils.isEmpty((CharSequence)config.backgroundImage) ? "" : config.backgroundImage));
                jSONObject.put("audioSampleRate", config.audioSampleRate);
                jSONObject.put("audioBitrate", config.audioBitrate);
                jSONObject.put("audioChannels", config.audioChannels);
                jSONObject.put("outputStreamId", (Object)(TextUtils.isEmpty((CharSequence)config.outputStreamId) ? "" : config.outputStreamId));
                JSONArray jSONArray = new JSONArray();
                ArrayList<V2TXLiveDef.V2TXLiveMixStream> arrayList = config.mixStreams;
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    V2TXLiveDef.V2TXLiveMixStream v2TXLiveMixStream = (V2TXLiveDef.V2TXLiveMixStream)arrayList.get(i2);
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("userId", (Object)(TextUtils.isEmpty((CharSequence)v2TXLiveMixStream.userId) ? "" : v2TXLiveMixStream.userId));
                    jSONObject2.put("streamId", (Object)(TextUtils.isEmpty((CharSequence)v2TXLiveMixStream.streamId) ? "" : v2TXLiveMixStream.streamId));
                    jSONObject2.put("x", v2TXLiveMixStream.x);
                    jSONObject2.put("y", v2TXLiveMixStream.y);
                    jSONObject2.put("width", v2TXLiveMixStream.width);
                    jSONObject2.put("height", v2TXLiveMixStream.height);
                    jSONObject2.put("zOrder", v2TXLiveMixStream.zOrder);
                    jSONObject2.put("inputType", v2TXLiveMixStream.inputType.ordinal());
                    jSONArray.put((Object)jSONObject2);
                }
                jSONObject.put("mixStreamList", (Object)jSONArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (jSONObject != null) {
                string = jSONObject.toString();
            }
        }
        return V2TXLivePusherJni.nativeSetMixTranscodingConfig(this.mNativeV2TXLivePusherJni, string);
    }

    public void setDisplayOrientation(int orientation) {
        V2TXLivePusherJni.nativeSetDisplayOrientation(this.mNativeV2TXLivePusherJni, orientation);
    }

    @CalledByNative
    public void onError(int code, String msg, Bundle extraInfo) {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver != null) {
            v2TXLivePusherObserver.onError(code, msg, extraInfo);
        }
    }

    @CalledByNative
    public void onWarning(int code, String msg, Bundle extraInfo) {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver != null) {
            v2TXLivePusherObserver.onWarning(code, msg, extraInfo);
        }
    }

    @CalledByNative
    public void onCaptureFirstAudioFrame() {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver != null) {
            v2TXLivePusherObserver.onCaptureFirstAudioFrame();
        }
    }

    @CalledByNative
    public void onCaptureFirstVideoFrame() {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver != null) {
            v2TXLivePusherObserver.onCaptureFirstVideoFrame();
        }
    }

    @CalledByNative
    public void onMicrophoneVolumeUpdate(int volume) {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver != null) {
            v2TXLivePusherObserver.onMicrophoneVolumeUpdate(volume);
        }
    }

    @CalledByNative
    public void onPushStatusUpdate(int statusCode, String msg, Bundle extraInfo) {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        V2TXLiveDef.V2TXLivePushStatus v2TXLivePushStatus = V2TXLiveDef.V2TXLivePushStatus.V2TXLivePushStatusDisconnected;
        switch (statusCode) {
            case 0: {
                v2TXLivePushStatus = V2TXLiveDef.V2TXLivePushStatus.V2TXLivePushStatusConnecting;
                msg = "connecting to the server.";
                break;
            }
            case 1: {
                v2TXLivePushStatus = V2TXLiveDef.V2TXLivePushStatus.V2TXLivePushStatusConnectSuccess;
                msg = "connected to the server successfully.";
                break;
            }
            case 2: {
                v2TXLivePushStatus = V2TXLiveDef.V2TXLivePushStatus.V2TXLivePushStatusReconnecting;
                msg = "reconnecting to the server.";
                break;
            }
            case 3: {
                v2TXLivePushStatus = V2TXLiveDef.V2TXLivePushStatus.V2TXLivePushStatusDisconnected;
                msg = "disconnected from the server.";
            }
        }
        if (v2TXLivePusherObserver != null) {
            v2TXLivePusherObserver.onPushStatusUpdate(v2TXLivePushStatus, msg, extraInfo);
        }
    }

    @CalledByNative
    public void onStatisticsUpdate(int appCpu, int systemCpu, int width, int height, int fps, int videoBitrate, int audioBitrate) {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver != null) {
            V2TXLiveDef.V2TXLivePusherStatistics v2TXLivePusherStatistics = new V2TXLiveDef.V2TXLivePusherStatistics();
            new V2TXLiveDef.V2TXLivePusherStatistics().appCpu = appCpu;
            v2TXLivePusherStatistics.systemCpu = systemCpu;
            v2TXLivePusherStatistics.width = width;
            v2TXLivePusherStatistics.height = height;
            v2TXLivePusherStatistics.fps = fps;
            v2TXLivePusherStatistics.videoBitrate = videoBitrate;
            v2TXLivePusherStatistics.audioBitrate = audioBitrate;
            v2TXLivePusherObserver.onStatisticsUpdate(v2TXLivePusherStatistics);
        }
    }

    @CalledByNative
    public void onSnapshotComplete(Bitmap image) {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver != null) {
            v2TXLivePusherObserver.onSnapshotComplete(image);
        }
    }

    @CalledByNative
    public void onGLContextCreated() {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver != null) {
            v2TXLivePusherObserver.onGLContextCreated();
        }
    }

    @CalledByNative
    public int onCustomPreprocessFrame(PixelFrame srcFrame, PixelFrame dstFrame) {
        V2TXLiveDef.V2TXLiveVideoFrame v2TXLiveVideoFrame = new V2TXLiveDef.V2TXLiveVideoFrame();
        if (!V2TXLivePusherJni.pixelFrameToV2VideoFrame(srcFrame, v2TXLiveVideoFrame)) {
            return -1;
        }
        V2TXLiveDef.V2TXLiveVideoFrame v2TXLiveVideoFrame2 = new V2TXLiveDef.V2TXLiveVideoFrame();
        if (!V2TXLivePusherJni.pixelFrameToV2VideoFrame(dstFrame, v2TXLiveVideoFrame2)) {
            return -1;
        }
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver != null) {
            int n2 = v2TXLivePusherObserver.onProcessVideoFrame(v2TXLiveVideoFrame, v2TXLiveVideoFrame2);
            if (!V2TXLivePusherJni.v2VideoFrameToPixelFrame(v2TXLiveVideoFrame2, dstFrame)) {
                return -1;
            }
            return n2;
        }
        return -1;
    }

    @CalledByNative
    public void onGLContextDestroyed() {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver != null) {
            v2TXLivePusherObserver.onGLContextDestroyed();
        }
    }

    @CalledByNative
    public void onSetMixTranscodingConfig(int code, String msg) {
        V2TXLivePusherObserver v2TXLivePusherObserver = this.mObserver;
        if (v2TXLivePusherObserver != null) {
            v2TXLivePusherObserver.onSetMixTranscodingConfig(code, msg);
        }
    }

    @CalledByNative
    public static V2TXLivePusherJni weakToStrongReference(WeakReference<V2TXLivePusherJni> weakReference) {
        return (V2TXLivePusherJni)weakReference.get();
    }

    private static native long nativeCreate(WeakReference<V2TXLivePusherJni> var0, int var1);

    private static native void nativeDestroy(long var0);

    private static native void nativeEnableExtensionCallback(long var0, boolean var2);

    private static native int nativeSetRenderView(long var0, DisplayTarget var2);

    private static native int nativeSetRenderMirror(long var0, int var2);

    private static native int nativeSetEncoderMirror(long var0, boolean var2);

    private static native int nativeSetRenderRotation(long var0, int var2);

    private static native int nativeStartCamera(long var0, boolean var2);

    private static native int nativeStopCamera(long var0);

    private static native int nativeStartMicrophone(long var0);

    private static native int nativeStopMicrophone(long var0);

    private static native int nativeStartVirtualCamera(long var0, Bitmap var2);

    private static native int nativeStopVirtualCamera(long var0);

    private static native int nativeStartScreenCapture(long var0);

    private static native int nativeStopScreenCapture(long var0);

    private static native int nativePauseAudio(long var0);

    private static native int nativeResumeAudio(long var0);

    private static native int nativePauseVideo(long var0);

    private static native int nativeResumeVideo(long var0);

    private static native int nativeStartPush(long var0, String var2);

    private static native int nativeStopPush(long var0);

    private static native int nativeIsPushing(long var0);

    private static native int nativeSetAudioQuality(long var0, int var2);

    private static native int nativeSetVideoQuality(long var0, int var2, int var3, int var4, int var5, int var6);

    private static native int nativeSetVideoQualityEx(long var0, int var2, int var3, int var4, int var5, int var6, int var7);

    private static native void nativeSetDisplayOrientation(long var0, int var2);

    private static native long nativeCreateAudioEffectManager(long var0);

    private static native long nativeCreateBeautyManager(long var0);

    private static native long nativeCreateDeviceManager(long var0);

    private static native int nativeSnapshot(long var0);

    private static native int nativeSetWatermark(long var0, Bitmap var2, float var3, float var4, float var5);

    private static native int nativeEnableVolumeEvaluation(long var0, int var2);

    private static native int nativeEnableCustomVideoProcess(long var0, boolean var2, int var3, int var4);

    private static native int nativeEnableCustomVideoCapture(long var0, boolean var2);

    private static native int nativeSendCustomVideoFrame(long var0, PixelFrame var2);

    private static native int nativeEnableCustomAudioCapture(long var0, boolean var2);

    private static native int nativeSendCustomAudioFrame(long var0, byte[] var2, int var3, int var4);

    private static native int nativeSendSeiMessage(long var0, int var2, byte[] var3);

    private static native void nativeShowDebugView(long var0, boolean var2);

    private static native int nativeSetMixTranscodingConfig(long var0, String var2);

    private static native void nativeSetFramework(long var0, int var2, int var3);

    private static native void nativeSetMetaData(long var0, HashMap<String, String> var2);

    private static native void nativeEnableRealtimeMode(long var0, boolean var2);

    private static native void nativeEnableANS(long var0, boolean var2, int var3);

    private static native void nativeEnableAGC(long var0, boolean var2, int var3);

    private int enable3A(String key, Object value) {
        if (!(value instanceof String)) {
            LiteavLog.e(TAG, "setProperty error, key:" + key + ", value:" + value);
            return -2;
        }
        String string = (String)value;
        try {
            JSONObject jSONObject = new JSONObject(string);
            boolean bl = jSONObject.getBoolean("enable");
            int n2 = jSONObject.getInt("level");
            if (n2 < 0 || n2 > 100) {
                Log.e((String)TAG, (String)("setProperty error, key:" + key + ", value:" + value));
                return -2;
            }
            if (key.equals("enableAGC")) {
                V2TXLivePusherJni.nativeEnableAGC(this.mNativeV2TXLivePusherJni, bl, n2);
            } else if (key.equals("enableANS")) {
                V2TXLivePusherJni.nativeEnableANS(this.mNativeV2TXLivePusherJni, bl, n2);
            }
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("setProperty error, key:" + key + ", value:" + value));
            return -2;
        }
        return 0;
    }

    private static boolean v2VideoFrameToPixelFrame(V2TXLiveDef.V2TXLiveVideoFrame v2Frame, PixelFrame pixelFrame) {
        switch (v2Frame.pixelFormat) {
            case V2TXLivePixelFormatI420: {
                pixelFrame.setPixelFormatType(GLConstants.PixelFormatType.a);
                break;
            }
            case V2TXLivePixelFormatTexture2D: {
                pixelFrame.setPixelFormatType(GLConstants.PixelFormatType.f);
                break;
            }
            default: {
                return false;
            }
        }
        switch (v2Frame.bufferType) {
            case V2TXLiveBufferTypeTexture: {
                pixelFrame.setPixelBufferType(GLConstants.PixelBufferType.b);
                if (v2Frame.texture != null) {
                    pixelFrame.setTextureId(v2Frame.texture.textureId);
                    if (v2Frame.texture.eglContext10 != null) {
                        pixelFrame.setGLContext(v2Frame.texture.eglContext10);
                    }
                    if (v2Frame.texture.eglContext14 != null) {
                        pixelFrame.setGLContext(v2Frame.texture.eglContext14);
                    }
                    if (pixelFrame.getGLContext() != null) break;
                    EGL10 eGL10 = (EGL10)EGLContext.getEGL();
                    if (eGL10 == null) {
                        return false;
                    }
                    pixelFrame.setGLContext(eGL10.eglGetCurrentContext());
                    break;
                }
                return false;
            }
            case V2TXLiveBufferTypeByteArray: {
                pixelFrame.setPixelBufferType(GLConstants.PixelBufferType.d);
                pixelFrame.setData(v2Frame.data);
                break;
            }
            case V2TXLiveBufferTypeByteBuffer: {
                pixelFrame.setPixelBufferType(GLConstants.PixelBufferType.a);
                pixelFrame.setBuffer(v2Frame.buffer);
                break;
            }
            default: {
                return false;
            }
        }
        pixelFrame.setWidth(v2Frame.width);
        pixelFrame.setHeight(v2Frame.height);
        pixelFrame.setRotation(Rotation.a(v2Frame.rotation));
        return true;
    }

    private static boolean pixelFrameToV2VideoFrame(PixelFrame pixelFrame, V2TXLiveDef.V2TXLiveVideoFrame v2Frame) {
        switch (pixelFrame.getPixelFormatType()) {
            case a: {
                v2Frame.pixelFormat = V2TXLiveDef.V2TXLivePixelFormat.V2TXLivePixelFormatI420;
                break;
            }
            case f: {
                v2Frame.pixelFormat = V2TXLiveDef.V2TXLivePixelFormat.V2TXLivePixelFormatTexture2D;
                break;
            }
            default: {
                return false;
            }
        }
        switch (pixelFrame.getPixelBufferType()) {
            case b: {
                v2Frame.bufferType = V2TXLiveDef.V2TXLiveBufferType.V2TXLiveBufferTypeTexture;
                v2Frame.texture = new V2TXLiveDef.V2TXLiveTexture();
                v2Frame.texture.textureId = pixelFrame.getTextureId();
                if (pixelFrame.getGLContext() instanceof EGLContext) {
                    v2Frame.texture.eglContext10 = (EGLContext)pixelFrame.getGLContext();
                    break;
                }
                if (Build.VERSION.SDK_INT < 17 || !(pixelFrame.getGLContext() instanceof android.opengl.EGLContext)) break;
                v2Frame.texture.eglContext14 = (android.opengl.EGLContext)pixelFrame.getGLContext();
                break;
            }
            case d: {
                v2Frame.bufferType = V2TXLiveDef.V2TXLiveBufferType.V2TXLiveBufferTypeByteArray;
                v2Frame.data = pixelFrame.getData();
                break;
            }
            case a: {
                v2Frame.bufferType = V2TXLiveDef.V2TXLiveBufferType.V2TXLiveBufferTypeByteBuffer;
                v2Frame.buffer = pixelFrame.getBuffer();
                break;
            }
            default: {
                return false;
            }
        }
        v2Frame.width = pixelFrame.getWidth();
        v2Frame.height = pixelFrame.getHeight();
        v2Frame.rotation = pixelFrame.getRotation().mValue;
        return true;
    }

    @CalledByNative
    public void onPushEvent(int code, Bundle params) {
    }

    @CalledByNative
    public void onPushNetStatus(Bundle params) {
    }

    @CalledByNative
    public void onNetworkQuality(int quality) {
    }

    @CalledByNative
    public void onEnterRoom(int result, String msg) {
    }

    @CalledByNative
    public void onExitRoom(int reason, String msg) {
    }

    @CalledByNative
    public void onUserOnline(String userId) {
    }

    @CalledByNative
    public void onUserOffline(String userId) {
    }

    @CalledByNative
    public void onUserVideoAvailable(String userId, int streamType, boolean available) {
    }

    @CalledByNative
    public void onUserAudioAvailable(String userId, boolean available) {
    }
}

